/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Request;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

class ChunkedInputStream
extends StreamImpl {
    private Request request;
    private ReadStream next;
    private int available;
    private byte[] buf = new byte[8];

    ChunkedInputStream() {
    }

    void init(Request request, ReadStream next) {
        this.request = request;
        this.next = next;
        this.available = 0;
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() {
        return this.available;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.available > 0) {
            if (this.available < len) {
                len = this.available;
            }
            if ((len = this.next.read(buf, offset, len)) > 0) {
                this.available -= len;
            }
        } else if (this.available == 0) {
            this.available = this.readChunkLength();
            if (this.available > 0) {
                if (this.available < len) {
                    len = this.available;
                }
                if ((len = this.next.read(buf, offset, len)) > 0) {
                    this.available -= len;
                }
            } else {
                this.available = -1;
                len = -1;
            }
        } else {
            len = -1;
        }
        return len;
    }

    private int readChunkLength() throws IOException {
        int length = 0;
        int ch = this.next.read();
        while (ch == 13 || ch == 32 || ch == 10) {
            ch = this.next.read();
        }
        while (ch > 0 && ch != 13 && ch != 10) {
            if (ch >= 48 && ch <= 57) {
                length = 16 * length + ch - 48;
            } else if (ch >= 97 && ch <= 102) {
                length = 16 * length + ch - 97 + 10;
            } else if (ch >= 65 && ch <= 70) {
                length = 16 * length + ch - 65 + 10;
            } else if (ch != 32 && ch != 9) {
                throw new IOException("HTTP/1.1 protocol error: bad chunk");
            }
            ch = this.next.read();
        }
        if (ch == 13) {
            ch = this.next.read();
        }
        return length;
    }
}

