/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.el.MapVariableResolver;
import com.caucho.el.SystemPropertiesResolver;
import com.caucho.el.VariableResolver;
import com.caucho.http.log.AbstractAccessLog;
import com.caucho.http.log.AbstractErrorLog;
import com.caucho.http.log.AccessLog;
import com.caucho.jmx.MBeanServerFactoryImpl;
import com.caucho.jmx.MBeanServerImpl;
import com.caucho.server.http.Application;
import com.caucho.server.http.ConfigException;
import com.caucho.server.http.Configuration;
import com.caucho.server.http.JndiFactory;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.sql.DBPool;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.ClassLoaderLocal;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ClassLoaderContext {
    static WriteStream _dbg = LogStream.open("/caucho.com/http/configuration");
    static WriteStream _dbgLife = LogStream.open("/caucho.com/http/lifecycle");
    static L10N L = new L10N(class$com$caucho$server$http$ClassLoaderContext == null ? (class$com$caucho$server$http$ClassLoaderContext = ClassLoaderContext.class$("com.caucho.server.http.ClassLoaderContext")) : class$com$caucho$server$http$ClassLoaderContext);
    public static final int VALID_ONE = 1;
    public static final int VALID_OK = 2;
    static IntMap _appDefaultElements;
    static IntMap _webAppElements;
    static IntMap _hostElements;
    static IntMap _hostDefaultElements;
    static IntMap _defaultHostElements;
    static IntMap _serverElements;
    protected static ClassLoaderLocal _loaderApplication;
    private static ClassLoaderLocal _workDirLocal;
    private ClassLoaderContext _parent;
    private String _name;
    private RegistryNode _registry;
    private Configuration _configuration;
    private Path _rootPath;
    private Path _docPath;
    private Path _webInfPath;
    private HashMap _pathVariableMap;
    private VariableResolver _env;
    private boolean _addWebInfClasses;
    private DynamicClassLoader _classLoader;
    private Context _jndiContext;
    private MBeanServer _jmxServer;
    private ArrayList _contextResources;
    private AbstractErrorLog _errorLog;
    private long _classUpdateInterval = 2000L;
    private long _lastClassUpdate;
    private long _configUpdateInterval = 2000L;
    private long _lastConfigUpdate;
    private ArrayList _accessLogs;
    protected ArrayList _depends = new ArrayList();
    private volatile boolean _hasInit;
    private volatile boolean _initComplete;
    private volatile boolean _isClosed;
    protected boolean _isModified;
    static /* synthetic */ Class class$com$caucho$server$http$ClassLoaderContext;

    ClassLoaderContext(ClassLoaderContext parent) {
        this._parent = parent;
    }

    public String getName() {
        return this._name;
    }

    public ClassLoaderContext getParent() {
        return this._parent;
    }

    public ServletServer getServer() {
        if (this._parent != null) {
            return this._parent.getServer();
        }
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public RegistryNode getRegistry() {
        return this._registry;
    }

    public void setRegistry(RegistryNode node) {
        this._registry = node;
    }

    public Path getRootPath() {
        return this._rootPath;
    }

    public void setRootPath(Path path) {
        this._rootPath = path;
    }

    public Path getDocPath() {
        return this._docPath;
    }

    public void setWebInfPath(Path path) {
        this._webInfPath = path;
    }

    public Path getWebInfPath() {
        return this._webInfPath;
    }

    public void setDocPath(Path path) {
        this._docPath = path;
    }

    public HashMap getPathVariableMap() {
        return this._pathVariableMap;
    }

    public void setPathVariableMap(HashMap map) {
        this._pathVariableMap = map;
        this._env = new SystemPropertiesResolver();
        this._env = new MapVariableResolver(map, this._env);
    }

    public void setPathVariableMap(String variable, Object value) {
        this._pathVariableMap.put(variable, value);
    }

    public VariableResolver getEnv() {
        return this._env;
    }

    public void setAddWebInfClasses(boolean add) {
        this._addWebInfClasses = add;
    }

    public long getClassUpdateInterval() {
        return this._classUpdateInterval;
    }

    public void setClassUpdateInterval(long updateInterval) {
        this._classUpdateInterval = updateInterval;
    }

    public long getConfigUpdateInterval() {
        return this._configUpdateInterval;
    }

    public void setConfigUpdateInterval(long updateInterval) {
        this._configUpdateInterval = updateInterval;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public DynamicClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ClassLoader getParentLoader() {
        return this._parent.getClassLoader();
    }

    public Context getJndiContext() {
        return this._jndiContext;
    }

    public MBeanServer getJMXServer() {
        return this._jmxServer;
    }

    public TransactionManagerImpl getTransactionManager() {
        if (this._parent != null) {
            return this._parent.getTransactionManager();
        }
        return null;
    }

    public AbstractErrorLog getErrorLog() {
        if (this._errorLog != null) {
            return this._errorLog;
        }
        if (this._parent != null) {
            return this._parent.getErrorLog();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isModified() {
        DynamicClassLoader classLoader = this.getClassLoader();
        long now = Alarm.getCurrentTime();
        if (!this._initComplete) {
            return false;
        }
        if (this._isModified) {
            return true;
        }
        if (now < this._lastClassUpdate + this._classUpdateInterval && now < this._lastConfigUpdate + this._configUpdateInterval) {
            return false;
        }
        ClassLoaderContext classLoaderContext = this;
        synchronized (classLoaderContext) {
            now = Alarm.getCurrentTime();
            if (this._isModified) {
                return true;
            }
            if (now < this._lastClassUpdate + this._classUpdateInterval && now < this._lastConfigUpdate + this._configUpdateInterval) {
                return false;
            }
            if (this._parent != null && this._parent.isModified()) {
                this._isModified = true;
                return true;
            }
            if (this._lastClassUpdate + this._classUpdateInterval <= now) {
                if (this._classLoader != null && this._classLoader.isModified()) {
                    if (_dbgLife.canWrite()) {
                        _dbgLife.log(this.getURL() + " classes modified " + classLoader);
                    }
                    this._isModified = true;
                    return true;
                }
                this._lastClassUpdate = Alarm.getCurrentTime();
            }
            if (this._lastConfigUpdate + this._configUpdateInterval <= (now = Alarm.getCurrentTime())) {
                for (int i = 0; this._depends != null && i < this._depends.size(); ++i) {
                    Depend depend = (Depend)this._depends.get(i);
                    if (!depend.isModified()) continue;
                    if (_dbgLife.canWrite()) {
                        _dbgLife.log(this.getURL() + " depend modified: " + depend);
                    }
                    this._isModified = true;
                    return true;
                }
                this._lastConfigUpdate = Alarm.getCurrentTime();
            }
        }
        return false;
    }

    protected boolean isModifiedAsParent() {
        return this.isModified();
    }

    void logAccess(Request request, Response response, ServletContext app) throws IOException {
        if (this._accessLogs == null) {
            if (this._parent != null) {
                this._parent.logAccess(request, response, app);
            }
            return;
        }
        for (int i = 0; this._accessLogs != null && i < this._accessLogs.size(); ++i) {
            AbstractAccessLog log = (AbstractAccessLog)this._accessLogs.get(i);
            log.log(request, response, app);
        }
    }

    public void addDepend(Path path) {
        Depend depend;
        if (path instanceof MergePath) {
            path = ((MergePath)path).getBestPath();
        }
        if (!this._depends.contains(depend = new Depend(path))) {
            this._depends.add(depend);
        }
    }

    public ArrayList getDepends() {
        return this._depends;
    }

    public String getURL() {
        if (this._parent != null) {
            return this._parent.getURL();
        }
        return "anon:";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() throws Exception {
        if (this._hasInit) {
            return;
        }
        this._hasInit = true;
        this._isClosed = false;
        if (_dbgLife.canWrite()) {
            _dbgLife.println("init class-loader-context: " + this.getName() + " " + this.getRootPath() + " " + this._parent);
        }
        this._classUpdateInterval = this._registry.getELPeriod("class-update-interval", 2000L, this.getEnv());
        if (this._classUpdateInterval < 0L) {
            this._classUpdateInterval = 0x3FFFFFFFFFFFFFFFL;
        }
        this._configUpdateInterval = this._registry.getELPeriod("config-update-interval", this._classUpdateInterval, this.getEnv());
        if (this._configUpdateInterval < 0L) {
            this._configUpdateInterval = 0x3FFFFFFFFFFFFFFFL;
        }
        ClassLoaderContext parent = this.getParent();
        this._configuration = new Configuration(this, this.getParentLoader(), this._registry);
        this._configuration.setServer(this.getServer());
        if (this._parent != null) {
            this._configuration.setParent(parent.getConfiguration());
        }
        this._configuration.setPathVariables(this._pathVariableMap);
        this._configuration.setAddWebInfClasses(this._addWebInfClasses);
        this._classLoader = this._configuration.configureClassLoaders(this._webInfPath);
        if (this.getServer().isCompileOnly()) {
            return;
        }
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        try {
            RotateStream rotateStream;
            RegistryNode logNode;
            Thread.currentThread().setContextClassLoader(this._classLoader);
            this._jmxServer = MBeanServerFactory.createMBeanServer("Caucho:type=MBeanServer,url=" + MBeanServerFactoryImpl.cleanName(this.getURL()));
            _loaderApplication.set(this);
            if (this.getWebInfPath() != null) {
                Path workDir = this.getRootPath().lookup("WEB-INF/work");
                if (!((workDir = this._registry.getELPath("work-dir", workDir, this.getEnv())) instanceof MemoryPath) && workDir.getParent().isDirectory()) {
                    _workDirLocal.set(workDir);
                }
            }
            this._configuration.configurePostClassLoader();
            RegistryNode errorLogNode = this._registry.lookup("error-log");
            if (errorLogNode != null) {
                RotateStream rotateStream2 = this.configLog(errorLogNode);
                String className = errorLogNode.getString("class-name", "com.caucho.http.log.ErrorLog");
                Object obj = BeanUtil.createBean(errorLogNode, this.getEnv(), className, false);
                if (!(obj instanceof AbstractErrorLog)) {
                    throw ClassLoaderContext.error(errorLogNode, L.l("error-log class-name `{0}' must extend AbstractErrorLog.", className));
                }
                this._errorLog = (AbstractErrorLog)obj;
                if (rotateStream2 != null) {
                    this._errorLog.setLogStream(rotateStream2.getStream());
                }
                this._errorLog.init();
            }
            if ((logNode = this._registry.lookup("stdout-log")) != null && (rotateStream = this.configLog(logNode)) != null) {
                this._classLoader.setAttribute("caucho.stdout.stream", rotateStream.getStream());
            }
            if ((logNode = this._registry.lookup("stderr-log")) != null && (rotateStream = this.configLog(logNode)) != null) {
                this._classLoader.setAttribute("caucho.stderr.stream", rotateStream.getStream());
            }
            Iterator iter = this._registry.iterator();
            while (iter.hasNext()) {
                RegistryNode node = (RegistryNode)iter.next();
                if (!node.getName().equals("access-log")) continue;
                String href = node.getValue();
                href = node.getString("href", href);
                String className = node.getString("class-name", null);
                ServletServer server = this.getServer();
                Path path = ClassLoaderContext.lookupPath(href, this.getEnv());
                server.addRandom(path.getLength());
                server.addRandom(path.getLastModified());
                server.addRandom(path.getParent().getLastModified());
                AbstractAccessLog log = null;
                if (className != null) {
                    Class cl;
                    try {
                        cl = CauchoSystem.loadClass(className, false, this._classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        throw ClassLoaderContext.error(node, L.l("Can't find custom access-log class `{0}'", className));
                    }
                    try {
                        Object obj = cl.newInstance();
                        if (!(obj instanceof AbstractAccessLog)) {
                            throw ClassLoaderContext.error(node, L.l("Custom access-log class `{0}' must extend AbstractAccessLog.", className));
                        }
                        log = (AbstractAccessLog)obj;
                    }
                    catch (InstantiationException e) {
                        throw ClassLoaderContext.error(node, L.l("Can't create custom access-log class `{0}'.  The class must be public, non-abstract, and implement a public zero-arg constructor.", className));
                    }
                }
                if (log == null) {
                    log = new AccessLog();
                }
                log.setPath(path);
                BeanUtil.configure(log, node);
                if (this._accessLogs == null) {
                    this._accessLogs = new ArrayList();
                }
                this._accessLogs.add(log);
            }
            this._contextResources = new ArrayList();
            Context parentContext = parent != null ? this._parent.getJndiContext() : JndiFactory.initContext(Registry.lookup("/caucho.com"), this, this.getClassLoader(), this.getTransactionManager(), this._contextResources, null, this.getEnv());
            this._jndiContext = JndiFactory.initContext(this._registry, this, this.getClassLoader(), this.getTransactionManager(), this._contextResources, parentContext, this.getEnv());
            if (this instanceof Application) {
                this._configuration.configureAuthenticator((Application)this);
            } else {
                this._configuration.configureAuthenticator(null);
            }
        }
        finally {
            this._initComplete = true;
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    private RotateStream configLog(RegistryNode node) throws ServletException, IOException, RegistryException {
        String logPath = node.getValue();
        if ((logPath = node.getString("href", logPath)) == null) {
            return null;
        }
        long rolloverPeriod = node.getPeriod("rollover-period", -2L);
        long rolloverSize = node.getELBytes("rollover-size", -2L, null);
        int rolloverCount = node.getInt("rollover-count", 2);
        String timestamp = node.getString("timestamp", null);
        String encoding = Encoding.getMimeName(Locale.getDefault());
        encoding = node.getString("encoding", encoding);
        RotateStream rotateStream = null;
        Path errorPath = null;
        errorPath = ClassLoaderContext.lookupPath(logPath, this.getEnv());
        errorPath.getParent().mkdirs();
        rotateStream = RotateStream.create(errorPath);
        this.getServer().addRandom(errorPath.getLength());
        this.getServer().addRandom(errorPath.getParent().getLastModified());
        if (rotateStream != null) {
            if (rolloverPeriod >= -1L) {
                rotateStream.setRolloverPeriod(rolloverPeriod);
            } else if (rolloverSize >= -1L) {
                rotateStream.setRolloverSize(rolloverSize);
                rotateStream.setMaxRolloverCount(rolloverCount);
            }
        }
        if (rotateStream != null && timestamp != null) {
            rotateStream.setTimestamp(timestamp);
        }
        if (encoding != null && !encoding.equals("ISO-8859-1")) {
            rotateStream.getStream().setEncoding(encoding);
        }
        return rotateStream;
    }

    void cron(long now) {
        ArrayList logs = this._accessLogs;
        for (int i = 0; logs != null && i < logs.size(); ++i) {
            AbstractAccessLog log = (AbstractAccessLog)logs.get(i);
            try {
                log.flush();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ClassLoaderContext classLoaderContext = this;
        synchronized (classLoaderContext) {
            if (this._isClosed) {
                return;
            }
            this._isModified = true;
            this._isClosed = true;
        }
        this._hasInit = false;
        if (this._classLoader == null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldLoader = null;
        currentThread.setContextClassLoader(this._classLoader);
        ArrayList logs = this._accessLogs;
        this._accessLogs = null;
        for (int i = 0; logs != null && i < logs.size(); ++i) {
            AbstractAccessLog log = (AbstractAccessLog)logs.get(i);
            try {
                log.destroy();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._errorLog != null) {
            try {
                this._errorLog.destroy();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        ArrayList resources = this._contextResources;
        this._contextResources = null;
        for (int i = 0; resources != null && i < resources.size(); ++i) {
            Method method;
            Object obj = resources.get(i);
            try {
                method = obj.getClass().getMethod("close", new Class[0]);
                if (method != null) {
                    method.invoke(obj, new Object[0]);
                    obj = null;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (obj == null) continue;
            try {
                method = obj.getClass().getMethod("destroy", new Class[0]);
                if (method == null) continue;
                method.invoke(obj, new Object[0]);
                obj = null;
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        DBPool.closeLoaderPools();
        if (this._jmxServer instanceof MBeanServerImpl) {
            ((MBeanServerImpl)this._jmxServer).close();
        }
        currentThread.setContextClassLoader(oldLoader);
        if (this._classLoader != null) {
            this._classLoader.unload();
        }
        this._depends.clear();
        this._classLoader = null;
        this._hasInit = false;
    }

    static Path lookupPath(RegistryNode node, String path, Path deflt, VariableResolver env) throws RegistryException {
        String string = node.getString(path, null);
        if (string == null) {
            return deflt;
        }
        return ClassLoaderContext.lookupPath(string, env);
    }

    static Path lookupPath(String string, VariableResolver env) throws RegistryException {
        string = ClassLoaderContext.rewritePathString(string);
        try {
            Expr expr = new ELParser(string).parse();
            Object obj = expr.evalObject(env);
            if (obj instanceof Path) {
                return (Path)obj;
            }
            String value = Expr.toString(obj);
            Path pwd = (Path)env.get("resin:pwd");
            if (pwd != null) {
                return pwd.lookup(value);
            }
            return Vfs.lookup(value);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    static String rewritePathString(String pathName) {
        CharBuffer cb = CharBuffer.allocate();
        int length = pathName.length();
        for (int i = 0; i < length; ++i) {
            char ch = pathName.charAt(i);
            if (ch != '$') {
                cb.append(ch);
                continue;
            }
            if (i + 1 == length) {
                cb.append('$');
                continue;
            }
            ch = pathName.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                ++i;
                while (i < length && (ch = pathName.charAt(i)) >= '0' && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                --i;
                cb.append("${regexp[" + value + "]}");
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                int tail;
                for (tail = i + 1; tail < length && (ch = pathName.charAt(tail)) != '/' && ch != '\\' && ch != '$'; ++tail) {
                }
                cb.append("${Var[\"" + pathName.substring(i + 1, tail) + "\"]}");
                i = tail - 1;
                continue;
            }
            cb.append('$');
        }
        return cb.close();
    }

    static RegistryNode selectDefault(RegistryNode registry, IntMap defaultElements) {
        RegistryNode top = new RegistryNode();
        top.setRoot(registry.getRoot());
        Iterator iter = registry.iterator();
        while (iter.hasNext()) {
            RegistryNode clone;
            RegistryNode child = (RegistryNode)iter.next();
            if (defaultElements.get(child.getName()) >= 0) {
                clone = (RegistryNode)child.clone();
                top.addChild(clone);
                continue;
            }
            if (child.getValue() == null || !child.getName().equals("classpath") || !child.getValue().startsWith("WEB-INF") && !child.getString("source", "").startsWith("WEB-INF")) continue;
            clone = (RegistryNode)child.clone();
            top.addChild(clone);
        }
        return top;
    }

    static void mergeRegistry(RegistryNode parent, RegistryNode child) throws ServletException {
        Iterator iter = child.iterator();
        ArrayList<RegistryNode> children = new ArrayList<RegistryNode>();
        block0: while (iter.hasNext()) {
            String name;
            RegistryNode childNode = (RegistryNode)iter.next();
            if (childNode.getName().equals("servlet") && (name = childNode.getString("servlet-name", null)) != null) {
                Iterator servletIter = parent.iterator();
                while (servletIter.hasNext()) {
                    RegistryNode topNode = (RegistryNode)servletIter.next();
                    if (!topNode.getName().equals("servlet") || !name.equals(topNode.getString("servlet-name", null))) continue;
                    continue block0;
                }
            }
            children.add(childNode);
        }
        for (int i = 0; i < children.size(); ++i) {
            parent.addChild((RegistryNode)children.get(i));
        }
    }

    public static void verifyElements(RegistryNode node, IntMap validElements) throws ServletException {
        Iterator iter = node.iterator();
        while (iter.hasNext()) {
            RegistryNode subNode = (RegistryNode)iter.next();
            if (validElements.get(subNode.getName()) >= 0) continue;
            throw ClassLoaderContext.error(subNode, L.l("unexpected element `{0}' in {1}", (Object)subNode.getName(), node.getName()));
        }
    }

    static String getRequiredString(RegistryNode node, String name) throws ServletException {
        String value = node.getString(name, null);
        if (value == null) {
            throw ClassLoaderContext.error(node, L.l("expected `{0}' in {1}", (Object)name, node.getName()));
        }
        return value;
    }

    public static ServletException error(RegistryNode node, String msg) {
        if (node != null) {
            return new ConfigException(node.getFilename() + ":" + node.getLine() + ": " + msg);
        }
        return new ConfigException(msg);
    }

    public static ServletException error(RegistryNode node, Throwable e) {
        if (e instanceof ServletException) {
            return (ServletException)e;
        }
        if (node != null) {
            return new ServletException(node.getFilename() + ":" + node.getLine() + ": " + String.valueOf(e));
        }
        return new ServletException(e);
    }

    public String toString() {
        return "[ClassLoaderContext " + this.getName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _loaderApplication = new ClassLoaderLocal("caucho.application");
        _workDirLocal = new ClassLoaderLocal("caucho.work-dir");
        _appDefaultElements = new IntMap();
        _appDefaultElements.put("context-param", 1);
        _appDefaultElements.put("servlet", 1);
        _appDefaultElements.put("servlet-mapping", 1);
        _appDefaultElements.put("filter", 1);
        _appDefaultElements.put("filter-mapping", 1);
        _appDefaultElements.put("chain-mapping", 1);
        _appDefaultElements.put("path-mapping", 1);
        _appDefaultElements.put("mime-mapping", 1);
        _appDefaultElements.put("cache-mapping", 1);
        _appDefaultElements.put("session-config", 1);
        _appDefaultElements.put("character-encoding", 1);
        _appDefaultElements.put("class-update-interval", 1);
        _appDefaultElements.put("config-update-interval", 1);
        _appDefaultElements.put("taglib", 1);
        _appDefaultElements.put("url-regexp", 1);
        _appDefaultElements.put("error-page", 1);
        _appDefaultElements.put("welcome-file-list", 1);
        _appDefaultElements.put("icon", 1);
        _appDefaultElements.put("display-name", 1);
        _appDefaultElements.put("description", 1);
        _appDefaultElements.put("distributable", 1);
        _appDefaultElements.put("security-role", 1);
        _appDefaultElements.put("env-entry", 1);
        _appDefaultElements.put("directory-servlet", 1);
        _appDefaultElements.put("temp-dir", 1);
        _appDefaultElements.put("work-dir", 1);
        _appDefaultElements.put("jsp", 1);
        _appDefaultElements.put("multipart-form", 1);
        _appDefaultElements.put("strict-mapping", 1);
        _appDefaultElements.put("listener", 1);
        _appDefaultElements.put("security-constraint", 1);
        _appDefaultElements.put("secure", 1);
        _appDefaultElements.put("allow-admin", 1);
        _appDefaultElements.put("browser-mapping", 1);
        _appDefaultElements.put("servlet-classloader-hack", 1);
        _appDefaultElements.put("web-xml", 1);
        _appDefaultElements.put("lazy-init", 1);
        _appDefaultElements.put("allow-servlet-el", 1);
        _appDefaultElements.put("case-sensitive", 1);
        _webAppElements = (IntMap)_appDefaultElements.clone();
        _webAppElements.put("app-dir", 1);
        _webAppElements.put("classpath", 1);
        _webAppElements.put("resource-ref", 1);
        _webAppElements.put("resource-env-ref", 1);
        _webAppElements.put("ejb-ref", 1);
        _webAppElements.put("ejb-local-ref", 1);
        _webAppElements.put("jndi-link", 1);
        _webAppElements.put("jndi", 1);
        _webAppElements.put("db-pool", 1);
        _webAppElements.put("error-log", 1);
        _webAppElements.put("access-log", 1);
        _webAppElements.put("authenticator", 1);
        _webAppElements.put("login-config", 1);
        _webAppElements.put("stdout-log", 1);
        _webAppElements.put("stderr-log", 1);
        _webAppElements.put("system-property", 1);
        _hostElements = (IntMap)_webAppElements.clone();
        _hostElements.put("web-app", 1);
        _hostElements.put("war-dir", 1);
        _hostElements.put("war-expand-dir", 1);
        _hostElements.put("regexp", 1);
        _hostElements.put("host-name", 1);
        _hostElements.put("server-name", 1);
        _hostElements.put("class-loader-context", 1);
        _hostElements.put("root-dir", 1);
        _hostElements.put("doc-dir", 1);
        _hostElements.put("url-character-encoding", 1);
        _hostDefaultElements = (IntMap)_appDefaultElements.clone();
        _hostDefaultElements.put("war-dir", 1);
        _hostDefaultElements.put("war-expand-dir", 1);
        _hostDefaultElements.put("url-character-encoding", 1);
        _defaultHostElements = new IntMap();
        _defaultHostElements.put("server-name", 1);
        _defaultHostElements.put("class-loader-context", 1);
        _defaultHostElements.put("web-app", 1);
        _serverElements = (IntMap)_hostElements.clone();
        _serverElements.put("host", 1);
        _serverElements.put("port", 1);
        _serverElements.put("httpd-port", 1);
        _serverElements.put("httpd-host", 1);
        _serverElements.put("ssl-port", 1);
        _serverElements.put("ssl-host", 1);
        _serverElements.put("http", 1);
        _serverElements.put("srun", 1);
        _serverElements.put("server", 1);
        _serverElements.put("srun-backup", 1);
        _serverElements.put("srun-port", 1);
        _serverElements.put("srun-host", 1);
        _serverElements.put("user-name", 1);
        _serverElements.put("group-name", 1);
        _serverElements.put("thread-min", 1);
        _serverElements.put("thread-max", 1);
        _serverElements.put("accept-max", 1);
        _serverElements.put("thread-keepalive", 1);
        _serverElements.put("request-timeout", 1);
        _serverElements.put("live-time", 1);
        _serverElements.put("dead-time", 1);
        _serverElements.put("connect-timeout", 1);
        _serverElements.put("timeout-interval", 1);
        _serverElements.put("enable-busy", 1);
        _serverElements.put("accept-buffer-size", 1);
        _serverElements.put("listen", 1);
        _serverElements.put("cache", 1);
        _serverElements.put("ping", 1);
        _serverElements.put("ignore-client-disconnect", 1);
        _serverElements.put("forbid-host", 1);
        _serverElements.put("srun-timeout", 1);
        _serverElements.put("caucho-status", 1);
        _serverElements.put("session-url-prefix", 1);
        _serverElements.put("alternate-session-url-prefix", 1);
        _serverElements.put("sticky-sessions", 1);
        _serverElements.put("server-listener", 1);
        _serverElements.put("global-system-properties", 1);
        _serverElements.put("session-cookie", 1);
        _serverElements.put("url-length-max", 1);
        _serverElements.put("shutdown-wait-time", 1);
    }
}

