/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.naming.LinkProxy;
import com.caucho.server.http.Application;
import com.caucho.server.http.JndiFactory;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.servlet.ServletException;

class EarConfig {
    private Application app;

    EarConfig(Application app) {
        this.app = app;
    }

    boolean configure() throws Exception {
        Path appInf = this.app.getAppInf();
        Path appXml = appInf.lookup("sun-j2ee-ri.xml");
        if (!appXml.canRead()) {
            return false;
        }
        Registry registry = null;
        Context env = null;
        try {
            env = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        try {
            registry = Registry.parse(appXml);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        RegistryNode top = registry.getTop();
        top = top.lookup("j2ee-ri-specific-information");
        if (top == null) {
            return false;
        }
        HashMap<String, String> ejbNames = new HashMap<String, String>();
        Iterator beanIter = top.select("enterprise-beans");
        while (beanIter.hasNext()) {
            RegistryNode beans = (RegistryNode)beanIter.next();
            Iterator iter = beans.select("ejb");
            while (iter.hasNext()) {
                RegistryNode ejb = (RegistryNode)iter.next();
                String ejbName = ejb.getString("ejb-name", null);
                String jndiName = ejb.getString("jndi-name", null);
                if (ejbName == null || jndiName == null) continue;
                ejbNames.put(jndiName, ejbName);
            }
        }
        String appName = this.app.getContextPath();
        RegistryNode appWeb = null;
        Iterator iter = top.select("web");
        while (iter.hasNext()) {
            RegistryNode web = (RegistryNode)iter.next();
            String contextRoot = web.getString("context-root", null);
            if (contextRoot == null) continue;
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            if (!contextRoot.equals(appName)) continue;
            appWeb = web;
            break;
        }
        if (appWeb == null && !appName.equals("/_ejb")) {
            return false;
        }
        Context ejbContext = null;
        try {
            Class<?> cl = Class.forName("com.caucho.burlap.BurlapContextFactory");
            InitialContextFactory factory = (InitialContextFactory)cl.newInstance();
            Hashtable<String, String> props = new Hashtable<String, String>();
            VirtualHost vhost = this.app.getVirtualHost();
            String url = vhost.getURL() + "/_ejb";
            props.put("java.naming.provider.url", url);
            ejbContext = factory.getInitialContext(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Burlap must be supported");
        }
        if (appName.equals("/_ejb")) {
            beanIter = top.select("enterprise-beans");
            while (beanIter.hasNext()) {
                RegistryNode beans = (RegistryNode)beanIter.next();
                Iterator subIter = beans.select("ejb");
                while (subIter.hasNext()) {
                    RegistryNode ejb = (RegistryNode)subIter.next();
                    Iterator ejbRefIter = ejb.select("ejb-ref");
                    while (ejbRefIter.hasNext()) {
                        RegistryNode ejbRef = (RegistryNode)ejbRefIter.next();
                        this.initEjbRef(env, ejbRef, ejbNames, ejbContext);
                    }
                }
            }
        } else {
            iter = appWeb.select("ejb-ref");
            while (iter.hasNext()) {
                RegistryNode ejbRef = (RegistryNode)iter.next();
                this.initEjbRef(env, ejbRef, ejbNames, ejbContext);
            }
        }
        return true;
    }

    void initEjbRef(Context env, RegistryNode ejbRef, HashMap ejbNames, Context ejbContext) throws NamingException, ServletException {
        String refName = ejbRef.getString("ejb-ref-name", null);
        String jndiName = ejbRef.getString("jndi-name", null);
        if (refName == null || jndiName == null) {
            return;
        }
        String ejbName = (String)ejbNames.get(jndiName);
        if (ejbName == null) {
            return;
        }
        LinkProxy proxy = new LinkProxy(null, null, ejbName);
        JndiFactory.deepBind(env, refName, proxy, ejbRef);
    }
}

