/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileServlet
extends GenericServlet {
    private Path context;
    private byte[] buffer = new byte[1024];
    private Application app;
    private RequestDispatcher dir;
    private ArrayList indexFiles;
    private LruCache pathCache;
    private QDate calendar = new QDate();
    private String directoryServlet = "com.caucho.server.http.DirectoryServlet";

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        this.app = (Application)this.getServletContext();
        this.context = this.app.getAppDir();
        this.pathCache = new LruCache(256);
        this.indexFiles = new ArrayList();
        RegistryNode node = this.app.getRegistry();
        String files = "";
        if (node != null) {
            RegistryNode list;
            files = node.getString("welcome-file-list", "index.xtp, index.jsp, index.html");
            if (files == null) {
                files = "";
            }
            if ((list = node.lookup("welcome-file-list")) != null) {
                Iterator iter = list.select("welcome-file");
                while (iter.hasNext()) {
                    RegistryNode subnode = (RegistryNode)iter.next();
                    String file = subnode.getString();
                    if (file == null) continue;
                    files = files + ", " + file;
                }
            }
            this.directoryServlet = node.getString("directory-servlet", this.directoryServlet);
            if (this.directoryServlet == null || this.directoryServlet.equalsIgnoreCase("none") || this.directoryServlet.equalsIgnoreCase("false")) {
                this.directoryServlet = null;
            }
        }
        if (this.directoryServlet != null) {
            this.dir = this.app.getNamedDispatcher(this.directoryServlet);
        }
        int len = files.length();
        int i = 0;
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            char ch = '\u0000';
            while (true) {
                block13: {
                    block12: {
                        if (i >= len) break block12;
                        char c = files.charAt(i);
                        ch = c;
                        if (c == ' ') break block13;
                    }
                    if (ch != ',' && ch != 9) break;
                }
                ++i;
            }
            if (i >= len) break;
            cb.clear();
            while (i < len) {
                char c = files.charAt(i);
                ch = c;
                if (c == ' ' || ch == 44 || ch == 9) break;
                cb.append(ch);
                ++i;
            }
            this.indexFiles.add(cb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ServletOutputStream os;
        block41: {
            Cache cache;
            HttpServletRequest req;
            CauchoRequest cauchoReq = null;
            if (request instanceof CauchoRequest) {
                cauchoReq = (CauchoRequest)request;
                req = cauchoReq;
            } else {
                req = (HttpServletRequest)request;
            }
            HttpServletResponse res = (HttpServletResponse)response;
            String method = req.getMethod();
            if (!(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("POST"))) {
                res.sendError(501, "Method not implemented");
                return;
            }
            boolean isInclude = false;
            String uri = (String)req.getAttribute("javax.servlet.include.request_uri");
            if (uri != null) {
                isInclude = true;
            } else {
                uri = req.getRequestURI();
            }
            LruCache lruCache = this.pathCache;
            synchronized (lruCache) {
                cache = (Cache)this.pathCache.get(uri);
            }
            String filename = null;
            if (cache == null) {
                String pathInfo;
                CharBuffer cb = CharBuffer.allocate();
                String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
                if (servletPath != null) {
                    cb.append(servletPath);
                }
                if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
                    cb.append(pathInfo);
                }
                String relPath = cb.close();
                filename = this.getServletContext().getRealPath(relPath);
                Path path = this.context.lookupNative(filename);
                if (cauchoReq != null && cauchoReq.getRequestDepth(0) == 0) {
                    if (relPath.regionMatches(true, 0, "/web-inf", 0, 8) && (relPath.length() == 8 || !Character.isLetterOrDigit(relPath.charAt(8)))) {
                        res.sendError(404);
                        return;
                    }
                    if (relPath.regionMatches(true, 0, "/meta-inf", 0, 9) && (relPath.length() == 9 || !Character.isLetterOrDigit(relPath.charAt(9)))) {
                        res.sendError(404);
                        return;
                    }
                }
                if (relPath.endsWith(".DS_store")) {
                    res.sendError(404);
                    return;
                }
                if (CauchoSystem.isWindows() && relPath.length() != 0 && !path.isDirectory()) {
                    String lower = path.getPath().toLowerCase();
                    char lastCh = relPath.charAt(relPath.length() - 1);
                    if (lastCh == '.' || lastCh == ' ' || lastCh == '*' || lastCh == '?' || lastCh == '/' || lastCh == '\\' || lower.endsWith("::$data") || lower.endsWith("/con") || lower.endsWith("/con/") || lower.endsWith("/aux") || lower.endsWith("/aux/") || lower.endsWith("/nul") || lower.endsWith("/nul/")) {
                        res.sendError(404);
                        return;
                    }
                }
                for (int i = relPath.length() - 1; i >= 0; --i) {
                    char ch = relPath.charAt(i);
                    if (ch != '\u0000') continue;
                    res.sendError(404);
                    return;
                }
                ServletContext app = this.getServletContext();
                LruCache ch = this.pathCache;
                synchronized (ch) {
                    cache = new Cache(this.calendar, path, relPath, app.getMimeType(relPath));
                    this.pathCache.put(uri, cache);
                }
            }
            cache.update();
            if (!cache.canRead()) {
                if (isInclude) {
                    throw new FileNotFoundException(uri);
                }
                res.sendError(404);
                return;
            }
            if (cache.isDirectory()) {
                boolean redirect = false;
                if (uri.length() > 0 && uri.charAt(uri.length() - 1) != '/') {
                    redirect = true;
                }
                for (int i = 0; i < this.indexFiles.size(); ++i) {
                    String name = (String)this.indexFiles.get(i);
                    Path subpath = cache.getPath().lookup(name);
                    if (!subpath.exists()) continue;
                    String queryString = req.getQueryString();
                    if (redirect) {
                        if (queryString != null) {
                            res.sendRedirect(res.encodeRedirectURL(uri + "/?" + queryString));
                        } else {
                            res.sendRedirect(res.encodeRedirectURL(uri + "/"));
                        }
                        return;
                    }
                    String forwardPath = cache.getRelPath() + '/' + name;
                    RequestDispatcher disp = this.getServletContext().getRequestDispatcher(forwardPath);
                    ((QRequestDispatcher)disp).forward((ServletRequest)req, (ServletResponse)res, null, true);
                    return;
                }
                if (this.dir == null) {
                    res.sendError(404);
                    return;
                }
                if (redirect) {
                    res.sendRedirect(uri + "/");
                    return;
                }
                this.dir.forward((ServletRequest)req, (ServletResponse)res);
                return;
            }
            String etag = cache.getEtag();
            String lastModified = cache.getLastModifiedString();
            res.setHeader("ETag", etag);
            res.setHeader("Last-Modified", lastModified);
            String mime = cache.getMimeType();
            if (mime != null) {
                res.setContentType(mime);
            }
            if (method.equalsIgnoreCase("HEAD")) {
                res.setContentLength((int)cache.getLength());
                return;
            }
            String ifMatch = req.getHeader("If-None-Match");
            if (ifMatch != null && ifMatch.equals(etag)) {
                res.sendError(304);
                return;
            }
            String ifModified = req.getHeader("If-Modified-Since");
            if (ifModified != null && ifModified.equals(lastModified)) {
                res.sendError(304);
                return;
            }
            String range = req.getHeader("Range");
            if (range != null && this.handleRange(req, res, cache, range)) {
                return;
            }
            res.setContentLength((int)cache.getLength());
            ReadStream is = null;
            os = null;
            try {
                is = cache.getPath().openRead();
                os = res.getOutputStream();
                is.writeToStream((OutputStream)os);
                Object var21_28 = null;
                if (is == null) break block41;
            }
            catch (Throwable throwable) {
                Object var21_29 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRange(HttpServletRequest req, HttpServletResponse res, Cache cache, String range) throws IOException {
        ServletOutputStream os;
        block15: {
            int off;
            int length = range.length();
            if (length < 7 || !range.startsWith("bytes=")) {
                return false;
            }
            boolean hasFirst = false;
            long first = 0L;
            boolean hasLast = false;
            long last = 0L;
            int ch = -1;
            for (off = 6; off < length; ++off) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                first = 10L * first + (long)ch - 48L;
                hasFirst = true;
            }
            if (ch != 45) {
                return false;
            }
            ++off;
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                last = 10L * last + (long)ch - 48L;
                hasLast = true;
                ++off;
            }
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c != ' ') break;
                ++off;
            }
            if (off < length) {
                return false;
            }
            if (!hasLast) {
                last = cache.getLength() - 1L;
            }
            if (!hasFirst) {
                first = cache.getLength() - last;
                last = cache.getLength() - 1L;
            }
            if (first > last) {
                return false;
            }
            if (last >= cache.getLength()) {
                return false;
            }
            res.setStatus(206);
            res.setContentLength((int)(last - first + 1L));
            CharBuffer cb = CharBuffer.allocate();
            cb.append("bytes ");
            cb.append(first);
            cb.append('-');
            cb.append(last);
            cb.append('/');
            cb.append(cache.getLength());
            res.setHeader("Content-Range", cb.close());
            ReadStream is = null;
            os = null;
            try {
                is = cache.getPath().openRead();
                is.skip(first);
                os = res.getOutputStream();
                is.writeToStream((OutputStream)os, (int)(last - first + 1L));
                Object var18_15 = null;
                if (is == null) break block15;
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
        return true;
    }

    static class Cache {
        QDate calendar;
        Path path;
        boolean isDirectory;
        boolean canRead;
        long length;
        long lastCheck;
        long lastModified = -2401057700593545203L;
        String relPath;
        String etag;
        String lastModifiedString;
        String mimeType;

        Cache(QDate calendar, Path path, String relPath, String mimeType) {
            this.calendar = calendar;
            this.path = path;
            this.relPath = relPath;
            this.mimeType = mimeType;
            this.update();
        }

        Path getPath() {
            return this.path;
        }

        boolean canRead() {
            return this.canRead;
        }

        boolean isDirectory() {
            return this.isDirectory;
        }

        long getLength() {
            return this.length;
        }

        String getRelPath() {
            return this.relPath;
        }

        String getEtag() {
            return this.etag;
        }

        String getLastModifiedString() {
            return this.lastModifiedString;
        }

        String getMimeType() {
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            long now = Alarm.getCurrentTime();
            if (this.lastCheck + 2000L < now) {
                Cache cache = this;
                synchronized (cache) {
                    this.lastCheck = now;
                    this.isDirectory = this.path.isDirectory();
                    this.canRead = this.path.canRead();
                    this.length = this.path.getLength();
                    long lastModified = this.path.getLastModified();
                    if (lastModified == 0L) {
                        this.canRead = false;
                        this.isDirectory = false;
                    }
                    if (lastModified != this.lastModified) {
                        this.lastModified = lastModified;
                        CharBuffer cb = new CharBuffer();
                        cb.append('\"');
                        Base64.encode(cb, lastModified);
                        cb.append('\"');
                        this.etag = cb.close();
                        QDate qDate = this.calendar;
                        synchronized (qDate) {
                            this.calendar.calculate(lastModified, false);
                            this.lastModifiedString = this.calendar.printDate();
                        }
                    }
                }
            }
        }
    }
}

