/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Regexp;
import com.caucho.server.http.Invocation;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import javax.servlet.ServletException;

class FilterMap {
    static L10N L = new L10N(class$com$caucho$server$http$FilterMap == null ? (class$com$caucho$server$http$FilterMap = FilterMap.class$("com.caucho.server.http.FilterMap")) : class$com$caucho$server$http$FilterMap);
    private String servletName;
    private Regexp regexp;
    private Object data;
    static /* synthetic */ Class class$com$caucho$server$http$FilterMap;

    FilterMap() {
    }

    void setServletName(String servletName) {
        this.servletName = servletName;
    }

    void setRegexp(String regexpPattern, String flags) throws Exception {
        this.regexp = new Regexp(regexpPattern, flags);
    }

    void setURLPattern(String urlPattern, String flags) throws ServletException {
        this.regexp = this.urlPatternToRegexp(urlPattern, flags);
    }

    Object getData() {
        return this.data;
    }

    void setData(Object data) {
        this.data = data;
    }

    boolean isMatch(Invocation invocation, String servletName) {
        if (this.servletName != null && this.servletName.equals(servletName)) {
            return true;
        }
        if (this.regexp == null || invocation == null) {
            return false;
        }
        String servletPath = invocation.getServletPath();
        String pathInfo = invocation.getPathInfo();
        String uri = pathInfo == null ? servletPath : (servletPath == null ? pathInfo : servletPath + pathInfo);
        return this.regexp.exec(uri, 0) >= 0;
    }

    private Regexp urlPatternToRegexp(String pattern, String flags) throws ServletException {
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            try {
                return new Regexp("^/$", flags);
            }
            catch (IllegalRegexpException e) {
                throw new ServletException((Throwable)e);
            }
        }
        int length = pattern.length();
        boolean isExact = true;
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        int prefixLength = -1;
        boolean isShort = false;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*' && i + 1 == length && i > 0) {
                isExact = false;
                if (pattern.charAt(i - 1) == '/') {
                    cb.setLength(cb.length() - 1);
                    if (prefixLength < 0) {
                        prefixLength = i - 1;
                    }
                } else if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (prefixLength != 0) continue;
                prefixLength = 1;
                continue;
            }
            if (ch == '*') {
                isExact = false;
                cb.append(".*");
                if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (i != 0) continue;
                isShort = true;
                continue;
            }
            if (ch == '.' || ch == '[' || ch == '^' || ch == '$' || ch == '{' || ch == '}' || ch == '|' || ch == '(' || ch == ')' || ch == '?') {
                cb.append('\\');
                cb.append(ch);
                continue;
            }
            cb.append(ch);
        }
        if (isExact) {
            cb.append('$');
        } else {
            cb.append("(?=/)|" + cb.toString() + "$");
        }
        try {
            return new Regexp(cb.close(), flags);
        }
        catch (IllegalRegexpException e) {
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

