/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.DispatchRequest;
import com.caucho.util.FreeList;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

class IncludeDispatchRequest
extends DispatchRequest {
    private static final FreeList _freeList = new FreeList(32);
    private Hashtable _headers;

    protected IncludeDispatchRequest() {
    }

    public static IncludeDispatchRequest createIncludeDispatch() {
        IncludeDispatchRequest req = (IncludeDispatchRequest)_freeList.allocate();
        if (req == null) {
            req = new IncludeDispatchRequest();
        }
        return req;
    }

    void init(Application application, HttpServletRequest request, CauchoResponse response, String method, String uri, String servletPath, String pathInfo, String queryString, String addedQuery) throws ServletException {
        super.init(application, request, response, method, uri, servletPath, pathInfo, queryString, addedQuery);
        this._headers = null;
    }

    public String getHeader(String key) {
        String value = null;
        if (this._headers != null) {
            value = (String)this._headers.get(key);
        }
        if (value != null) {
            return value;
        }
        if (key.equalsIgnoreCase("If-Modified-Since") || key.equalsIgnoreCase("If-None-Match")) {
            return null;
        }
        return super.getHeader(key);
    }

    public void setHeader(String key, String value) {
        if (this._headers == null) {
            this._headers = new Hashtable();
        }
        this._headers.put(key, value);
    }

    public static void free(IncludeDispatchRequest req) {
        req.free();
        _freeList.free(req);
    }
}

