/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.BadRequestException;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.SecurityConstraint;
import com.caucho.server.http.VirtualHost;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.transaction.Transaction;

public class Invocation {
    static WriteStream dbg = LogStream.open("/caucho.com/http/invocation");
    static L10N L = new L10N(class$com$caucho$server$http$Invocation == null ? (class$com$caucho$server$http$Invocation = Invocation.class$("com.caucho.server.http.Invocation")) : class$com$caucho$server$http$Invocation);
    protected VirtualHost _host;
    Application _application;
    String _rawUri;
    String _uri;
    String _contextPath;
    String _servletPath;
    String _pathInfo;
    String _sessionId;
    String _queryString;
    private boolean _isSubrequest;
    private QServletConfig _config;
    FilterChain _filterChain;
    int _loaderCount;
    SecurityConstraint _security;
    String _mimeType;
    String _filter;
    private int _maxPooledServlets = 5;
    static /* synthetic */ Class class$com$caucho$server$http$Invocation;

    Invocation(VirtualHost host, byte[] rawUri, int uriLength, boolean isDispatch, boolean decodeUrl, boolean isSubrequest) throws IOException {
        this._host = host;
        this._isSubrequest = isSubrequest;
        if (isDispatch) {
            for (int i = 0; i < uriLength; ++i) {
                if (rawUri[i] != 63) continue;
                this._queryString = this.byteToChar(rawUri, ++i, uriLength - i, "ISO-8859-1");
                uriLength = i - 1;
                break;
            }
        }
        String encoding = host.getURLCharacterEncoding();
        this._rawUri = this.byteToChar(rawUri, 0, uriLength, encoding);
        this._uri = decodeUrl ? Invocation.normalizeUri(Invocation.normalizeUriEscape(rawUri, 0, uriLength, encoding)) : Invocation.normalizeUri(this._rawUri);
        this._mimeType = "bogus";
    }

    private String byteToChar(byte[] buffer, int offset, int length, String encoding) {
        ByteToChar converter = ByteToChar.create();
        if (encoding == null) {
            encoding = "utf-8";
        }
        try {
            converter.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            dbg.log(e);
        }
        try {
            while (length > 0) {
                converter.addByte(buffer[offset++]);
                --length;
            }
            return converter.getConvertedString();
        }
        catch (IOException e) {
            return "unknown";
        }
    }

    Invocation(VirtualHost host, String rawUri) throws IOException {
        this._host = host;
        int p = rawUri.indexOf(63);
        if (p > 0) {
            this._queryString = rawUri.substring(p + 1);
            rawUri = rawUri.substring(0, p);
        }
        this._rawUri = rawUri;
        this._uri = Invocation.normalizeUri(rawUri);
        this._mimeType = "bogus";
    }

    VirtualHost getHost() {
        return this._host;
    }

    String getRawUri() {
        return this._rawUri;
    }

    String getUri() {
        return this._uri;
    }

    String getQueryString() {
        return this._queryString;
    }

    String getContextPath() {
        return this._contextPath;
    }

    String getServletPath() {
        return this._servletPath;
    }

    String getPathInfo() {
        return this._pathInfo;
    }

    String getSessionId() {
        return this._sessionId;
    }

    Application getApplication() {
        return this._application;
    }

    boolean isModified() {
        Application app = this._application;
        return app == null || app.isModified();
    }

    QServletConfig getServletConfig() {
        return this._config;
    }

    void setServletConfig(QServletConfig config) {
        this._config = config;
    }

    String getServletName() {
        if (this._config == null) {
            return null;
        }
        return this._config.getServletName();
    }

    boolean isSubrequest() {
        return this._isSubrequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service(AbstractRequest req, CauchoResponse res) throws IOException, ServletException {
        ClassLoader oldLoader;
        Thread thread;
        block12: {
            req.invocation = this;
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this._application.getClassLoader());
            try {
                if (this._config == null) {
                    this._application.getServlet(this);
                }
                if (dbg.canWrite()) {
                    dbg.log("invocation:" + this.getUri() + " -> (host:" + this.getHost().getName() + ", context:" + this.getContextPath() + ", servletPath:" + this.getServletPath() + ", pathInfo:" + this.getPathInfo() + ", servlet:" + (this._config == null ? "null" : this._config.getServletName()) + ", filter:" + this._filterChain + ")");
                }
                if (this._filterChain == null) {
                    this._filterChain = this._isSubrequest ? this._application.getFilterChainServlet(this._config, false) : this._application.buildFilterChain(this, this._config);
                }
                this._filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                TransactionManagerImpl tm = this._application.getTransactionManager();
                if (tm != null && !this._isSubrequest) {
                    try {
                        Transaction trans = tm.getTransaction();
                        if (trans != null) {
                            trans.rollback();
                        }
                    }
                    catch (Throwable e) {
                        dbg.log(e);
                    }
                }
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            TransactionManagerImpl tm = this._application.getTransactionManager();
            if (tm != null && !this._isSubrequest) {
                try {
                    Transaction trans = tm.getTransaction();
                    if (trans != null) {
                        trans.rollback();
                    }
                    break block12;
                }
                catch (Throwable e) {
                    dbg.log(e);
                }
                {
                }
            }
        }
        thread.setContextClassLoader(oldLoader);
    }

    void close() {
        this._application = null;
        this._filterChain = null;
    }

    static String normalizeUri(String uri) throws IOException {
        char ch;
        CharBuffer cb = CharBuffer.allocate();
        int len = uri.length();
        if (len > 1024) {
            throw new BadRequestException(L.l("The request contains an illegal URL."));
        }
        if (len == 0 || (ch = uri.charAt(0)) != '/' && ch != '\\') {
            cb.append('/');
        }
        for (int i = 0; i < len; ++i) {
            ch = uri.charAt(i);
            if (ch == '/' || ch == '\\') {
                while (i + 1 < len) {
                    ch = uri.charAt(i + 1);
                    if (ch == '/' || ch == '\\') {
                        ++i;
                        continue;
                    }
                    if (ch != '.') break;
                    if (i + 2 >= len || (ch = uri.charAt(i + 2)) == '/' || ch == '\\') {
                        i += 2;
                        continue;
                    }
                    if (ch != '.') break;
                    if (i + 3 >= len || (ch = uri.charAt(i + 3)) == '/' || ch == '\\') {
                        int j;
                        for (j = cb.length() - 1; j >= 0 && (ch = cb.charAt(j)) != '/' && ch != '\\'; --j) {
                        }
                        if (j > 0) {
                            cb.setLength(j);
                        } else {
                            cb.setLength(0);
                        }
                        i += 3;
                        continue;
                    }
                    throw new BadRequestException(L.l("The request contains an illegal URL."));
                }
                cb.append('/');
                continue;
            }
            if (ch == '\u0000') {
                throw new BadRequestException(L.l("The request contains an illegal URL."));
            }
            cb.append(ch);
        }
        return cb.close();
    }

    private static String normalizeUriEscape(byte[] rawUri, int i, int len, String encoding) throws IOException {
        ByteToChar converter = ByteToChar.create();
        if (encoding == null) {
            encoding = "utf-8";
        }
        try {
            converter.setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            dbg.log(e);
        }
        try {
            while (i < len) {
                int ch;
                if ((ch = rawUri[i++] & 0xFF) == 37) {
                    i = Invocation.scanUriEscape(converter, rawUri, i, len);
                    continue;
                }
                converter.addByte(ch);
            }
            return converter.getConvertedString();
        }
        catch (CharConversionException e) {
            throw new BadRequestException(L.l("The URL contains escaped bytes unsupported by the {0} encoding.", encoding));
        }
    }

    private static int scanUriEscape(ByteToChar converter, byte[] rawUri, int i, int len) throws IOException {
        int ch1;
        int n = ch1 = i < len ? rawUri[i++] & 0xFF : -1;
        if (ch1 == 117) {
            ch1 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch2 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch3 = i < len ? rawUri[i++] & 0xFF : -1;
            int ch4 = i < len ? rawUri[i++] & 0xFF : -1;
            converter.addChar((char)((Invocation.toHex(ch1) << 12) + (Invocation.toHex(ch2) << 8) + (Invocation.toHex(ch3) << 4) + Invocation.toHex(ch4)));
        } else {
            int ch2 = i < len ? rawUri[i++] & 0xFF : -1;
            int b = (Invocation.toHex(ch1) << 4) + Invocation.toHex(ch2);
            converter.addByte(b);
        }
        return i;
    }

    private static int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

