/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.ejb.ClientFactory;
import com.caucho.el.VariableResolver;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.InitialContextFactoryImpl;
import com.caucho.naming.LinkProxy;
import com.caucho.naming.MemoryModel;
import com.caucho.naming.java.javaURLContextFactory;
import com.caucho.server.http.Application;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.sql.DBPool;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.servlet.ServletException;

public class JndiFactory {
    static L10N L = new L10N(class$com$caucho$server$http$JndiFactory == null ? (class$com$caucho$server$http$JndiFactory = JndiFactory.class$("com.caucho.server.http.JndiFactory")) : class$com$caucho$server$http$JndiFactory);
    static WriteStream dbg = LogStream.open("/caucho.com/http/jndi");
    private static InitialContextFactory _parentFactory;
    private static Context _cxt;
    static /* synthetic */ Class class$com$caucho$server$http$JndiFactory;
    static /* synthetic */ Class class$java$util$Properties;

    public static void setParentFactory(String parentFactoryName) {
        if (parentFactoryName == null || parentFactoryName.equals((class$com$caucho$server$http$JndiFactory == null ? (class$com$caucho$server$http$JndiFactory = JndiFactory.class$("com.caucho.server.http.JndiFactory")) : class$com$caucho$server$http$JndiFactory).getName())) {
            return;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class cl = CauchoSystem.loadClass(parentFactoryName, true, loader);
            _parentFactory = (InitialContextFactory)cl.newInstance();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    public static Context initContext(RegistryNode registry, ClassLoaderContext classLoaderContext, ClassLoader loader, TransactionManagerImpl tm, ArrayList resources, Context parentContext, VariableResolver env) throws Exception {
        Context ctxEnv;
        AbstractModel model = javaURLContextFactory.getContextModel();
        model = model == null ? new MemoryModel() : model.copy();
        javaURLContextFactory.setContextModel(model);
        Properties props = JndiFactory.fillProperties(registry.lookup("jndi"), classLoaderContext, loader, env);
        model = InitialContextFactoryImpl.getContextModel();
        model = model == null ? new MemoryModel() : model.copy();
        InitialContextFactoryImpl.setContextModel(model);
        Context rootContext = new InitialContext();
        HashMap jndiFactories = new HashMap();
        rootContext = JndiFactory.configureJndiLinks(rootContext, registry, classLoaderContext, loader, props, jndiFactories, env);
        Context comp = (Context)rootContext.lookup("java:comp");
        if (comp == null) {
            comp = rootContext.createSubcontext("java:comp");
        }
        if ((ctxEnv = (Context)comp.lookup("env")) == null) {
            ctxEnv = comp.createSubcontext("env");
        }
        HashMap nameCache = new HashMap();
        if (tm != null) {
            try {
                if (comp.lookup("TransactionManager") == null) {
                    comp.rebind("TransactionManager", (Object)tm);
                }
            }
            catch (Exception e) {
                dbg.log(e);
            }
            try {
                if (comp.lookup("UserTransaction") == null) {
                    comp.rebind("UserTransaction", (Object)tm);
                }
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
        try {
            Class.forName("com.caucho.sql.DBPool");
        }
        catch (Exception e) {
            // empty catch block
        }
        Object exception = null;
        Iterator iter = registry.iterator();
        while (iter.hasNext()) {
            Context context;
            int slash;
            int colon;
            String name;
            RegistryNode node = (RegistryNode)iter.next();
            if (node.getName().equals("env-entry")) {
                name = node.getString("env-entry-name", null);
                String type = node.getString("env-entry-type", null);
                String value = node.getELString("env-entry-value", null, env);
                if (name == null) {
                    throw Application.error(node, L.l("<{0}> expects <{1}>", (Object)"env-entry", "env-entry-name"));
                }
                if (type == null) {
                    throw Application.error(node, L.l("<{0}> expects <{1}>", (Object)"env-entry", "env-entry-type"));
                }
                if (value == null) {
                    throw Application.error(node, L.l("<{0}> expects <{1}>", (Object)"env-entry", "env-entry-value"));
                }
                if (type.equals("java.lang.Boolean")) {
                    JndiFactory.deepBind(ctxEnv, name, new Boolean(value), node);
                    continue;
                }
                if (type.equals("java.lang.Integer")) {
                    JndiFactory.deepBind(ctxEnv, name, new Integer(value), node);
                    continue;
                }
                if (type.equals("java.lang.Long")) {
                    JndiFactory.deepBind(ctxEnv, name, new Long(value), node);
                    continue;
                }
                if (type.equals("java.lang.Double")) {
                    JndiFactory.deepBind(ctxEnv, name, new Double(value), node);
                    continue;
                }
                if (type.equals("java.lang.Float")) {
                    JndiFactory.deepBind(ctxEnv, name, new Float(value), node);
                    continue;
                }
                if (type.equals("java.lang.String")) {
                    JndiFactory.deepBind(ctxEnv, name, value, node);
                    continue;
                }
                throw Application.error(node, L.l("Unknown env-type `{0}'.  env-entry-type must use the full classname for one the known types (java.lang.Boolean, java.lang.Integer, java.lang.Double, java.lang.Float, or java.lang.String).", type));
            }
            if (node.getName().equals("jndi-link")) {
                name = node.getELString("jndi-name", null, env);
                if (name == null || name.equals("")) continue;
                Object newObject = JndiFactory.configureJndiLink(node, classLoaderContext, loader, jndiFactories, env);
                JndiFactory.deepBind(rootContext, name, newObject, node);
                ctxEnv = (Context)rootContext.lookup("java:comp/env");
                continue;
            }
            if (node.getName().equals("resource-ref")) {
                name = node.getString("res-ref-name", null);
                if (name == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"resource-ref", "res-ref-name"));
                }
                Object obj = null;
                String beanName = node.getString("bean-name", null);
                beanName = node.getELString("class-name", beanName, env);
                String type = node.getELString("res-type", null, env);
                if (type == null && beanName == null) {
                    throw Application.error(node, L.l("resource-ref `{0}' expects res-type or class-name attributes (or both).  The class-name specifies the factory class for the resource.  res-type specifies well-known interfaces.", name));
                }
                if (beanName == null) {
                    if (type.equals("javax.sql.DataSource") || type.equals("javax.sql.XADataSource") || type.equals("javax.sql.ConnectionPoolDataSource")) {
                        beanName = "com.caucho.sql.DBPool";
                        if (node.getString("class-name", null) != null) {
                            beanName = node.getString("class-name", null);
                        } else if (node.lookup("init-param") == null && node.lookup("driver-name") == null && node.lookup("driver") == null && node.lookup("data-source") == null && node.getString("class-name", null) == null && node.lookup("init-class") == null) {
                            continue;
                        }
                    } else {
                        beanName = type;
                    }
                }
                obj = beanName.equals("javax.mail.Session") ? JndiFactory.createMailSession(node, env) : BeanUtil.createBean(node, env, beanName);
                if (dbg.canWrite()) {
                    dbg.log("jndi-resource id=" + name + " " + beanName);
                }
                resources.add(obj);
                if (obj instanceof DBPool) {
                    DBPool pool = (DBPool)obj;
                    pool.setName(name);
                    if (tm != null && type.equals("javax.sql.XADataSource")) {
                        pool.setTransactionManager(tm);
                    }
                }
                colon = name.indexOf(58);
                slash = name.indexOf(47);
                context = ctxEnv;
                if (slash == 0 || colon > 0 && (slash < 0 || colon < slash)) {
                    context = rootContext;
                }
                JndiFactory.deepBind(context, name, obj, node);
                if (!(classLoaderContext instanceof Application)) continue;
                ((Application)classLoaderContext).setAttribute(name, obj);
                continue;
            }
            if (!node.getName().equals("ejb-ref")) continue;
            name = node.getString("ejb-ref-name", null);
            if (name == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"ejb-ref", "ejb-ref-name"));
            }
            String factoryName = node.getELString("ejb-ref-factory", null, env);
            if (factoryName == null) continue;
            ClientFactory factory = (ClientFactory)BeanUtil.createBean(node, env, factoryName);
            Object obj = factory.create(loader);
            colon = name.indexOf(58);
            slash = name.indexOf(47);
            context = ctxEnv;
            if (slash == 0 || colon > 0 && (slash < 0 || colon < slash)) {
                context = rootContext;
            }
            JndiFactory.deepBind(context, name, obj, node);
            if (!(classLoaderContext instanceof Application)) continue;
            ((Application)classLoaderContext).setAttribute(name, obj);
        }
        return rootContext;
    }

    private static Context configureJndiLinks(Context rootContext, RegistryNode registry, ClassLoaderContext classLoaderContext, ClassLoader loader, Properties props, HashMap factories, VariableResolver env) throws Exception {
        boolean hasNewRoot = false;
        Iterator iter = registry.select("jndi-link");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String name = node.getString("jndi-name", null);
            if (name != null && !name.equals("")) continue;
            Object root = JndiFactory.configureJndiLink(node, classLoaderContext, loader, factories, env);
            if (root instanceof LinkProxy) {
                root = ((LinkProxy)root).createObject(props);
            }
            rootContext = (Context)root;
            hasNewRoot = true;
        }
        return rootContext;
    }

    private static Object configureJndiLink(RegistryNode registry, ClassLoaderContext app, ClassLoader loader, HashMap factories, VariableResolver env) throws Exception {
        Properties props = JndiFactory.fillProperties(registry, app, loader, env);
        String jndiLookup = registry.getString("jndi-lookup", null);
        String factoryName = registry.getELString("jndi-factory", null, env);
        if (factoryName == null) {
            factoryName = (String)props.get("java.naming.factory.initial");
        }
        if (factoryName == null) {
            throw Application.error(registry, L.l("`{0}' expects `{1}'", (Object)"jndi-link", "jndi-factory"));
        }
        InitialContextFactory factory = null;
        Class cl = CauchoSystem.loadClass(factoryName, false, loader);
        Object factoryObj = cl.newInstance();
        if (factoryObj instanceof InitialContextFactory) {
            factory = (InitialContextFactory)factoryObj;
            factories.put(factoryName, factory);
            return new LinkProxy(factory, props, jndiLookup);
        }
        throw Application.error(registry, L.l("`{0}' must extend InitialContextFactory.  The jndi-link factory must be a classname of a bean that extends javax.naming.InitialContextFactory.", factoryObj.getClass().getName()));
    }

    private static Properties fillProperties(RegistryNode registry, ClassLoaderContext classLoaderContext, ClassLoader loader, VariableResolver env) throws Exception {
        InputStream is;
        Properties props = new Properties();
        if (registry == null) {
            return props;
        }
        String propertyFile = null;
        propertyFile = registry.getString("property-file", null);
        Path appDir = null;
        if (classLoaderContext != null) {
            appDir = classLoaderContext.getRootPath();
        }
        if (propertyFile != null && appDir != null && appDir.lookup(propertyFile).canRead()) {
            is = appDir.lookup(propertyFile).openRead();
            if (is != null) {
                props.load(is);
                is.close();
            }
        } else if (loader != null && propertyFile != null && (is = loader.getResourceAsStream(propertyFile)) != null) {
            props.load(is);
            is.close();
        }
        Iterator iter = registry.select("init-param");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String name = node.getString("param-name", null);
            String value = node.getELString("param-value", null, env);
            if (name != null && value != null) {
                props.put(name, value);
            }
            Iterator subiter = node.iterator();
            while (subiter.hasNext()) {
                RegistryNode paramNode = (RegistryNode)subiter.next();
                if (paramNode.getName().equals("param-name") || paramNode.getName().equals("param-value") || paramNode.getName().equals("description")) continue;
                name = paramNode.getName();
                value = paramNode.getELString(env);
                props.put(name, value);
            }
        }
        return props;
    }

    static void deepBind(Context context, String name, Object obj, RegistryNode node) throws ServletException {
        JndiFactory.deepBind(context, name, obj, node, name);
    }

    static void deepBind(Context context, String name, Object obj, RegistryNode node, String fullName) throws ServletException {
        try {
            NameParser parser = context.getNameParser("");
            Name parsedName = parser.parse(name);
            if (parsedName.size() == 1) {
                context.rebind(name, obj);
                return;
            }
            Object sub = context.lookup(parsedName.get(0));
            if (sub == null) {
                sub = context.createSubcontext(parsedName.get(0));
            }
            if (!(sub instanceof Context)) {
                throw new NamingException(L.l("`{0}' is an invalid JNDI name because `{1} is not a Context.  One of the subcontexts is not a Context as expected.", (Object)fullName, sub));
            }
            JndiFactory.deepBind((Context)sub, parsedName.getSuffix(1).toString(), obj, node, fullName);
        }
        catch (NamingException e) {
            throw Application.error(node, e);
        }
    }

    private static Object createMailSession(RegistryNode node, VariableResolver env) throws ServletException {
        try {
            Class sessionClass = CauchoSystem.loadClass("javax.mail.Session");
            Class authClass = CauchoSystem.loadClass("javax.mail.Authenticator");
            Properties props = new Properties();
            BeanUtil.configure(props, node, env, true, false, true);
            Method method = sessionClass.getMethod("getInstance", class$java$util$Properties == null ? (class$java$util$Properties = JndiFactory.class$("java.util.Properties")) : class$java$util$Properties, authClass);
            Object obj = method.invoke(null, props, null);
            return obj;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static Method getMethod(Method[] methods, String name) {
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

