/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.TcpServer;
import com.caucho.server.http.ResinServer;
import com.caucho.vfs.QJniServerSocket;
import java.util.ArrayList;

public class JniServer
extends ResinServer {
    private int resin;
    private ArrayList sockets;

    public JniServer(int resin, String[] args) throws Exception {
        super(args, false);
        this.resin = resin;
    }

    public void addServerSocket(int fd) {
        QJniServerSocket ss = new QJniServerSocket(fd);
        if (this.sockets == null) {
            this.sockets = new ArrayList();
        }
        this.sockets.add(ss);
    }

    public void waitForExit() {
        boolean socketExceptionCount = false;
        while (!this.isClosed) {
            if (!this.nativeWaitForExit()) continue;
            this.isClosed = true;
        }
        for (int i = 0; i < this.tcpServers.size(); ++i) {
            TcpServer server = (TcpServer)this.tcpServers.get(i);
            if (!server.isDead()) continue;
            this.isClosed = true;
        }
    }

    native boolean nativeWaitForExit();

    public void start() throws Exception {
        int socket;
        while ((socket = this.getServerSocket(this.resin)) != 0) {
            this.addServerSocket(socket);
        }
        this.init(this.sockets);
        this.waitForExit();
        System.err.println(L.l("closing server"));
        this.close();
        System.exit(0);
    }

    native int getServerSocket(int var1);

    public static void main(int resin, String[] args) throws Exception {
        try {
            JniServer server = new JniServer(resin, args);
            server.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            System.loadLibrary("resin");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

