/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.DispatchRequest;
import com.caucho.server.http.DispatchResponse;
import com.caucho.server.http.IncludeDispatchRequest;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.LoginRequest;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.Response;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QRequestDispatcher
implements RequestDispatcher {
    private static String REQUEST_URI = "javax.servlet.include.request_uri";
    private static String CONTEXT_PATH = "javax.servlet.include.context_path";
    private static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static String PATH_INFO = "javax.servlet.include.path_info";
    private static String QUERY_STRING = "javax.servlet.include.query_string";
    private Application application;
    private Invocation invocation;
    private boolean _isLogin;

    QRequestDispatcher(Invocation invocation, Application application) {
        this.invocation = invocation;
        this.application = application;
    }

    public void setLogin(boolean isLogin) {
        this._isLogin = isLogin;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.forward(request, response, null, this._isLogin);
    }

    public void forward(ServletRequest request, ServletResponse response, String method, boolean isLogin) throws ServletException, IOException {
        ResponseAdapter resAdapt = null;
        if (!(response instanceof CauchoResponse)) {
            resAdapt = ResponseAdapter.create((HttpServletResponse)response);
            response = resAdapt;
        }
        CauchoResponse res = (CauchoResponse)response;
        if (!(request instanceof CauchoRequest)) {
            RequestAdapter adapt = RequestAdapter.create();
            adapt.init((HttpServletRequest)request, res, this.application);
            request = adapt;
        }
        CauchoRequest req = (CauchoRequest)request;
        this.forward(req, res, method, isLogin);
        if (resAdapt != null) {
            resAdapt.close();
            ResponseAdapter.free(resAdapt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(CauchoRequest req, CauchoResponse res, String method, boolean isLogin) throws ServletException, IOException {
        Response response = null;
        Object session = null;
        if (res instanceof Response) {
            response = (Response)res;
        }
        if (res.isCommitted() && method == null) {
            IllegalStateException exn = new IllegalStateException("forward() not allowed after buffer has committed.");
            if (!res.hasError()) {
                res.setHasError(true);
                throw exn;
            }
            this.invocation.getApplication().log(exn.getMessage(), exn);
        }
        if (method == null) {
            method = req.getMethod();
        }
        DispatchRequest subRequest = isLogin ? new LoginRequest() : DispatchRequest.createDispatch();
        String newQueryString = this.invocation.getQueryString();
        String reqQueryString = req.getQueryString();
        String queryString = !isLogin ? newQueryString : (reqQueryString == null ? newQueryString : (newQueryString == null ? reqQueryString : newQueryString + '&' + reqQueryString));
        subRequest.init(this.invocation.getApplication(), req, res, method, this.invocation.getUri(), this.invocation.getServletPath(), this.invocation.getPathInfo(), queryString, newQueryString);
        Object oldUri = null;
        Object oldContextPath = null;
        Object oldServletPath = null;
        Object oldPathInfo = null;
        Object oldQueryString = null;
        Object oldJSPFile = null;
        int depth = req.getRequestDepth(0);
        if (depth > 1) {
            oldUri = req.getAttribute(REQUEST_URI);
        }
        if (oldUri != null) {
            oldContextPath = req.getAttribute(CONTEXT_PATH);
            oldServletPath = req.getAttribute(SERVLET_PATH);
            oldPathInfo = req.getAttribute(PATH_INFO);
            oldQueryString = req.getAttribute(QUERY_STRING);
            req.removeAttribute(REQUEST_URI);
            req.removeAttribute(CONTEXT_PATH);
            req.removeAttribute(SERVLET_PATH);
            req.removeAttribute(PATH_INFO);
            req.removeAttribute(QUERY_STRING);
            req.removeAttribute("caucho.jsp.jsp-file");
        }
        subRequest.setPageURI(subRequest.getRequestURI());
        subRequest.setPageContextPath(subRequest.getContextPath());
        subRequest.setPageServletPath(subRequest.getServletPath());
        subRequest.setPagePathInfo(subRequest.getPathInfo());
        subRequest.setPageQueryString(subRequest.getQueryString());
        AbstractRequest oldRequest = null;
        if (response != null) {
            oldRequest = response.getRequest();
            response.setRequest(subRequest);
        }
        subRequest.setStream(req.getStream());
        ClassLoader oldLoader = CauchoSystem.getContextClassLoader();
        WriteStream oldStream = null;
        if (response != null) {
            oldStream = response.getStream();
            response.setStream(response.getOriginalStream());
        }
        try {
            res.resetBuffer();
            res.setContentLength(-1);
            this.invocation.service(subRequest, res);
            if (response != null) {
                response.finish(true);
            } else {
                try {
                    ServletOutputStream os = res.getOutputStream();
                    os.close();
                }
                catch (IllegalStateException e) {
                    try {
                        PrintWriter out = res.getWriter();
                        out.close();
                    }
                    catch (IllegalStateException e1) {
                    }
                }
            }
            Object var24_25 = null;
        }
        catch (Throwable throwable) {
            Object var24_26 = null;
            CauchoSystem.setContextClassLoader(oldLoader);
            if (response != null) {
                response.setRequest(oldRequest);
                response.setStream(oldStream);
            }
            if (!isLogin) {
                DispatchRequest.free(subRequest);
            }
            if (oldUri != null) {
                req.setAttribute(REQUEST_URI, oldUri);
            }
            if (oldContextPath != null) {
                req.setAttribute(CONTEXT_PATH, oldContextPath);
            }
            if (oldServletPath != null) {
                req.setAttribute(SERVLET_PATH, oldServletPath);
            }
            if (oldPathInfo != null) {
                req.setAttribute(PATH_INFO, oldPathInfo);
            }
            if (oldQueryString != null) {
                req.setAttribute(QUERY_STRING, oldQueryString);
            }
            throw throwable;
        }
        CauchoSystem.setContextClassLoader(oldLoader);
        if (response != null) {
            response.setRequest(oldRequest);
            response.setStream(oldStream);
        }
        if (!isLogin) {
            DispatchRequest.free(subRequest);
        }
        if (oldUri != null) {
            req.setAttribute(REQUEST_URI, oldUri);
        }
        if (oldContextPath != null) {
            req.setAttribute(CONTEXT_PATH, oldContextPath);
        }
        if (oldServletPath != null) {
            req.setAttribute(SERVLET_PATH, oldServletPath);
        }
        if (oldPathInfo != null) {
            req.setAttribute(PATH_INFO, oldPathInfo);
        }
        if (oldQueryString != null) {
            req.setAttribute(QUERY_STRING, oldQueryString);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response, null);
    }

    public void chain(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.include(request, response, "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void include(ServletRequest request, ServletResponse response, String method) throws ServletException, IOException {
        String queryString = this.invocation.getQueryString();
        ResponseAdapter resAdapt = null;
        if (!(response instanceof CauchoResponse)) {
            resAdapt = ResponseAdapter.create((HttpServletResponse)response);
            response = resAdapt;
        }
        CauchoResponse res = (CauchoResponse)response;
        if (!(request instanceof CauchoRequest)) {
            RequestAdapter adapt = RequestAdapter.create();
            adapt.init((HttpServletRequest)request, res, this.application);
            request = adapt;
        }
        CauchoRequest req = (CauchoRequest)request;
        if (method == null) {
            method = req.getMethod();
        }
        IncludeDispatchRequest subRequest = IncludeDispatchRequest.createIncludeDispatch();
        subRequest.init(this.invocation.getApplication(), req, res, method, req.getRequestURI(), req.getServletPath(), req.getPathInfo(), req.getQueryString(), queryString);
        DispatchResponse subResponse = DispatchResponse.createDispatch(res);
        WriteStream s = res.getStream();
        boolean oldDisableClose = s.getDisableClose();
        s.setDisableClose(true);
        subResponse.init(subRequest, s);
        subResponse.start();
        subResponse.setCharacterEncoding(res.getCharacterEncoding());
        int depth = req.getRequestDepth(0);
        Object oldUri = null;
        Object oldContextPath = null;
        Object oldServletPath = null;
        Object oldPathInfo = null;
        Object oldQueryString = null;
        if (depth > 1) {
            oldUri = req.getAttribute(REQUEST_URI);
            oldContextPath = request.getAttribute(CONTEXT_PATH);
            oldServletPath = req.getAttribute(SERVLET_PATH);
            oldPathInfo = req.getAttribute(PATH_INFO);
            oldQueryString = req.getAttribute(QUERY_STRING);
        }
        subRequest.setPageURI(this.invocation.getUri());
        subRequest.setAttribute(REQUEST_URI, this.invocation.getUri());
        String contextPath = this.invocation.getApplication().getServletContextName();
        subRequest.setPageContextPath(contextPath);
        subRequest.setAttribute(CONTEXT_PATH, contextPath);
        subRequest.setPageServletPath(this.invocation.getServletPath());
        subRequest.setAttribute(SERVLET_PATH, this.invocation.getServletPath());
        subRequest.setPagePathInfo(this.invocation.getPathInfo());
        subRequest.setAttribute(PATH_INFO, this.invocation.getPathInfo());
        subRequest.setPageQueryString(queryString);
        subRequest.setAttribute(QUERY_STRING, queryString);
        subRequest.removeAttribute("caucho.jsp.jsp-file");
        ClassLoader oldLoader = CauchoSystem.getContextClassLoader();
        try {
            this.invocation.service(subRequest, subResponse);
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            CauchoSystem.setContextClassLoader(oldLoader);
            s.setDisableClose(oldDisableClose);
            if (oldUri != null) {
                req.setAttribute(REQUEST_URI, oldUri);
            } else {
                req.removeAttribute(REQUEST_URI);
            }
            if (oldContextPath != null) {
                req.setAttribute(CONTEXT_PATH, oldContextPath);
            } else {
                req.removeAttribute(CONTEXT_PATH);
            }
            if (oldServletPath != null) {
                req.setAttribute(SERVLET_PATH, oldServletPath);
            } else {
                req.removeAttribute(SERVLET_PATH);
            }
            if (oldPathInfo != null) {
                req.setAttribute(PATH_INFO, oldPathInfo);
            } else {
                req.removeAttribute(PATH_INFO);
            }
            if (oldQueryString != null) {
                req.setAttribute(QUERY_STRING, oldQueryString);
            } else {
                req.removeAttribute(QUERY_STRING);
            }
            subResponse.finish(false);
            IncludeDispatchRequest.free(subRequest);
            DispatchResponse.free(subResponse);
            throw throwable;
        }
        CauchoSystem.setContextClassLoader(oldLoader);
        s.setDisableClose(oldDisableClose);
        if (oldUri != null) {
            req.setAttribute(REQUEST_URI, oldUri);
        } else {
            req.removeAttribute(REQUEST_URI);
        }
        if (oldContextPath != null) {
            req.setAttribute(CONTEXT_PATH, oldContextPath);
        } else {
            req.removeAttribute(CONTEXT_PATH);
        }
        if (oldServletPath != null) {
            req.setAttribute(SERVLET_PATH, oldServletPath);
        } else {
            req.removeAttribute(SERVLET_PATH);
        }
        if (oldPathInfo != null) {
            req.setAttribute(PATH_INFO, oldPathInfo);
        } else {
            req.removeAttribute(PATH_INFO);
        }
        if (oldQueryString != null) {
            req.setAttribute(QUERY_STRING, oldQueryString);
        } else {
            req.removeAttribute(QUERY_STRING);
        }
        subResponse.finish(false);
        IncludeDispatchRequest.free(subRequest);
        DispatchResponse.free(subResponse);
        if (resAdapt != null) {
            resAdapt.close();
            ResponseAdapter.free(resAdapt);
        }
    }
}

