/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.http.session.SessionImpl;
import com.caucho.http.session.SessionManager;
import com.caucho.java.LineMap;
import com.caucho.java.LineMapException;
import com.caucho.server.Connection;
import com.caucho.server.ServerRequest;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.BadRequestException;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.Form;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.MultipartForm;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.QServletInputStream;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.transaction.TransactionImpl;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.CompileException;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.FreeList;
import com.caucho.util.NullEnumeration;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public abstract class Request
extends AbstractRequest
implements ServerRequest {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    private static final String CHAR_ENCODING = "resin.form.character.encoding";
    private static final String FORM_LOCALE = "resin.form.local";
    private static final String CAUCHO_CHAR_ENCODING = "caucho.form.character.encoding";
    static final int HTTP_0_9 = 9;
    static final int HTTP_1_0 = 256;
    static final int HTTP_1_1 = 257;
    static CharBuffer getCb = new CharBuffer("GET");
    static CharBuffer headCb = new CharBuffer("HEAD");
    static CharBuffer postCb = new CharBuffer("POST");
    static char[] contentLengthCb = "Content-Length".toCharArray();
    static FreeList freeCharBuffers = new FreeList(128);
    static FreeList freeArrayLists = new FreeList(128);
    protected ServletServer server;
    protected Connection conn;
    private long date;
    protected int version;
    protected InvocationKey invocationKey = new InvocationKey();
    private Cookie[] cookiesIn;
    private ArrayList cookies = new ArrayList();
    private CharBuffer cbName = new CharBuffer();
    private CharBuffer cbValue = new CharBuffer();
    private ArrayList arrayList = new ArrayList();
    protected int sessionGroup;
    private SessionImpl session;
    protected ReadStream rawStream;
    protected ReadStream filterStream;
    protected boolean hasInputStream;
    private ContentLengthStream contentLengthStream;
    private ChunkedInputStream chunkedInputStream;
    protected QServletInputStream is;
    private String encoding;
    private BufferedReaderAdapter bufferedReader;
    private String method;
    private HashMap form = new HashMap();
    private HashMap filledForm;
    private Hashtable attributes;
    private ArrayList locales;
    protected Response response;
    protected CharBuffer cb;
    private byte[] byteBuffer;
    protected boolean isSecure;
    private long testDate;
    protected boolean bogusSecure;
    protected TransactionImpl currentTransaction;
    protected ArrayList closeOnExit;
    private Form _formParser = new Form();
    static /* synthetic */ Class class$javax$servlet$ServletException;

    protected Request(ServletServer server) {
        this.server = server;
        if (server == null) {
            throw new RuntimeException();
        }
        this.contentLengthStream = new ContentLengthStream();
        this.chunkedInputStream = new ChunkedInputStream();
        this.filterStream = new ReadStream();
        this.filterStream.setReuseBuffer(true);
        this.is = new QServletInputStream();
        this.bufferedReader = new BufferedReaderAdapter(this.filterStream);
        this.attributes = new Hashtable();
        this.locales = new ArrayList();
        this.cb = new CharBuffer();
        this.byteBuffer = new byte[256];
    }

    public void init() {
        super.init();
        this.currentTransaction = null;
    }

    protected void start(ReadStream s) throws IOException {
        super.start();
        this.rawStream = s;
        this.date = Alarm.getCurrentTime();
        this.testDate = this.server._bogusDate;
        this.cookiesIn = null;
        this.cookies.clear();
        this.invocation = null;
        this.cache = null;
        this.hasInputStream = false;
        this.version = -1;
        this.isSecure = this.bogusSecure;
        this.sessionGroup = -1;
        this.session = null;
        this.method = null;
        if (this.attributes.size() > 0) {
            this.attributes.clear();
        }
        this.filledForm = null;
        if (this.locales.size() > 0) {
            this.locales.clear();
        }
        this.encoding = null;
        this.response.start();
    }

    void setStartDate() {
        this.date = Alarm.getCurrentTime();
    }

    protected void setConnection(Connection conn) {
        this.conn = conn;
    }

    public CauchoResponse getResponse() {
        return this.response;
    }

    public String getChain(String contentType) {
        QServletConfig config = this.getServletConfig();
        if (config == null) {
            return null;
        }
        return config.getChain(contentType);
    }

    public ReadStream getRawInput() {
        throw new UnsupportedOperationException(L.l("raw mode is not supported in this configuration"));
    }

    public abstract void setHeader(String var1, String var2);

    void sendServletError(Throwable e) throws IOException {
        boolean doStackTrace;
        Throwable rootExn = e;
        LineMap lineMap = null;
        this.response.killCache();
        this.response.killChaining();
        try {
            this.response.reset(true);
        }
        catch (IllegalStateException e1) {
            // empty catch block
        }
        Application app = this.getApplication();
        if (rootExn instanceof ClientDisconnectException) {
            throw (ClientDisconnectException)rootExn;
        }
        String location = null;
        while (true) {
            if (rootExn instanceof LineMapException) {
                lineMap = ((LineMapException)((Object)rootExn)).getLineMap();
            }
            if (location == null && app != null) {
                location = rootExn == e ? app.getErrorPage(rootExn, class$javax$servlet$ServletException == null ? Request.class$("javax.servlet.ServletException") : class$javax$servlet$ServletException) : app.getErrorPage(rootExn);
            }
            Throwable cause = null;
            if (rootExn instanceof ServletException) {
                cause = ((ServletException)rootExn).getRootCause();
            } else if (rootExn instanceof ExceptionWrapper) {
                cause = ((ExceptionWrapper)((Object)rootExn)).getRootCause();
            }
            if (cause == null) break;
            rootExn = cause;
        }
        if (app != null) {
            location = app.getErrorPage(rootExn);
        }
        if (location == null && app != null) {
            location = app.getErrorPage(500);
        }
        String title = "500 Servlet Exception";
        boolean badRequest = false;
        boolean bl = doStackTrace = !(rootExn instanceof CompileException);
        if (rootExn instanceof BadRequestException) {
            title = "400 Bad Request " + rootExn.getMessage();
            doStackTrace = false;
            badRequest = true;
            this.response.setStatus(400, "Bad Request " + rootExn.getMessage());
        } else if (rootExn instanceof UnavailableException) {
            this.response.setStatus(503);
            title = "503 Unavailable";
        } else if (app != null && app.getServer().isClosed()) {
            this.response.setStatus(503);
            title = "503 Unavailable";
        } else {
            this.response.setStatus(500);
        }
        if (!badRequest) {
            if (app == null) {
                dbg.log(rootExn);
            } else {
                app.log(e.getMessage(), e, this, this.getResponse());
            }
            if (location != null) {
                this.setAttribute(JSP_EXCEPTION, rootExn);
                this.setAttribute(EXCEPTION, rootExn);
                this.setAttribute(EXCEPTION_TYPE, rootExn.getClass());
                this.setAttribute(ERROR_URI, this.getRequestURI());
                if (this.invocation != null) {
                    this.setAttribute(SERVLET_NAME, this.invocation.getServletName());
                }
                this.setAttribute(AbstractRequest.STATUS_CODE, new Integer(500));
                this.setAttribute(MESSAGE, rootExn.getMessage());
                if (app != null && app.getServer().isClosed()) {
                    this.setAttribute(SHUTDOWN, "shutdown");
                }
                try {
                    QRequestDispatcher disp = (QRequestDispatcher)app.getRequestDispatcher(location);
                    if (disp != null) {
                        disp.forward(this, this.response, "GET", false);
                        return;
                    }
                }
                catch (Throwable e1) {
                    dbg.log(e1);
                }
            }
        }
        this.response.setContentType("text/html");
        Locale locale = Locale.getDefault();
        if (!"ISO-8859-1".equals(Encoding.getMimeName(locale))) {
            this.response.setLocale(Locale.getDefault());
        }
        PrintWriter pw = this.response.getWriter();
        if (!this.response.isCommitted()) {
            pw.println("<title>" + title + "</title>");
        }
        pw.println("<h1>" + title + "</h1>");
        pw.println("<code><pre>");
        if (app != null && app.getServer().isClosed()) {
            pw.println("Server is temporarily unavailable");
            doStackTrace = false;
        } else if (rootExn instanceof CompileException) {
            pw.println(this.escapeHtml(rootExn.getMessage()));
        } else if (rootExn instanceof BadRequestException) {
            pw.println(this.escapeHtml(rootExn.getMessage()));
        } else if (!doStackTrace) {
            pw.println(this.escapeHtml(rootExn.toString()));
        }
        if (doStackTrace || dbg.canWrite()) {
            this.printStackTrace(pw, rootExn, lineMap);
        }
        pw.println("</pre></code>");
        if (!CauchoSystem.isTesting()) {
            pw.println("<hr /><small>");
            pw.println(Version.FULL_VERSION);
            pw.println("</small>");
        }
        pw.close();
    }

    private void printStackTrace(PrintWriter out, Throwable e, LineMap lineMap) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        if (lineMap != null) {
            lineMap.printStackTrace(e, pw);
        } else {
            e.printStackTrace(pw);
        }
        pw.close();
        char[] array = writer.toCharArray();
        out.print(this.escapeHtml(new String(array)));
    }

    private String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        CharBuffer cb = new CharBuffer();
        int lineCharacter = 0;
        boolean startsWithSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            ++lineCharacter;
            if (ch == '<') {
                cb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                cb.append("&amp;");
                continue;
            }
            if (ch == '\n' || ch == '\r') {
                lineCharacter = 0;
                cb.append(ch);
                startsWithSpace = false;
                continue;
            }
            if (lineCharacter > 70 && ch == ' ' && !startsWithSpace) {
                lineCharacter = 0;
                cb.append('\n');
                while (i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                    ++i;
                }
                continue;
            }
            if (lineCharacter == 1 && (ch == ' ' || ch == '\t')) {
                cb.append(ch);
                startsWithSpace = true;
                continue;
            }
            cb.append(ch);
        }
        return cb.toString();
    }

    private void handleError(Throwable cause) {
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            this.response.closeConnection();
        }
    }

    protected void finish() throws IOException {
        SessionImpl session = this.session;
        this.session = null;
        if (session != null) {
            session.finish();
        }
        if (this.currentTransaction != null) {
            this.currentTransaction.close();
        }
        for (int i = 0; this.closeOnExit != null && i < this.closeOnExit.size(); ++i) {
            Path path = (Path)this.closeOnExit.get(i);
            try {
                path.remove();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.closeOnExit != null) {
            this.closeOnExit.clear();
        }
        this.skip();
    }

    void skip() throws IOException {
        if (!this.getMethodBuffer().matches(getCb)) {
            try {
                ServletInputStream is = this.getInputStream();
                while (is.skip(65536L) > 0L) {
                }
            }
            catch (IOException e) {
                this.response.closeConnection();
                dbg.log(e);
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String te;
        if (this.hasInputStream) {
            return this.is;
        }
        this.hasInputStream = true;
        int contentLength = this.getContentLength();
        if (contentLength < 0 && this.getVersion() >= 257 && (te = this.getHeader("Transfer-Encoding")) != null) {
            this.chunkedInputStream.init(this, this.rawStream);
            this.filterStream.init(this.chunkedInputStream, null);
            this.is.init(this.filterStream);
        } else {
            this.contentLengthStream.init(this, this.rawStream, contentLength);
            this.filterStream.init(this.contentLengthStream, null);
            this.is.init(this.filterStream);
        }
        String charEncoding = this.getCharacterEncoding();
        String javaEncoding = Encoding.getJavaName(charEncoding);
        this.filterStream.setEncoding(javaEncoding);
        return this.is;
    }

    public ReadStream getStream() throws IOException {
        this.getInputStream();
        return this.filterStream;
    }

    public int getRequestDepth() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        this.bufferedReader.init(this.getStream());
        return this.bufferedReader;
    }

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRemoteAddr();

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        String str = this.getRemoteAddr();
        for (int i = 0; i < str.length(); ++i) {
            buffer[offset++] = (byte)str.charAt(i);
        }
        return offset;
    }

    public abstract String getRemoteHost();

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public abstract CharSegment getMethodBuffer();

    public String getMethod() {
        if (this.method == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this.method = "GET";
                return this.method;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this.method = cb.equals(getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this.method = cb.equals(headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this.method = cb.equals(postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this.method = cb.toString();
                }
            }
        }
        return this.method;
    }

    void setMethod(String method) {
        this.method = method;
    }

    public String getProtocol() {
        return this.getProtocolBuffer().toString();
    }

    public abstract CharSegment getProtocolBuffer();

    int getVersion() {
        char ch;
        if (this.version > 0) {
            return this.version;
        }
        CharSegment protocol = this.getProtocolBuffer();
        if (protocol.length() < 8) {
            this.version = 9;
            return this.version;
        }
        if (protocol.equals("HTTP/1.0")) {
            this.version = 256;
            return this.version;
        }
        if (protocol.equals("HTTP/1.1")) {
            this.version = 257;
            return 257;
        }
        if (protocol.equals("HTTP/0.9")) {
            this.version = 9;
            return 9;
        }
        int i = protocol.indexOf('/');
        int len = protocol.length();
        int major = 0;
        ++i;
        while (i < len) {
            char ch2 = protocol.charAt(i);
            if (ch2 < '0' || ch2 > '9') {
                if (ch2 == '.') break;
                this.version = 256;
                return this.version;
            }
            major = 10 * major + ch2 - 48;
            ++i;
        }
        int minor = 0;
        ++i;
        while (i < len && (ch = protocol.charAt(i)) >= '0' && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        this.version = 256 * major + minor;
        return this.version;
    }

    public String getRequestURI() {
        if (this.invocation == null) {
            try {
                return new String(this.getUriBuffer(), 0, this.getUriLength(), "UTF8");
            }
            catch (Exception e) {
                try {
                    return new String(this.getUriBuffer(), 0, this.getUriLength(), "ISO8859_1");
                }
                catch (Exception e1) {
                    return "bad-uri";
                }
            }
        }
        return this.invocation.getRawUri();
    }

    public String getPageURI() {
        return this.invocation.getRawUri();
    }

    public abstract byte[] getUriBuffer();

    public abstract int getUriLength();

    public String getContextPath() {
        return this.invocation.getContextPath();
    }

    public String getPageContextPath() {
        return this.invocation.getContextPath();
    }

    public String getServletPath() {
        return this.invocation.getServletPath();
    }

    public String getPageServletPath() {
        return this.invocation.getServletPath();
    }

    public String getPathInfo() {
        return this.invocation.getPathInfo();
    }

    public String getPagePathInfo() {
        return this.invocation.getPathInfo();
    }

    public String getRealPath(String path) {
        int p;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return this.invocation.getApplication().getRealPath(path);
        }
        String uri = this.getPageURI();
        String context = this.getPageContextPath();
        if (context != null) {
            uri = uri.substring(context.length());
        }
        if ((p = uri.lastIndexOf(47)) >= 0) {
            path = uri.substring(0, p + 1) + path;
        }
        return this.invocation.getApplication().getRealPath(path);
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return this.getRealPath(pathInfo);
    }

    public String getQueryString() {
        if (this.invocation != null) {
            return this.invocation.getQueryString();
        }
        return null;
    }

    public String getPageQueryString() {
        return this.getQueryString();
    }

    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public abstract CharSegment getHeaderBuffer(String var1);

    public abstract CharSegment getHeaderBuffer(char[] var1, int var2);

    public abstract void getHeaderBuffers(ArrayList var1, String var2);

    public abstract Enumeration getHeaderNames();

    public int getContentLength() {
        char ch;
        int i;
        CharSegment cl = this.getHeaderBuffer(contentLengthCb, contentLengthCb.length);
        if (cl == null) {
            return -1;
        }
        int value = 0;
        for (i = 0; i < cl.length() && (ch = cl.charAt(i)) >= '0' && ch <= '9'; ++i) {
            value = 10 * value + ch - 48;
        }
        return i == 0 ? -1 : value;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getCharacterEncoding() {
        int tail;
        if (this.encoding != null) {
            return this.encoding;
        }
        String value = this.getHeader("content-type");
        if (value == null) {
            return null;
        }
        int i = value.indexOf("charset");
        if (i < 0) {
            return null;
        }
        int len = value.length();
        i += 7;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len || value.charAt(i) != '=') {
            return null;
        }
        ++i;
        while (i < len && Character.isWhitespace(value.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return null;
        }
        char end = value.charAt(i);
        if (end == '\"') {
            int tail2;
            for (tail2 = ++i; tail2 < len && value.charAt(tail2) != end; ++tail2) {
            }
            return Encoding.getMimeName(value.substring(i, tail2));
        }
        for (tail = i; tail < len && !Character.isWhitespace(value.charAt(tail)) && value.charAt(tail) != ';'; ++tail) {
        }
        return Encoding.getMimeName(value.substring(i, tail));
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
        try {
            this.getStream().setEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            dbg.log(e);
        }
    }

    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        if (this.cookiesIn == null) {
            this.fillCookies();
        }
        if (this.cookiesIn != null && this.cookiesIn.length > 0) {
            this.setHasCookie();
        }
        if (this.cookiesIn == null || this.cookiesIn.length == 0) {
            return null;
        }
        return this.cookiesIn;
    }

    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        if (this.cookiesIn == null) {
            this.fillCookies();
        }
        if (this.cookiesIn == null) {
            return null;
        }
        for (int i = 0; i < this.cookiesIn.length; ++i) {
            if (!this.cookiesIn[i].getName().equals(name)) continue;
            this.setHasCookie();
            return this.cookiesIn[i];
        }
        return null;
    }

    private void fillCookies() {
        this.arrayList.clear();
        this.getHeaderBuffers(this.arrayList, "Cookie");
        for (int i = 0; i < this.arrayList.size(); ++i) {
            CharSegment rawCookie = (CharSegment)this.arrayList.get(i);
            this.fillCookie(this.cookies, rawCookie);
        }
        this.cookiesIn = new Cookie[this.cookies.size()];
        this.cookies.toArray(this.cookiesIn);
    }

    private void fillCookie(ArrayList cookies, CharSegment rawCookie) {
        int j = 0;
        int len = rawCookie.length();
        int version = 0;
        Cookie cookie = null;
        while (j < len) {
            char ch = '\u0000';
            this.cbName.clear();
            this.cbValue.clear();
            while (j < len && ((ch = rawCookie.charAt(j)) == ' ' || ch == ';' || ch == ',')) {
                ++j;
            }
            if (j >= len) break;
            boolean isSpecial = false;
            if (rawCookie.charAt(j) == '$') {
                isSpecial = true;
                ++j;
            }
            while (j < len && (ch = rawCookie.charAt(j)) != ' ' && ch != '=' && ch != ';' && ch != ',') {
                this.cbName.append(ch);
                ++j;
            }
            while (j < len && (ch = rawCookie.charAt(j)) == ' ') {
                ++j;
            }
            if (j >= len) break;
            if (ch == ';' || ch == ',') {
                try {
                    cookie = new Cookie(this.cbName.toString(), "");
                    cookie.setVersion(version);
                    cookies.add(cookie);
                }
                catch (Exception e) {
                    if (!dbg.canWrite()) continue;
                    dbg.log(e);
                }
                continue;
            }
            if (ch != '=') {
                while (j < len && (ch = rawCookie.charAt(j)) != ';') {
                    ++j;
                }
                continue;
            }
            ++j;
            while (j < len && (ch = rawCookie.charAt(j)) == ' ') {
                ++j;
            }
            if (ch == '\"') {
                ++j;
                while (j < len && (ch = rawCookie.charAt(j)) != '\"') {
                    this.cbValue.append(ch);
                    ++j;
                }
                ++j;
            } else {
                while (j < len && (ch = rawCookie.charAt(j)) != ' ' && ch != ';' && ch != ',') {
                    this.cbValue.append(ch);
                    ++j;
                }
            }
            if (!isSpecial) {
                if (this.cbName.length() == 0) {
                    this.getApplication().log("bad cookie: " + rawCookie);
                    continue;
                }
                cookie = new Cookie(this.cbName.toString(), this.cbValue.toString());
                cookie.setVersion(version);
                cookies.add(cookie);
                continue;
            }
            if (cookie == null) {
                if (!this.cbName.matchesIgnoreCase("Version")) continue;
                version = this.cbValue.charAt(0) - 48;
                continue;
            }
            if (this.cbName.matchesIgnoreCase("Version")) {
                cookie.setVersion(this.cbValue.charAt(0) - 48);
                continue;
            }
            if (this.cbName.matchesIgnoreCase("Domain")) {
                cookie.setDomain(this.cbValue.toString());
                continue;
            }
            if (!this.cbName.matchesIgnoreCase("Path")) continue;
            cookie.setPath(this.cbValue.toString());
        }
    }

    protected void setVaryCookie(String cookie) {
        super.setVaryCookie(cookie);
        this.response.setPrivateCache(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null && this.session.isValid()) {
            return this.session;
        }
        boolean hasOldSession = this.session != null;
        this.session = this.createSession(create, hasOldSession);
        if (this.session != null) {
            this.session.addUse();
        }
        return this.session;
    }

    public boolean isRequestedSessionIdValid() {
        String id = this.getRequestedSessionId();
        if (id == null) {
            return false;
        }
        SessionImpl session = (SessionImpl)this.getSession(false);
        return session != null && session.isValid() && session.getId().equals(id);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.findSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.findSessionIdFromUrl() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public String getRequestedSessionId() {
        String id;
        SessionManager manager;
        Application app = this.getApplication();
        SessionManager sessionManager = manager = app != null ? app.getSessionManager() : null;
        if (manager != null && manager.enableSessionCookies()) {
            this.setVaryCookie(manager.getCookieName());
            id = this.findSessionIdFromCookie();
            if (id != null) {
                this.setHasCookie();
                return id;
            }
        }
        if ((id = this.findSessionIdFromUrl()) != null) {
            return id;
        }
        if (manager != null && manager.enableSessionCookies()) {
            return null;
        }
        return this.findSessionIdFromConnection();
    }

    public String findSessionIdFromConnection() {
        return null;
    }

    private String findSessionIdFromCookie() {
        Application application = this.getApplication();
        SessionManager manager = application.getSessionManager();
        if (!manager.enableSessionCookies()) {
            return null;
        }
        Cookie cookie = this.getCookie(manager.getCookieName());
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    private String findSessionIdFromUrl() {
        String id;
        Application application = this.getApplication();
        SessionManager manager = application.getSessionManager();
        if (manager != null) {
            this.setVaryCookie(manager.getCookieName());
        }
        String string = id = this.invocation != null ? this.invocation.getSessionId() : null;
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    public int getSessionGroup() {
        return this.sessionGroup;
    }

    private HashMap parseQuery() {
        block20: {
            try {
                Locale locale;
                this.form.clear();
                String query = this.getQueryString();
                String contentType = this.getContentType();
                if (query == null && contentType == null) {
                    return this.form;
                }
                String charEncoding = this.getCharacterEncoding();
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CAUCHO_CHAR_ENCODING);
                }
                if (charEncoding == null) {
                    charEncoding = (String)this.getAttribute(CHAR_ENCODING);
                }
                if (charEncoding == null && (locale = (Locale)this.getAttribute(FORM_LOCALE)) != null) {
                    charEncoding = Encoding.getMimeName(locale);
                }
                if (charEncoding == null) {
                    charEncoding = this.invocation.getApplication().getCharEncoding();
                }
                String javaEncoding = Encoding.getJavaName(charEncoding);
                if (query != null) {
                    this._formParser.parseQueryString(this.form, query, javaEncoding);
                }
                if (contentType == null || !this.getMethod().equalsIgnoreCase("POST")) break block20;
                if (contentType.startsWith("application/x-www-form-urlencoded")) {
                    this._formParser.parsePostData(this.form, (InputStream)this.getInputStream(), javaEncoding);
                    break block20;
                }
                if (!this.getApplication().doMultipartForm() || !contentType.startsWith("multipart/form-data")) break block20;
                int length = contentType.length();
                int i = contentType.indexOf("boundary=");
                if (i < 0) {
                    return this.form;
                }
                long formUploadMax = this.getApplication().getFormUploadMax();
                if (formUploadMax >= 0L && (long)this.getContentLength() > formUploadMax) {
                    this.setAttribute("caucho.multipart.form.error", L.l("Multipart form upload of `{0}' bytes was too large.", String.valueOf(this.getContentLength())));
                    return this.form;
                }
                char ch = contentType.charAt(i += "boundary=".length());
                CharBuffer boundary = CharBuffer.allocate();
                if (ch == '\'') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\'') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else if (ch == '\"') {
                    ++i;
                    while (i < length && contentType.charAt(i) != '\"') {
                        boundary.append(contentType.charAt(i));
                        ++i;
                    }
                } else {
                    while (i < length && (ch = contentType.charAt(i)) != ' ' && ch != ';') {
                        boundary.append(ch);
                        ++i;
                    }
                }
                try {
                    MultipartForm.parsePostData(this.form, this.getStream(), boundary.close(), this, javaEncoding, formUploadMax);
                }
                catch (IOException e) {
                    dbg.log(e);
                    this.setAttribute("caucho.multipart.form.error", e.getMessage());
                }
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
        return this.form;
    }

    public Enumeration getParameterNames() {
        if (this.filledForm == null) {
            this.filledForm = this.parseQuery();
        }
        if (this.filledForm.size() == 0) {
            return NullEnumeration.create();
        }
        return Collections.enumeration(this.filledForm.keySet());
    }

    public Map getParameterMap() {
        if (this.filledForm == null) {
            this.filledForm = this.parseQuery();
        }
        return Collections.unmodifiableMap(this.filledForm);
    }

    public String[] getParameterValues(String name) {
        if (this.filledForm == null) {
            this.filledForm = this.parseQuery();
        }
        return (String[])this.filledForm.get(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Enumeration getHeaders(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return NullEnumeration.create();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        return Collections.enumeration(list);
    }

    public Locale getLocale() {
        Enumeration locales = this.getLocales();
        if (!locales.hasMoreElements()) {
            return Locale.getDefault();
        }
        return (Locale)locales.nextElement();
    }

    public Enumeration getLocales() {
        if (this.locales.size() == 0) {
            this.fillLocales();
        }
        return Collections.enumeration(this.locales);
    }

    private void fillLocales() {
        Enumeration headers = this.getHeaders("Accept-Language");
        if (headers == null) {
            return;
        }
        block0: while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            StringCharCursor cursor = new StringCharCursor(header);
            while (true) {
                char ch;
                if (cursor.current() == '\uffff') continue block0;
                while (Character.isWhitespace(cursor.current())) {
                    cursor.next();
                }
                this.cb.clear();
                while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                    this.cb.append(cursor.current());
                    cursor.next();
                }
                String language = this.cb.toString();
                String country = "";
                if (cursor.current() == '-' || cursor.current() == '_') {
                    this.cb.clear();
                    cursor.next();
                    while ((ch = cursor.current()) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0') {
                        this.cb.append(cursor.current());
                        cursor.next();
                    }
                    country = this.cb.toString();
                }
                if (language.length() > 0) {
                    Locale locale = new Locale(language, country);
                    this.locales.add(locale);
                }
                while (true) {
                    if (cursor.current() == '\uffff' || cursor.current() == ',') break;
                    cursor.next();
                }
                cursor.next();
            }
        }
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    Invocation getInvocation() {
        return this.invocation;
    }

    public Application getApplication() {
        if (this.invocation == null) {
            return this.server.getDefaultApplication();
        }
        return this.invocation.getApplication();
    }

    public Application getRequestApplication() {
        if (this.invocation == null) {
            return null;
        }
        return this.invocation.getApplication();
    }

    QServletConfig getServletConfig() {
        return this.invocation == null ? null : this.invocation.getServletConfig();
    }

    public long getDate() {
        return this.testDate > 0L ? this.testDate : this.date;
    }

    public boolean isTesting() {
        return this.testDate > 0L;
    }

    void setDate(long date) {
        this.testDate = date;
    }

    void addDate(long delta) {
        this.testDate += delta;
    }

    void addCloseOnExit(Path path) {
        if (this.closeOnExit == null) {
            this.closeOnExit = new ArrayList();
        }
        this.closeOnExit.add(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ContentLengthStream
    extends StreamImpl {
        private Request request;
        private ReadStream next;
        private int length;

        ContentLengthStream() {
        }

        void init(Request request, ReadStream next, int length) {
            this.request = request;
            this.next = next;
            this.length = length;
        }

        public boolean canRead() {
            return true;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (length > this.length) {
                length = this.length;
            }
            if (length <= 0) {
                return -1;
            }
            int len = this.next.read(buffer, offset, length);
            this.length = len > 0 ? (this.length -= len) : -1;
            return len;
        }

        public int getAvailable() throws IOException {
            int available = this.next.available();
            if (this.length <= 0) {
                return 0;
            }
            if (this.length < available) {
                return this.length;
            }
            return available;
        }
    }
}

