/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.server.http.RequestAdapter;
import com.caucho.util.FreeList;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class ResponseAdapter
implements CauchoResponse {
    private static final FreeList _freeList = new FreeList(32);
    protected RequestAdapter request;
    protected HttpServletResponse response;
    protected VfsStream vfsStream;
    protected WriteStream writeStream;
    protected WriteStream stream;
    private QServletOutputStream os = new QServletOutputStream();
    private boolean hasError;

    protected ResponseAdapter() {
        this.os.setCloseChildOnClose(true);
    }

    protected ResponseAdapter(HttpServletResponse response) {
        this();
        this.init(response);
    }

    public static ResponseAdapter create(HttpServletResponse response) {
        ResponseAdapter adapter = (ResponseAdapter)_freeList.allocate();
        if (adapter == null) {
            adapter = new ResponseAdapter();
        }
        adapter.init(response);
        return adapter;
    }

    void setRequest(RequestAdapter request) {
        this.request = request;
    }

    public void init(HttpServletResponse response) {
        this.request = null;
        this.response = response;
        this.stream = null;
        this.hasError = false;
    }

    public void close() throws IOException {
        if (this.stream == this.writeStream && this.stream != null) {
            this.stream.setDisableClose(false);
            this.stream.close();
        }
        this.request = null;
        this.response = null;
        this.stream = null;
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    public WriteStream getStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.response instanceof CauchoResponse) {
            this.stream = ((CauchoResponse)this.response).getStream();
        } else {
            if (this.vfsStream == null) {
                this.vfsStream = new VfsStream();
            }
            this.vfsStream.init(null, (OutputStream)this.response.getOutputStream());
            if (this.writeStream == null) {
                this.writeStream = new WriteStream();
                this.writeStream.setReuseBuffer(true);
            }
            this.stream = this.writeStream;
            this.stream.init(this.vfsStream);
            String charset = this.getCharacterEncoding();
            this.stream.setEncoding(charset);
        }
        return this.stream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.os.init(this.getStream());
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getStream().getPrintWriter();
    }

    public void setStream(WriteStream stream) {
        this.stream = stream;
    }

    public void setContentLength(int i) {
        this.response.setContentLength(i);
    }

    public String encodeRedirectURL(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.response.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        return this.response.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.response.encodeUrl(string);
    }

    public void sendRedirect(String string) throws IOException {
        this.response.sendRedirect(string);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setContentType(String value) {
        this.response.setContentType(value);
        if (this.stream == null) {
            try {
                this.getStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.stream == this.writeStream && this.stream != null) {
            try {
                this.stream.setEncoding(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public void setStatus(int code, String message) {
        this.response.setStatus(code, message);
    }

    public void sendError(int code, String value) throws IOException {
        this.response.sendError(code, value);
    }

    public void sendError(int code) throws IOException {
        this.response.sendError(code);
    }

    public void setDateHeader(String name, long value) {
        this.response.setDateHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        this.response.setDateHeader(name, value);
    }

    public void addCookie(Cookie cookie) {
        if (this.request != null) {
            this.request.setHasCookie();
        }
        this.response.addCookie(cookie);
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
        this.response.flushBuffer();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void resetBuffer() {
        if (this.stream != null) {
            this.stream.clearWrite();
        }
        this.response.resetBuffer();
    }

    public void reset() {
        this.response.reset();
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
        if (this.stream == this.writeStream && this.stream != null) {
            try {
                this.stream.setLocale(this.response.getLocale());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public String getChain() {
        return null;
    }

    public String getHeader(String key) {
        return null;
    }

    public StreamImpl startChaining() {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public int getRemaining() {
        if (this.response instanceof CauchoResponse) {
            return ((CauchoResponse)this.response).getRemaining();
        }
        return 0;
    }

    public void setForbidForward(boolean forbid) {
    }

    public boolean getForbidForward() {
        return false;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void killCache() {
        if (this.response instanceof CauchoResponse) {
            ((CauchoResponse)this.response).killCache();
        }
    }

    public void setSessionId(String id) {
        if (this.response instanceof CauchoResponse) {
            ((CauchoResponse)this.response).setSessionId(id);
        }
    }

    public static void free(ResponseAdapter resAdapt) {
        resAdapt.free();
        _freeList.free(resAdapt);
    }

    protected void free() {
        this.request = null;
        this.response = null;
    }
}

