/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CacheInvocation;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class ResponseStream
extends StreamImpl {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static L10N L = new L10N("/com/caucho/server/http/messages");
    Response response;
    WriteStream next;
    WriteStream cache;
    boolean ignoreClientDisconnect;
    boolean chunkedEncoding;
    TempBuffer _head;
    TempBuffer _tail;
    int _chunkLength;
    int bufferSize;
    boolean disableAutoFlush;
    private int _contentLength;
    private int _outContentLength;
    boolean isDisconnected;
    boolean _allowFlush = true;
    boolean isClosed = false;
    boolean _isHead = false;
    private byte[] buffer = new byte[16];

    ResponseStream() {
    }

    void init(Response response, WriteStream next) {
        this.response = response;
        this.next = next;
        if (next == null) {
            throw new NullPointerException("missing next");
        }
    }

    void start() {
        this.cache = null;
        this.chunkedEncoding = false;
        this.response.headersWritten = false;
        this.bufferSize = 8192;
        if (this._head != null) {
            this._head.clear();
        }
        this._tail = this._head;
        this._chunkLength = 0;
        this._contentLength = 0;
        this._outContentLength = 0;
        this._allowFlush = true;
        this.disableAutoFlush = false;
        this.isClosed = false;
        this._isHead = false;
        this.isDisconnected = false;
    }

    void setIgnoreClientDisconnect(boolean ignoreDisconnect) {
        this.ignoreClientDisconnect = ignoreDisconnect;
    }

    TempBuffer startChaining() {
        TempBuffer ptr = this._head;
        this._head = null;
        this.start();
        return ptr;
    }

    void setCache(WriteStream cache) {
        this.cache = cache;
    }

    public boolean canWrite() {
        return true;
    }

    void setFlush(boolean flush) {
        this._allowFlush = flush;
    }

    void setDisableAutoFlush(boolean disable) {
        this.disableAutoFlush = disable;
    }

    void setHead() {
        this._isHead = true;
        this.bufferSize = 0;
    }

    boolean isHead() {
        return this._isHead;
    }

    int getContentLength() {
        return this._contentLength;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        int chunk = TempBuffer.SIZE;
        this.bufferSize = chunk * ((size + chunk - 1) / chunk);
        if (this.bufferSize <= 0) {
            this.bufferSize = 0;
        }
    }

    int getRemaining() {
        return this.bufferSize - this._chunkLength - TempBuffer.SIZE;
    }

    boolean isCommitted() {
        return this.response.headersWritten || this.isClosed;
    }

    void clear() {
        this.clearBuffer();
        if (this.response.headersWritten) {
            throw new IllegalStateException(L.l("can't clear response after writing headers"));
        }
    }

    void clearBuffer() {
        if (this._head != null) {
            TempBuffer.freeAll(this._head.getNext());
            this._head.clear();
        }
        this._tail = this._head;
        this._allowFlush = true;
        this._chunkLength = 0;
        this._contentLength = 0;
    }

    void clearHeaders() {
        this.response.headersWritten = false;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        this._contentLength += length;
        if (this._isHead || this.isClosed) {
            return;
        }
        if (this.bufferSize == 0) {
            this.writeHeaders(-1);
            this.writeChunk(buf, offset, length);
            return;
        }
        if (this._chunkLength == 0 && this._allowFlush && (length >= this.bufferSize || isEnd)) {
            this.writeHeaders(-1);
            if (this._allowFlush) {
                this.writeChunk(buf, offset, length);
                return;
            }
        }
        while (length > 0 && !this.isClosed) {
            if (this._head == null) {
                this._head = this._tail = TempBuffer.allocate();
            } else if (this._tail.getLength() >= TempBuffer.SIZE) {
                if (this._allowFlush && this._chunkLength + length > this.bufferSize - TempBuffer.SIZE) {
                    if (this.disableAutoFlush) {
                        throw new IOException("auto-flush is disabled.");
                    }
                    this.flushBuffer(false);
                } else {
                    TempBuffer tempBuf = TempBuffer.allocate();
                    this._tail.setNext(tempBuf);
                    this._tail = tempBuf;
                }
            }
            int sublen = this._tail.write(buf, offset, length);
            offset += sublen;
            length -= sublen;
            this._chunkLength += sublen;
        }
    }

    void finish(boolean flush) throws IOException {
        if (this.next == null || this.isClosed) {
            this.isClosed = true;
            return;
        }
        this._allowFlush = true;
        this.flushBuffer(true);
        if (this.isClosed || this.next == null) {
            this.isClosed = true;
            return;
        }
        this.isClosed = true;
        if (this.response.hasMsieHack) {
            this.writeChunk(Response.msiePadding, 0, Response.msiePadding.length);
        }
        try {
            if (this.chunkedEncoding) {
                if (this._outContentLength > 0) {
                    this.next.write(13);
                    this.next.write(10);
                }
                this.next.write(48);
                this.next.write(13);
                this.next.write(10);
                this.next.write(13);
                this.next.write(10);
            }
            if (!this.response.allowKeepalive()) {
                if (dbg.canWrite()) {
                    Connection conn;
                    String id = this.response.request instanceof Request ? ((conn = ((Request)this.response.request).conn) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                    dbg.log("[" + id + "] close stream");
                }
                this.next.close();
                this.next = null;
            } else if (flush) {
                this.next.flush();
            }
        }
        catch (ClientDisconnectException e) {
            if (this.ignoreClientDisconnect) {
                this.isDisconnected = true;
            }
            throw e;
        }
    }

    void flushBuffer(boolean isEnd) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (isEnd) {
            this.writeHeaders(this._chunkLength);
        } else {
            this.writeHeaders(-1);
        }
        if (!this._allowFlush) {
            return;
        }
        TempBuffer head = this._head;
        while (head != null) {
            TempBuffer ptr = head.getNext();
            head.setNext(null);
            this.writeChunk(head.getBuffer(), 0, head.getLength());
            if (ptr == null) break;
            TempBuffer.free(head);
            head = ptr;
        }
        if (head != null) {
            head.clear();
        }
        this._tail = this._head = head;
        this._chunkLength = 0;
    }

    private void writeHeaders(int length) throws IOException {
        if (this.response.headersWritten || this.isClosed) {
            return;
        }
        this.chunkedEncoding = this.response.writeHeaders(this.next, length);
    }

    private void writeChunk(byte[] buf, int offset, int length) throws IOException {
        try {
            if (length == 0) {
                return;
            }
            boolean isFirst = this._outContentLength == 0;
            long contentLengthHeader = this.response.getContentLengthHeader();
            if (0L < contentLengthHeader && contentLengthHeader < (long)(length + this._outContentLength)) {
                for (int i = (int)((long)offset + contentLengthHeader - (long)this._outContentLength); i < offset + length; ++i) {
                    byte ch = buf[i];
                    if (ch == 13 || ch == 10 || ch == 32 || ch == 9) continue;
                    AbstractRequest request = this.response.getRequest();
                    Application app = request.getApplication();
                    IllegalStateException exn = Character.isLetterOrDigit((char)ch) ? new IllegalStateException(L.l("{0}: tried to write content (char=`{1}') beyond content-length ({2}).", request.getRequestURL(), "" + (char)ch, "" + contentLengthHeader)) : new IllegalStateException(L.l("{0}: tried to write content (char={1}) beyond content-length ({2}).", request.getRequestURL(), "" + ch, "" + contentLengthHeader));
                    if (app != null) {
                        app.log(exn.getMessage(), exn);
                        break;
                    }
                    exn.printStackTrace();
                    break;
                }
                if ((length = (int)(contentLengthHeader - (long)this._outContentLength)) <= 0) {
                    return;
                }
            }
            if (!this.isDisconnected) {
                this._outContentLength += length;
            }
            if (this.cache != null) {
                AbstractRequest req = this.response.request;
                Application app = req.getApplication();
                if (app != null && app.getCacheMaxLength() < this._outContentLength) {
                    this.cache = null;
                    ((CacheInvocation)req.invocation).killCache();
                } else {
                    this.cache.write(buf, offset, length);
                }
            }
            if (this.next == null || this._isHead) {
                return;
            }
            if (dbg.canWrite()) {
                Connection conn;
                String id = this.response.request instanceof Request ? ((conn = ((Request)this.response.request).conn) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                dbg.log("[" + id + "] chunk: " + length);
            }
            if (!this.chunkedEncoding) {
                this.next.write(buf, offset, length);
            } else {
                int off = this.buffer.length;
                this.buffer[--off] = 10;
                this.buffer[--off] = 13;
                for (int count = length; count > 0; count >>= 4) {
                    int digit = count & 0xF;
                    this.buffer[--off] = digit <= 9 ? (byte)(48 + digit) : (byte)(97 + digit - 10);
                }
                if (!isFirst) {
                    this.buffer[--off] = 10;
                    this.buffer[--off] = 13;
                }
                this.next.write(this.buffer, off, this.buffer.length - off);
                this.next.write(buf, offset, length);
            }
        }
        catch (ClientDisconnectException e) {
            if (this.ignoreClientDisconnect) {
                this.isDisconnected = true;
            }
            throw e;
        }
    }

    public void flush() throws IOException {
        try {
            if (this._allowFlush && !this.isClosed) {
                this.flushBuffer(false);
                if (this.next != null) {
                    this.next.flush();
                }
            }
        }
        catch (ClientDisconnectException e) {
            if (this.ignoreClientDisconnect) {
                this.isDisconnected = true;
            }
            throw e;
        }
    }

    public void close() throws IOException {
    }
}

