/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoRequest;
import java.util.ArrayList;

class SecurityConstraint {
    boolean alwaysFail;
    ArrayList methods;
    String transport;
    ArrayList roles;
    ArrayList ports;

    SecurityConstraint(ArrayList roles, String transport) {
        this.roles = roles;
        this.transport = transport;
    }

    void addMethod(String method) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.add(method);
    }

    void setTransportGuarantee(String guarantee) {
        this.transport = guarantee;
    }

    void setFail(boolean alwaysFail) {
        this.alwaysFail = alwaysFail;
    }

    void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.add(role);
    }

    void addInterface(String serverName, int port) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        this.ports.add(new Port(serverName, port));
    }

    boolean isAuthorized(CauchoRequest req) {
        if (this.alwaysFail) {
            return false;
        }
        if (this.methods != null) {
            String test;
            int i;
            String method = req.getMethod();
            for (i = this.methods.size() - 1; i >= 0 && !(test = (String)this.methods.get(i)).equals(method); --i) {
            }
            if (i < 0) {
                return true;
            }
        }
        if (this.transport != null && (this.transport.equalsIgnoreCase("integral") || this.transport.equalsIgnoreCase("confidential")) && !req.isSecure()) {
            return false;
        }
        if (this.ports != null) {
            Port port;
            int i;
            for (i = this.ports.size() - 1; i >= 0 && (!(port = (Port)this.ports.get(i)).getServerName().equals(req.getServerName()) || port.getPort() != 0 && port.getPort() != req.getServerPort()); --i) {
            }
            if (i < 0) {
                return false;
            }
        }
        if (this.roles == null || this.roles.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.roles.size(); ++i) {
            String role = (String)this.roles.get(i);
            if (!req.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }

    boolean needsAuthentication(CauchoRequest req) {
        if (this.roles == null || this.roles.size() == 0) {
            return false;
        }
        if (this.methods == null) {
            return true;
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            String method = (String)this.methods.get(i);
            if (!req.getMethod().equals(method)) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        SecurityConstraint clone = new SecurityConstraint(this.roles, this.transport);
        clone.ports = this.ports;
        return clone;
    }

    static class Port {
        String name;
        int port;

        Port(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public String getServerName() {
            return this.name;
        }

        public int getPort() {
            return this.port;
        }
    }
}

