/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.http.admin.HostAdmin;
import com.caucho.http.admin.ServerAdmin;
import com.caucho.http.admin.TcpServerAdmin;
import com.caucho.http.distribution.BackingContext;
import com.caucho.http.distribution.BackingManager;
import com.caucho.http.distribution.DistributionServer;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.http.security.ForbidHost;
import com.caucho.server.Server;
import com.caucho.server.TcpServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.Configuration;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.server.http.UrlMap;
import com.caucho.server.http.VirtualHost;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.BeanUtil;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.CharSegment;
import com.caucho.util.ContextProperties;
import com.caucho.util.Cron;
import com.caucho.util.CronListener;
import com.caucho.util.LruCache;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.CachePath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.transaction.UserTransaction;

public class ServletServer
extends ClassLoaderContext
implements AlarmListener,
CronListener,
Server {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/server");
    static final int CACHE_DIR_COUNT = 32;
    static String[] _cacheDirNames;
    private volatile boolean _isClosed;
    private volatile boolean _isInitStarted;
    private volatile boolean _isInitComplete;
    private ArrayList _tcpServers = new ArrayList();
    private Path _config;
    private long _configLastModified;
    private Exception _configException;
    private RegistryNode _defaultHostRegistry;
    private Path _defaultHostRootPath;
    private Path _defaultHostDocPath;
    private RegistryNode _hostDefaultRegistry;
    private UrlMap _hostMap;
    private Hashtable _hosts;
    private ArrayList _hostList;
    private boolean _singleHost;
    private Hashtable _uniqueHosts;
    private VirtualHost _defaultHost;
    private int _urlLengthMax = 8192;
    private long _updateInterval;
    private long _lastUpdate;
    private ClassLoader _parent;
    private long _seed = 0L;
    private Random _random;
    private int _sessionCount;
    private String _host;
    private int _port;
    private LruCache _invocationCache;
    private CachePath _cache;
    private boolean _ignoreClientDisconnect;
    private long _startTime;
    private long _restartTime;
    private ForbidHost _forbiddenHosts;
    private boolean _isCaseInsensitive;
    private boolean _isCompileOnly;
    private TransactionManagerImpl _tm;
    private BackingManager _distributedObjectManager;
    private boolean _distSessionIsInit;
    private String _serverId;
    private String _srunHost;
    private int _srunPort;
    private int _srunIndex = -1;
    private int _srunCount = 0;
    private DistributionServer[] _distSrunArray;
    private long _srunTimeout = 1000L;
    private Alarm _alarm;
    private Cron _cron;
    private String _sessionPrefix = ";jsessionid=";
    private String _alternateSessionPrefix;
    private String _sessionCookie = "JSESSIONID";
    private ServerAdmin _serverAdmin;
    boolean _isTesting;
    long _bogusDate;
    private ServerVar _serverVar = new ServerVar();
    private static CharScanner _hostScanner;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$caucho$server$http$ServletServer$Funs;

    ServletServer(Path config, RegistryNode registry, Path pwd, String serverId) throws Exception {
        super(null);
        if (registry == null) {
            throw new ServletException("empty registry");
        }
        this._serverId = serverId;
        this.addRandom(serverId);
        this.addRandom(Alarm.getCurrentTime());
        this._startTime = Alarm.getCurrentTime();
        this.setRegistry(registry);
        ServletServer.verifyElements(registry, _serverElements);
        this._hostDefaultRegistry = ServletServer.selectDefault(registry, _hostDefaultElements);
        HashMap<String, Object> pathVariableMap = new HashMap<String, Object>();
        pathVariableMap.put("jndi:lookup", (class$com$caucho$server$http$ServletServer$Funs == null ? (class$com$caucho$server$http$ServletServer$Funs = ServletServer.class$("com.caucho.server.http.ServletServer$Funs")) : class$com$caucho$server$http$ServletServer$Funs).getMethod("jndiLookup", class$java$lang$String == null ? (class$java$lang$String = ServletServer.class$("java.lang.String")) : class$java$lang$String));
        pathVariableMap.put("server", this._serverVar);
        this.setPathVariableMap(pathVariableMap);
        this._config = config;
        if (config != null) {
            this._configLastModified = config.getLastModified();
        }
        if (pwd == null) {
            pwd = Vfs.lookup();
        }
        pathVariableMap.put("resin:pwd", pwd);
        pathVariableMap.put("resin-home", pwd);
        pathVariableMap.put("resinHome", pwd);
        Path rootPath = registry.getELPath("root-dir", pwd, this.getEnv());
        this.setRootPath(rootPath);
        this.setWebInfPath(rootPath);
        pathVariableMap.put("resin:pwd", rootPath);
        pathVariableMap.put("server-root", rootPath);
        pathVariableMap.put("serverRoot", rootPath);
        Path docPath = registry.getELPath("app-dir", rootPath, this.getEnv());
        docPath = registry.getELPath("doc-dir", docPath, this.getEnv());
        this.setDocPath(docPath);
        this.setPathVariableMap("app-dir", docPath);
        this.setPathVariableMap("server-doc", docPath);
        this._srunTimeout = registry.getELPeriod("srun-timeout", 30000L, this.getEnv());
        this._serverAdmin = new ServerAdmin(this);
        this._isCaseInsensitive = CauchoSystem.isCaseInsensitive();
        RegistryNode parent = registry.getParent();
        this._isCaseInsensitive = !parent.getBoolean("case-sensitive", !this._isCaseInsensitive);
        this._isCaseInsensitive = parent.getBoolean("case-insensitive", this._isCaseInsensitive);
        this._isCaseInsensitive = !registry.getBoolean("case-sensitive", !this._isCaseInsensitive);
        this._isCaseInsensitive = registry.getBoolean("case-insensitive", this._isCaseInsensitive);
    }

    public ServletServer getServer() {
        return this;
    }

    public ClassLoader getParentLoader() {
        return this._parent;
    }

    void addRandom(String random) {
        if (random == null) {
            return;
        }
        for (int i = 0; i < random.length(); ++i) {
            this.addRandom(random.charAt(i));
        }
    }

    void addRandom(long random) {
        this._seed += random;
        this._seed = this._seed * 25214903917L + 11L + (this._seed >>> 32) * 137L;
    }

    private long getServerSeed() {
        return this._seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRandomLong() {
        Random random = this._random;
        synchronized (random) {
            return this._random.nextLong();
        }
    }

    boolean getIgnoreClientDisconnect() {
        return this._ignoreClientDisconnect;
    }

    public String getSessionPrefix() {
        return this._sessionPrefix;
    }

    public String getAlternateSessionPrefix() {
        return this._alternateSessionPrefix;
    }

    public String getSessionCookie() {
        return this._sessionCookie;
    }

    ServerAdmin getServerAdmin() {
        return this._serverAdmin;
    }

    UserTransaction getUserTransaction() {
        if (this._tm != null) {
            return this._tm.getUserTransaction();
        }
        return null;
    }

    public TransactionManagerImpl getTransactionManager() {
        return this._tm;
    }

    void setSrun(String srunHost, int srunPort) {
        this._srunHost = srunHost;
        this._srunPort = srunPort;
    }

    void setPort(int port) {
        this._port = port;
    }

    int getPort() {
        return this._port;
    }

    void setHost(String host) {
        this._host = host;
    }

    String getHost() {
        return this._host;
    }

    public String getURL() {
        return "servlet-server:";
    }

    public Path getConfig() {
        return this._config;
    }

    public Exception getConfigException() {
        return this._configException;
    }

    Path getCache() {
        return this._cache;
    }

    public void addTcpServer(TcpServer server) {
        this._tcpServers.add(new TcpServerAdmin(server));
    }

    public ArrayList getTcpServerAdminList() {
        return this._tcpServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getHostAdminList() {
        ArrayList<HostAdmin> hosts = new ArrayList<HostAdmin>();
        ServletServer servletServer = this;
        synchronized (servletServer) {
            for (int i = 0; i < this._hostList.size(); ++i) {
                hosts.add(new HostAdmin((VirtualHost)this._hostList.get(i)));
            }
        }
        return hosts;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getRestartTime() {
        return this._restartTime;
    }

    public boolean isCompileOnly() {
        return this._isCompileOnly;
    }

    public void setCompileOnly(boolean compileOnly) {
        this._isCompileOnly = compileOnly;
    }

    public int getUrlLengthMax() {
        return this._urlLengthMax;
    }

    public VirtualHost getDefaultHost() {
        return this._defaultHost;
    }

    public boolean isCaseInsensitive() {
        return this._isCaseInsensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() throws Exception {
        if (this._isInitComplete || this._isInitStarted || this._isModified || this._isClosed) {
            return;
        }
        this._isInitStarted = true;
        try {
            ClassLoader oldLoader;
            this._parent = oldLoader = CauchoSystem.getContextClassLoader();
            try {
                if (this._parent == null) {
                    this._parent = this.getClass().getClassLoader();
                }
                this.initInternal();
            }
            finally {
                if (oldLoader != null) {
                    CauchoSystem.setContextClassLoader(oldLoader);
                }
            }
            if (this._random == null) {
                long seed = this.getServerSeed();
                seed = seed * 25214903917L + 11L + (seed >>> 32) * 17L;
                seed += Alarm.getCurrentTime() * 65521L;
                seed = seed * 25214903917L + 11L + (seed >>> 32) * 17L;
                this._random = new Random(seed);
                this._tm.setRandom(this._random);
            }
            this._alarm = new Alarm("servlet-timer", this, 1000L);
            this._cron = new Cron(this);
        }
        finally {
            this._isInitComplete = true;
            this._isInitStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInternal() throws Exception {
        this._isModified = false;
        this._configException = null;
        this._restartTime = Alarm.getCurrentTime();
        RegistryNode registry = this.getRegistry();
        Properties props = System.getProperties();
        if (props instanceof ContextProperties) {
            props = ((ContextProperties)props).getGlobalProperties();
            System.setProperties(props);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (!registry.getELBoolean("global-system-properties", false, this.getEnv())) {
                ContextProperties contextProps = new ContextProperties(props);
                System.setProperties(contextProps);
            }
            Configuration.configureSystemProperties(registry.getParent(), this.getEnv());
            this._updateInterval = registry.getELPeriod("class-update-interval", 2000L, this.getEnv());
            if (this._updateInterval < 0L) {
                this._updateInterval = 0x3FFFFFFFFFFFFFFFL;
            }
            this._urlLengthMax = registry.getELInt("url-length-max", 8192, this.getEnv());
            this._bogusDate = registry.getELInt("bogus-date", 0, this.getEnv());
            this._port = registry.getELInt("port", this._port, this.getEnv());
            this._ignoreClientDisconnect = registry.getELBoolean("ignore-client-disconnect", false, this.getEnv());
            this._alternateSessionPrefix = registry.getELString("alternate-session-url-prefix", null, this.getEnv());
            if (this._alternateSessionPrefix != null && !this._alternateSessionPrefix.startsWith("/")) {
                this._alternateSessionPrefix = "/" + this._alternateSessionPrefix;
            }
            if (this._alternateSessionPrefix != null && this._alternateSessionPrefix.indexOf(47) != this._alternateSessionPrefix.lastIndexOf(47)) {
                throw ServletServer.error(registry.lookup("alternate-session-url-prefix"), "alternate-session-url-prefix must only have a single slash.");
            }
            this._sessionPrefix = ";jsessionid=";
            this._sessionPrefix = registry.getELString("session-url-prefix", this._sessionPrefix, this.getEnv());
            this._sessionCookie = registry.getELString("session-cookie", "JSESSIONID", this.getEnv());
            this.configureSruns();
            this._hostMap = new UrlMap();
            this._hostMap.setBestFirst(true);
            RegistryNode cacheNode = registry.lookup("cache");
            int entries = 8192;
            if (cacheNode != null) {
                entries = cacheNode.getELInt("entries", entries, this.getEnv());
                int size = cacheNode.getELInt("size", 1024, this.getEnv());
                Path dir = this.getRootPath().lookup("cache");
                String pathName = cacheNode.getString("dir", null);
                if (pathName != null) {
                    dir = ServletServer.lookupPath(pathName, this.getEnv());
                }
                boolean enable = cacheNode.getELBoolean("enable", true, this.getEnv());
                if (size > 0 && entries > 0 && enable) {
                    this._cache = new CachePath(dir, entries, (long)size * 1024L);
                    this._cache.mkdirs();
                    for (int i = 0; i < 32; ++i) {
                        Path cacheDir = this._cache.lookup(_cacheDirNames[i]);
                        cacheDir.mkdirs();
                        try {
                            Iterator iter = cacheDir.iterator();
                            while (iter.hasNext()) {
                                String string = (String)iter.next();
                                try {
                                    Path path = cacheDir.lookup(string);
                                    path.remove();
                                }
                                catch (IOException e) {}
                            }
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (entries <= 256) {
                entries = 256;
            }
            this._invocationCache = new LruCache(entries);
            this._distributedObjectManager = new BackingManager();
            if (!this.getDocPath().equals(this.getRootPath())) {
                this.setAddWebInfClasses(true);
            }
            if (this._tm == null) {
                this._tm = new TransactionManagerImpl();
                this._tm.setRandomSeed(this._seed);
            }
            super.init();
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            this._forbiddenHosts = new ForbidHost();
            Iterator iter = this.getRegistry().select("forbid-host");
            while (iter.hasNext()) {
                RegistryNode node = (RegistryNode)iter.next();
                String className = node.getELString("class-name", null, this.getEnv());
                if (className != null) {
                    this._forbiddenHosts = (ForbidHost)BeanUtil.createBean(node, this.getEnv());
                    continue;
                }
                String ip = node.getValue();
                if (ip == null) continue;
                this._forbiddenHosts.addForbidIP(ip);
            }
            try {
                this.getJndiContext().createSubcontext("java:comp/env/caucho");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.getJndiContext().rebind("java:comp/env/caucho/forbid-host", (Object)this._forbiddenHosts);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.initHosts();
            if (this._alarm != null) {
                this._alarm.queue(1000L);
            }
        }
        finally {
            this._lastUpdate = Alarm.getCurrentTime();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void configureSruns() throws Exception {
        ArrayList srunList = new ArrayList();
        ArrayList<DistributionServer> distSrunList = new ArrayList<DistributionServer>();
        Iterator iter = this.getRegistry().iterator();
        boolean srunCount = false;
        while (iter.hasNext()) {
            int index;
            RegistryNode node = (RegistryNode)iter.next();
            if (!node.getName().equals("srun") && !node.getName().equals("srun-backup")) continue;
            DistributionServer server = new DistributionServer();
            server.setId(node.getValue());
            server.setHost(node.getELString("host", "localhost", this.getEnv()));
            server.setPort(node.getELInt("port", 6802, this.getEnv()));
            server.setBackup(node.getName().equals("srun-backup"));
            long liveTime = node.getParent().getELPeriod("live-time", 15000L, this.getEnv());
            liveTime = node.getELPeriod("live-time", liveTime, this.getEnv());
            server.setLiveTime(liveTime);
            long deadTime = node.getParent().getELPeriod("dead-time", 30000L, this.getEnv());
            deadTime = node.getELPeriod("dead-time", liveTime, this.getEnv());
            server.setDeadTime(deadTime);
            long srunTimeout = node.getELPeriod("timeout", this._srunTimeout, this.getEnv());
            server.setTimeout((int)srunTimeout);
            ++this._srunCount;
            try {
                index = node.getELInt("srun-index", index + 1, this.getEnv()) - 1;
                this._srunCount = index + 1;
            }
            catch (Exception e) {
                // empty catch block
            }
            server.setIndex(index);
            server.setGroupId(node.getELString("srun-group", "", this.getEnv()));
            server.init();
            distSrunList.add(server);
        }
        this._distSrunArray = new DistributionServer[distSrunList.size()];
        distSrunList.toArray(this._distSrunArray);
        for (int i = 0; i < this._distSrunArray.length; ++i) {
            if (this._distSrunArray[i].getGroup() != null) continue;
            this.configureDistSrunGroup(this._distSrunArray[i].getGroupId());
        }
    }

    private void configureDistSrunGroup(String groupId) {
        ArrayList<DistributionServer> groupList = new ArrayList<DistributionServer>();
        for (int i = 0; i < this._distSrunArray.length; ++i) {
            if (!this._distSrunArray[i].getGroupId().equals(groupId)) continue;
            groupList.add(this._distSrunArray[i]);
        }
        DistributionServer[] groupArray = new DistributionServer[groupList.size()];
        groupList.toArray(groupArray);
        int groupIndex = 0;
        for (int i = 0; i < this._distSrunArray.length; ++i) {
            if (!this._distSrunArray[i].getGroupId().equals(groupId)) continue;
            this._distSrunArray[i].setGroup(groupArray);
            this._distSrunArray[i].setGroupIndex(groupIndex++);
        }
    }

    private void initHosts() throws Exception {
        this._hosts = new Hashtable();
        this._hostList = new ArrayList();
        this._uniqueHosts = new Hashtable();
        this._singleHost = true;
        this._defaultHostRegistry = ServletServer.selectDefault(this.getRegistry(), _defaultHostElements);
        boolean hasDefault = false;
        Iterator iter = this.getRegistry().iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            if (!node.getName().equals("host")) continue;
            String regexp = node.getString("regexp", null);
            String rootDir = node.getString("root-dir", ".");
            String docDir = node.getString("app-dir", ".");
            docDir = node.getString("doc-dir", docDir);
            String id = node.getELString("host-name", node.getValue(), this.getEnv());
            if (regexp == null && (id == null || id.equals("") || id.equals("*"))) {
                this._defaultHostRegistry = node;
                ArrayList<String> vars = new ArrayList<String>();
                vars.add("");
                VirtualHost host = this.createHost(id, node, vars);
                this._defaultHostRootPath = host.getRootPath();
                this._defaultHostDocPath = host.getDocPath();
                id = "";
                hasDefault = true;
            } else {
                this._singleHost = false;
            }
            if (regexp != null) {
                this._hostMap.addRegexp(regexp, "i", rootDir, docDir, node);
                continue;
            }
            this.addHost(id, node, this._hostDefaultRegistry);
        }
        if (!hasDefault) {
            this._defaultHostRootPath = this.getRootPath();
            this._defaultHostDocPath = this.getRootPath();
            VirtualHost host = this.addHost("", this._defaultHostRegistry, this._hostDefaultRegistry);
            this._defaultHostRootPath = host.getRootPath();
            this._defaultHostDocPath = host.getDocPath();
        }
        this._defaultHost = (VirtualHost)this._hosts.get(new CharBuffer());
        for (int i = 0; i < this._hostList.size(); ++i) {
            VirtualHost host = (VirtualHost)this._hostList.get(i);
            host.init();
        }
    }

    private VirtualHost addHost(String id, RegistryNode node, RegistryNode defaultRegistry) throws Exception {
        ArrayList<String> vars = new ArrayList<String>();
        String canonicalName = null;
        CharBuffer name = new CharBuffer();
        StringCharCursor cursor = new StringCharCursor(id);
        ArrayList<CharBuffer> aliases = new ArrayList<CharBuffer>();
        while (true) {
            if (((CharCursor)cursor).current() == '\uffff') break;
            _hostScanner.skip(cursor);
            name.clear();
            char ch = _hostScanner.scan(cursor, name);
            String hostName = name.toString();
            if (hostName.indexOf("${") >= 0) {
                Expr expr = new ELParser(hostName).parse();
                hostName = expr.evalString(this.getEnv());
            }
            hostName = hostName.toLowerCase();
            CharBuffer cb = new CharBuffer();
            cb.append(hostName);
            cb.toString();
            aliases.add(cb);
            if (canonicalName == null) {
                canonicalName = hostName;
            }
            this._hostMap.addRegexp(1, "^" + hostName + "$", "i", null, null, node, false);
        }
        if (canonicalName == null) {
            canonicalName = "";
        }
        vars.add(canonicalName);
        VirtualHost host = this.createHost(canonicalName, node, vars);
        host.setName(canonicalName);
        if (canonicalName.equals("")) {
            this._hosts.put(new CharBuffer(), host);
            host.setName("");
            this._hostMap.addRegexp("^$", "i", null, null, node);
        }
        Host uniqueHost = new Host(node, host.getRootPath(), host.getDocPath());
        this._uniqueHosts.put(uniqueHost, host);
        if (!this._hostList.contains(host)) {
            this._hostList.add(host);
        }
        for (int i = 0; i < aliases.size(); ++i) {
            CharBuffer cb = (CharBuffer)aliases.get(i);
            this._hosts.put(cb, host);
        }
        HashMap hostVariableMap = (HashMap)this.getPathVariableMap().clone();
        host.initPaths(this, canonicalName, node, defaultRegistry, hostVariableMap);
        host.configureInit();
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ServletServer servletServer = this;
        synchronized (servletServer) {
            this._invocationCache.clear();
            CachePath cache = (CachePath)this.getCache();
            if (cache != null) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(String url) {
        byte[] bytes = null;
        try {
            bytes = url.getBytes("UTF-8");
        }
        catch (Exception e) {
            dbg.log(e);
            return;
        }
        ServletServer servletServer = this;
        synchronized (servletServer) {
            Iterator iter = this._invocationCache.keys();
            ArrayList<InvocationKey> removedKeys = new ArrayList<InvocationKey>();
            while (iter.hasNext()) {
                int i;
                InvocationKey key = (InvocationKey)iter.next();
                byte[] keyBytes = key.getUriBuffer();
                int len = key.getUriLength();
                if (len != bytes.length) continue;
                for (i = 0; i < len && bytes[i] == keyBytes[i]; ++i) {
                }
                if (i != len) continue;
                removedKeys.add(key);
            }
            for (int i = 0; i < removedKeys.size(); ++i) {
                InvocationKey key = (InvocationKey)removedKeys.get(i);
                this._invocationCache.remove(key);
            }
        }
    }

    Path getPwd() {
        return this.getRootPath();
    }

    Path getHome() {
        return this.getRootPath();
    }

    int getHttpPort() {
        if (this._port != 0) {
            return this._port;
        }
        for (int i = 0; i < this._tcpServers.size(); ++i) {
            TcpServer server = (TcpServer)this._tcpServers.get(i);
            if (!server.getProtocolName().equals("http")) continue;
            return server.getSocketPort();
        }
        return 0;
    }

    public boolean forbidConnection(QSocket socket) {
        Application app;
        if (this._forbiddenHosts == null) {
            return false;
        }
        long remote = socket.getRemoteIP();
        if (!this._forbiddenHosts.isForbidden(remote)) {
            return false;
        }
        VirtualHost host = this._defaultHost;
        String forbidAddress = this.ipToName(remote);
        if (host == null || (app = host.getDefaultApplication()) == null) {
            System.err.println("forbidding " + forbidAddress);
        } else {
            app.log("forbidding " + forbidAddress);
        }
        return true;
    }

    private String ipToName(long ip) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 24; i >= 0; i -= 8) {
            int value = (int)(ip >> i) & 0xFF;
            if (value < 10) {
                cb.append((char)(value + 48));
            } else if (value < 100) {
                cb.append((char)(value / 10 + 48));
                cb.append((char)(value % 10 + 48));
            } else {
                cb.append((char)(value / 100 + 48));
                cb.append((char)(value / 10 % 10 + 48));
                cb.append((char)(value % 10 + 48));
            }
            if (i == 0) continue;
            cb.append('.');
        }
        return cb.close();
    }

    public void serviceTop(InvocationKey key, Request request, Response response) throws Exception {
        Invocation invocation = this.getInvocation(key, true, true, true, true);
        invocation.service(request, response);
    }

    Invocation getInvocation(VirtualHost host, String key) throws Exception {
        ByteBuffer bb = new ByteBuffer();
        bb.addString(key, host.getURLCharacterEncoding());
        InvocationKey invocationKey = new InvocationKey();
        invocationKey.init(new CharBuffer(host.getHost()), host.getPort(), bb.getBuffer(), bb.getLength(), true);
        return this.getInvocation(invocationKey, false, false, false, false);
    }

    Invocation getDispatchInvocation(VirtualHost host, String key) throws Exception {
        ByteBuffer bb = new ByteBuffer();
        bb.addString(key, host.getURLCharacterEncoding());
        InvocationKey invocationKey = new InvocationKey();
        invocationKey.init(new CharBuffer(host.getHost()), host.getPort(), bb.getBuffer(), bb.getLength(), true);
        return this.getInvocation(invocationKey, true, false, false, true);
    }

    Invocation getLoginInvocation(VirtualHost host, String key) throws Exception {
        ByteBuffer bb = new ByteBuffer();
        bb.addString(key, host.getURLCharacterEncoding());
        InvocationKey invocationKey = new InvocationKey();
        invocationKey.init(new CharBuffer(host.getHost()), host.getPort(), bb.getBuffer(), bb.getLength(), false);
        return this.getInvocation(invocationKey, true, true, false, true);
    }

    public Application getApplication(CharSegment host, int port, ByteBuffer uri) throws Exception {
        InvocationKey key = new InvocationKey(host, port, uri.getBuffer(), uri.getLength(), true);
        return this.getInvocation(key, false, false, false, false).getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Invocation getInvocation(InvocationKey key, boolean isDispatch, boolean isTop, boolean checkModified, boolean decodeUrl) throws Exception {
        Invocation invocation;
        CharSegment hostKey;
        CharSegment hostName = hostKey = key.getHost();
        if (this._singleHost) {
            hostKey = null;
            key.setHost(null);
        }
        if (!((invocation = (Invocation)this._invocationCache.get(key)) == null || checkModified && invocation.isModified())) {
            if (isDispatch && invocation.getServletConfig() == null && invocation._application != null) {
                invocation._application.getServlet(invocation);
            }
            return invocation;
        }
        ServletServer servletServer = this;
        synchronized (servletServer) {
            if (checkModified && this.isModifiedFull()) {
                this.restart();
            }
        }
        VirtualHost host = this.getHost(hostName, key.getPort(), checkModified);
        if (checkModified && host.isWarDirModified()) {
            host.restartWarDir();
        }
        invocation = host.getInvocation(key.getUriBuffer(), key.getUriLength(), isDispatch, isTop, decodeUrl);
        ServletServer servletServer2 = this;
        synchronized (servletServer2) {
            Invocation oldInvocation = (Invocation)this._invocationCache.get(key);
            if (oldInvocation != null && !oldInvocation.isModified()) {
                return oldInvocation;
            }
            InvocationKey newKey = new InvocationKey(hostKey, key.getPort(), key.getUriBuffer(), key.getUriLength(), key.isSubrequest());
            this._invocationCache.put(newKey, invocation);
        }
        return invocation;
    }

    public VirtualHost getHostByName(String name) {
        if (name == null) {
            return null;
        }
        int port = 0;
        int p = name.indexOf(58);
        if (p > 0) {
            port = new Integer(name.substring(p + 1));
            name = name.substring(0, p);
        }
        CharBuffer cb = new CharBuffer();
        cb.append(name);
        try {
            return this.getHost((CharSegment)cb, port, true);
        }
        catch (Exception e) {
            dbg.log(e);
            return null;
        }
    }

    VirtualHost getHost(CharSegment hostName, int port, boolean checkModified) throws Exception {
        if (this._configException != null) {
            throw new ServletException((Throwable)this._configException);
        }
        if (hostName == null || this._singleHost) {
            if (!checkModified || !this._defaultHost.isModified()) {
                return this._defaultHost;
            }
            hostName = new CharBuffer("");
            port = 0;
        }
        Object deadHost = null;
        Object newHost = null;
        hostName.toLowerCase();
        CharBuffer shortHostName = new CharBuffer();
        shortHostName.append(hostName);
        int p = hostName.indexOf(':');
        if (p > 0) {
            shortHostName.setLength(p);
        }
        CharBuffer fullHostName = new CharBuffer();
        if (port > 0) {
            fullHostName.append(shortHostName);
            fullHostName.append(':');
            fullHostName.append(port);
        } else {
            fullHostName.append(hostName);
        }
        return this.getHost(fullHostName, shortHostName, checkModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualHost getHost(CharBuffer fullHostName, CharBuffer shortHostName, boolean checkModified) throws Exception {
        VirtualHost host;
        Object deadHost = null;
        Hashtable hashtable = this._hosts;
        synchronized (hashtable) {
            host = (VirtualHost)this._hosts.get(fullHostName);
            if (host != null) {
                if (!checkModified || !host.isModifiedAsParent()) {
                    return host;
                }
                this._hosts.remove(fullHostName);
            }
        }
        VirtualHost newHost = this.createHost(fullHostName.toString(), shortHostName.toString());
        Hashtable hashtable2 = this._hosts;
        synchronized (hashtable2) {
            host = (VirtualHost)this._hosts.get(fullHostName);
            if (host != null) {
                return host;
            }
            this._hosts.put(fullHostName, newHost);
        }
        newHost.init();
        return newHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualHost createHost(String fullHostName, String shortHostName) throws Exception {
        VirtualHost host;
        ArrayList vars = new ArrayList();
        RegistryNode node = this.mapHostNode(fullHostName, shortHostName, vars);
        VirtualHost newHost = this.createHost(fullHostName, node, vars);
        Host uniqueHost = new Host(node, newHost.getRootPath(), newHost.getDocPath());
        Hashtable hashtable = this._uniqueHosts;
        synchronized (hashtable) {
            host = (VirtualHost)this._uniqueHosts.get(uniqueHost);
            if (host != null) {
                if (!host.isModified()) {
                    return host;
                }
                this._uniqueHosts.remove(uniqueHost);
                if (host == this._defaultHost) {
                    this._defaultHost = null;
                }
            }
        }
        if (!newHost.getDocPath().isDirectory()) {
            VirtualHost defaultHost = this._defaultHost;
            if (defaultHost != null) {
                return defaultHost;
            }
            if (node == this._defaultHostRegistry && newHost.getRootPath().equals(this._defaultHostRootPath) && newHost.getDocPath().equals(this._defaultHostDocPath)) {
                throw new ServletException(L.l("The default host directory `{0}' does not exist.", newHost.getRootPath()));
            }
            return this.createHost("", "");
        }
        if (host != null) {
            try {
                host.close();
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
        hashtable = this._uniqueHosts;
        synchronized (hashtable) {
            host = (VirtualHost)this._uniqueHosts.get(uniqueHost);
            if (host != null) {
                return host;
            }
            this._uniqueHosts.put(uniqueHost, newHost);
            this._hostList.add(newHost);
            if (this._defaultHost == null && node == this._defaultHostRegistry && newHost.getRootPath().equals(this._defaultHostRootPath) && newHost.getDocPath().equals(this._defaultHostDocPath)) {
                this._defaultHost = newHost;
            }
        }
        newHost.configureInit();
        return newHost;
    }

    private RegistryNode mapHostNode(String fullHostName, String shortHostName, ArrayList vars) throws ServletException {
        RegistryNode node = (RegistryNode)this._hostMap.map(fullHostName, null, null, null, vars);
        if (node != null) {
            if (vars.size() == 0) {
                vars.add(fullHostName);
                return node;
            }
            String full = (String)vars.get(0);
            if (fullHostName.toString().equals(full)) {
                return node;
            }
        }
        vars.clear();
        node = (RegistryNode)this._hostMap.map(shortHostName, null, null, null, vars);
        if (node == null) {
            vars.add(shortHostName);
            return this._defaultHostRegistry;
        }
        if (vars.size() == 0) {
            vars.add(shortHostName);
            return node;
        }
        if (shortHostName.equals(vars.get(0))) {
            return node;
        }
        vars.clear();
        vars.add(shortHostName);
        return this._defaultHostRegistry;
    }

    private VirtualHost createHost(String hostName, RegistryNode node, ArrayList vars) throws Exception {
        HashMap pathVariableMap = this.getPathVariableMap();
        if (vars.size() == 0) {
            vars.add(hostName);
        }
        HashMap varMap = (HashMap)pathVariableMap.clone();
        varMap.put("regexp", vars);
        for (int i = 0; i < vars.size(); ++i) {
            varMap.put(String.valueOf(i), vars.get(i));
            varMap.put("host" + i, vars.get(i));
        }
        varMap.put("resin:pwd", this.getRootPath());
        VirtualHost host = new VirtualHost(this);
        host.setRegexp(vars);
        host.initPaths(this, hostName, node, this._hostDefaultRegistry, varMap);
        return host;
    }

    VirtualHost getHost(String canonicalName) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(canonicalName);
        VirtualHost host = (VirtualHost)this._hosts.get(cb);
        cb.close();
        if (host != null) {
            return host;
        }
        return this._defaultHost;
    }

    Application getDefaultApplication() {
        if (this._defaultHost != null) {
            return this._defaultHost.getDefaultApplication();
        }
        return null;
    }

    public ObjectBacking getDistributedObjectBacking(String contextId, String objectId) {
        return this._distributedObjectManager.getBacking(contextId, objectId);
    }

    BackingContext getDistributedObjectContext(String contextId) {
        return this._distributedObjectManager.getContext(contextId);
    }

    public void setDistributedObjectContext(String contextId, BackingContext context) {
        this._distributedObjectManager.setContext(contextId, context);
    }

    public void removeDistributedObjectContext(String contextId) {
        this._distributedObjectManager.removeContext(contextId);
    }

    public DistributionServer[] getDistributionServerGroup(String groupId) {
        for (int i = this._distSrunArray.length - 1; i >= 0; --i) {
            DistributionServer srun = this._distSrunArray[i];
            if ((groupId == null || !groupId.equals(srun.getGroupId())) && (groupId != null || srun.getGroupId() != null)) continue;
            return srun.getGroup();
        }
        return null;
    }

    public DistributionServer[] getDistributionServerList() {
        return this._distSrunArray;
    }

    private String mangleSessionName(String id) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(this.getSrunIndex());
        int len = id.length();
        for (int i = 0; i < len; ++i) {
            char ch = id.charAt(i);
            if (ch == ';' || ch == '/') {
                cb.append('_');
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setServerId(String id) {
        this._serverId = id;
    }

    public void setSrunIndex(int index) {
        this._srunIndex = index;
    }

    public int getSrunIndex() {
        return this._srunIndex;
    }

    public DistributionServer getDistributionServer() {
        return this.getDistributionServer(this._srunIndex);
    }

    public DistributionServer getDistributionServer(int srunIndex) {
        for (int i = this._distSrunArray.length - 1; i >= 0; --i) {
            DistributionServer server = this._distSrunArray[i];
            if (server.getIndex() != srunIndex) continue;
            return server;
        }
        return null;
    }

    public void handleAlarm(Alarm alarm) {
        if (this._isClosed) {
            return;
        }
        long now = Alarm.getCurrentTime();
        try {
            this.timeout(now);
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        if (!this._isClosed) {
            alarm.queue(1000L);
        }
    }

    public void handleCron(Cron alarm) {
        if (this._isClosed) {
            return;
        }
        long now = Alarm.getCurrentTime();
        try {
            this.cron(now);
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        alarm.queue();
    }

    public void timeout(long now) {
        if (this.isModifiedFull()) {
            if (this._isInitComplete) {
                new RestartThread(this).start();
            }
            return;
        }
        if (this._defaultHost != null) {
            this._defaultHost.timeout(now);
        }
        if (this._hostList != null) {
            for (int i = 0; i < this._hostList.size(); ++i) {
                VirtualHost host = (VirtualHost)this._hostList.get(i);
                host.timeout(now);
            }
        }
    }

    protected boolean isModified() {
        if (this._isClosed) {
            return true;
        }
        if (!this._isInitComplete) {
            return false;
        }
        if (this._isModified) {
            return true;
        }
        long now = Alarm.getCurrentTime();
        if (now < this._lastUpdate + this._updateInterval) {
            return false;
        }
        return this.isModifiedFull();
    }

    boolean isModifiedFull() {
        if (this._isClosed) {
            return true;
        }
        if (!this._isInitComplete) {
            return false;
        }
        if (this._isModified) {
            return true;
        }
        long now = Alarm.getCurrentTime();
        if (now < this._lastUpdate + this._updateInterval) {
            return false;
        }
        RegistryNode registry = this.getRegistry();
        if (registry != null && registry.isModified()) {
            if (_dbgLife.canWrite()) {
                _dbgLife.log("ServletServer registry modified.");
            }
            return true;
        }
        if (this._config != null && this._config.getLastModified() != this._configLastModified) {
            if (_dbgLife.canWrite()) {
                _dbgLife.log(this._config + " modified.");
            }
            return true;
        }
        if (this.getClassLoader() == null || this.getClassLoader().isModified()) {
            if (_dbgLife.canWrite()) {
                _dbgLife.log("ServletServer classloader modified");
            }
            return true;
        }
        if (super.isModified()) {
            this._isModified = true;
            return true;
        }
        this._lastUpdate = Alarm.getCurrentTime();
        return false;
    }

    public void adminRestart() {
        this._isModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restart() {
        ServletServer servletServer = this;
        synchronized (servletServer) {
            if (!this.isModifiedFull() || !this._isInitComplete || this._isInitStarted) {
                return;
            }
            this._isInitStarted = true;
            this._isInitComplete = false;
            this._configException = null;
        }
        try {
            if (this._config != null) {
                Registry root = Registry.parse(this._config);
                Registry.setDefault(root);
                RegistryNode newRegistry = Registry.lookup("/caucho.com/http-server");
                if (newRegistry != null) {
                    this.setRegistry(newRegistry);
                }
                this._configLastModified = this._config.getLastModified();
            }
            this.close(false);
            this.initInternal();
        }
        catch (Exception e) {
            this._configException = e;
            if (dbg.canWrite()) {
                dbg.log(e);
            } else {
                e.printStackTrace();
            }
            return;
        }
        finally {
            this._isInitComplete = true;
            this._isInitStarted = false;
        }
    }

    public void cron(long now) {
        if (this.isModifiedFull() && !this._isClosed) {
            this.restart();
            return;
        }
        if (this._defaultHost != null && !this._hosts.contains(this._defaultHost)) {
            this._defaultHost.cron(now);
        }
        if (this._hosts != null) {
            Enumeration enumeration = this._hosts.elements();
            while (enumeration.hasMoreElements()) {
                VirtualHost host = (VirtualHost)enumeration.nextElement();
                host.cron(now);
            }
        }
    }

    public int getSlowThreads() {
        return 0;
    }

    public void killCache() {
        RegistryNode cacheNode = this.getRegistry().lookup("cache");
        int entries = 4096;
        if (cacheNode != null) {
            try {
                entries = cacheNode.getELInt("entries", 1024, this.getEnv());
            }
            catch (RegistryException e) {
                dbg.log(e);
            }
        }
        LruCache oldCache = this._invocationCache;
        LruCache cache = entries > 0 ? new LruCache(entries) : new LruCache(4096);
        this._invocationCache = cache;
        if (oldCache != null) {
            oldCache.clear();
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean shutdown) {
        ServletServer servletServer = this;
        synchronized (servletServer) {
            if (this._isClosed) {
                return;
            }
            this._isModified = true;
            this._isClosed = shutdown;
        }
        if (this._invocationCache != null) {
            this._invocationCache.clear();
        }
        for (int i = 0; this._hostList != null && i < this._hostList.size(); ++i) {
            VirtualHost host = (VirtualHost)this._hostList.get(i);
            host.close();
        }
        if (this._defaultHost != null) {
            this._defaultHost.close();
        }
        Thread currentThread = Thread.currentThread();
        Object oldLoader = null;
        if (shutdown && this._alarm != null) {
            this._alarm.close();
        }
        if (shutdown && this._cron != null) {
            this._cron.close();
        }
        for (int i = 0; this._distSrunArray != null && i < this._distSrunArray.length; ++i) {
            this._distSrunArray[i].close();
        }
        this._defaultHost = null;
        this._hosts = null;
        this._hostList = null;
        if (this._cache != null) {
            this._cache.clear();
        }
        this._cache = null;
        super.close();
    }

    void setDate(long bogusDate) {
        this._bogusDate = bogusDate;
        this._isTesting = true;
        if (this._defaultHost != null) {
            this._defaultHost.setDate(bogusDate);
        }
    }

    public boolean isTesting() {
        return this._isTesting;
    }

    public String toString() {
        return "ServletServer[id=" + this.getServerId() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _hostScanner = new CharScanner(" \t,");
        _cacheDirNames = new String[32];
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < _cacheDirNames.length; ++i) {
            cb.clear();
            int value = i;
            while (value >= 0) {
                int d = value % 36;
                if (d < 10) {
                    cb.append(d);
                } else {
                    cb.append((char)(97 + d - 10));
                }
                if ((value /= 36) != 0) continue;
                break;
            }
            ServletServer._cacheDirNames[i] = cb.toString();
        }
    }

    public static class Funs {
        public static Object jndiLookup(String name) {
            Object value;
            try {
                value = new InitialContext().lookup(name);
                if (value != null) {
                    return value;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (!name.startsWith("java:comp/env")) {
                try {
                    value = new InitialContext().lookup("java:comp/env/" + name);
                    if (value != null) {
                        return value;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class RestartThread
    extends Thread {
        ServletServer _server;

        RestartThread(ServletServer server) {
            this._server = server;
        }

        public void run() {
            this._server.restart();
        }
    }

    static class Host {
        RegistryNode _registry;
        Path _rootPath;
        Path _docPath;

        Host(RegistryNode registry, Path rootPath, Path docPath) {
            this._registry = registry;
            this._rootPath = rootPath;
            this._docPath = docPath;
        }

        public int hashCode() {
            return this._registry.hashCode() * 65521 + this._rootPath.hashCode() * 37 + this._docPath.hashCode();
        }

        public boolean equals(Object b) {
            if (!(b instanceof Host)) {
                return false;
            }
            Host host = (Host)b;
            return host._registry == this._registry && host._rootPath.equals(this._rootPath) && host._docPath.equals(this._docPath);
        }
    }

    public class ServerVar {
        public String getName() {
            return ServletServer.this.getServerId();
        }

        public Path getRootDir() {
            return ServletServer.this.getRootPath();
        }

        public Path getDocDir() {
            return ServletServer.this.getDocPath();
        }

        public String toString() {
            return ServletServer.this.toString();
        }
    }
}

