/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.RequestFactory;
import com.caucho.server.StreamConnection;
import com.caucho.server.TcpServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.SSLFactory;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.QServerSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class SingleRequestServer {
    static L10N L = new L10N("com/caucho/server/http/messages");
    static final String COPYRIGHT = "Copyright (c) 1998-2002 Caucho Technology.  All rights reserved.";
    static final String HTTP_FACTORY = "com.caucho.server.http.HttpServer";
    static final String SRUN_FACTORY = "com.caucho.server.http.RunnerServer";
    static WriteStream dbg;
    private String resinConf = CauchoSystem.getResinConfig();
    private boolean isHttp;
    private int httpPort = 0;
    private int srunPort = 0;
    private boolean hasPort = false;
    private String standalone = null;
    private WriteStream stdout = null;
    private WriteStream stderr = null;
    private String serverId = null;
    private InputStream waitIn;
    private boolean deadwait;
    private ArrayList tcpServers = new ArrayList();
    private ServletServer servletServer;

    public SingleRequestServer(String[] argv) throws Exception {
        this.parseCommandLine(argv);
        Path conf = CauchoSystem.getResinHome().lookupNative(this.resinConf);
        ReadStream is = conf.openRead();
        Registry.setDefault(Registry.parse(is));
        is.close();
        dbg = LogStream.open("/caucho.com/httpd");
        this.setSystemProperties(Registry.lookup("/caucho.com"));
        this.addSecurityProviders(Registry.lookup("/caucho.com"));
        RegistryNode node = Registry.lookup("/caucho.com/http-server");
        this.servletServer = new ServletServer(conf, node, CauchoSystem.getResinHome(), "standalone");
        SingleRequestServer.doStandalone(this.servletServer, this.standalone);
    }

    private void parseCommandLine(String[] argv) throws IOException {
        int len = argv.length;
        int i = 0;
        while (i < len) {
            if (i + 1 < len && argv[i].equals("-conf")) {
                this.resinConf = argv[i + 1];
                i += 2;
                continue;
            }
            if (argv[i].equals("-version")) {
                System.out.println(Version.VERSION);
                System.exit(0);
                continue;
            }
            if (i + 1 < len && argv[i].equals("-e")) {
                this.standalone = argv[i + 1];
                i += 2;
                continue;
            }
            this.standalone = argv[i];
            break;
        }
    }

    void addServer(ArrayList tcpServers, RegistryNode node, String serverId, String factoryName) throws Exception {
        String name = node.getName();
        name = node.getString("name", name);
        String serverName = node.getValue();
        if (serverId != null && !serverId.equals(serverName)) {
            return;
        }
        if ((factoryName = node.getString("request-factory", factoryName)) == null) {
            throw Application.error(node, L.l("`{0}' expects `{1}'", (Object)name, "request-factory"));
        }
        Class cl = CauchoSystem.loadClass(factoryName, false, null);
        RequestFactory requestFactory = (RequestFactory)cl.newInstance();
        RegistryNode parentNode = node.getParent();
        int threadMax = parentNode.getInt("thread-max", 20);
        threadMax = node.getInt("thread-max", threadMax);
        int threadKeepalive = parentNode.getInt("thread-keepalive", -1);
        if ((threadKeepalive = node.getInt("thread-keepalive", threadKeepalive)) + 1 > threadMax) {
            throw Application.error(node, "thread-max must exceed thread-keepalive");
        }
        int requestTimeout = parentNode.getInt("request-timeout", -1);
        requestTimeout = node.getInt("request-timeout", requestTimeout);
        int listen = parentNode.getInt("listen", 5);
        listen = node.getInt("listen", listen);
        String host = node.getString("host", null);
        int port = node.getInt("port", 0);
        String virtualHost = node.getString("virtual-host", null);
        if (port <= 0) {
            throw Application.error(node, L.l("`{0}' expects `{1}'", (Object)name, "port"));
        }
        boolean ssl = node.getBoolean("ssl", false);
        ServerSocket serverSocket = ssl ? SSLFactory.getServerSocket(name, node, host, port, listen) : SingleRequestServer.getServerSocket(name, node, host, port, listen);
        QServerSocketWrapper qServerSocket = new QServerSocketWrapper(serverSocket);
        TcpServer tcpServer = new TcpServer(requestFactory, qServerSocket);
        tcpServer.setVirtualHost(virtualHost);
        tcpServer.setConnectionMax(threadMax);
        tcpServer.setKeepaliveMax(threadKeepalive);
        tcpServers.add(tcpServer);
    }

    private void setSystemProperties(RegistryNode node) {
        Properties props = System.getProperties();
        Iterator iter = node.select("system-property");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            Iterator subiter = subnode.iterator();
            while (subiter.hasNext()) {
                RegistryNode prop = (RegistryNode)subiter.next();
                String key = prop.getName();
                String value = prop.getValue();
                if (dbg.canWrite()) {
                    dbg.log("-D" + key + "=" + value);
                }
                props.put(key, value);
            }
        }
        System.setProperties(props);
    }

    private void addSecurityProviders(RegistryNode node) throws Exception {
        Iterator iter = node.select("security-provider");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            Class cl = CauchoSystem.loadClass(subnode.getValue(), false, null);
            Security.addProvider((Provider)cl.newInstance());
        }
    }

    private static ServerSocket getServerSocket(String name, RegistryNode node, String host, int port, int listen) throws Exception {
        ServerSocket serverSocket = null;
        try {
            if (host == null) {
                serverSocket = new ServerSocket(port, listen);
                System.out.println(name + " listening to *:" + port);
            } else {
                InetAddress hostAddr = InetAddress.getByName(host);
                serverSocket = new ServerSocket(port, listen, hostAddr);
                System.out.println(name + " listening to " + host + ":" + port);
            }
        }
        catch (BindException e) {
            System.out.println(name + " can't bind to port " + port + ". Check for conflicting servers.");
            throw e;
        }
        return serverSocket;
    }

    /*
     * Unable to fully structure code
     */
    private void execute() throws Exception {
        if (this.waitIn != null) {
            try {
                while (this.waitIn.read() >= 0) {
                }
            }
            catch (Exception e) {
                if (!SingleRequestServer.dbg.canWrite()) ** GOTO lbl35
                SingleRequestServer.dbg.log(e);
            }
        } else if (this.deadwait) {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (Exception e) {
                if (!SingleRequestServer.dbg.canWrite()) ** GOTO lbl35
                SingleRequestServer.dbg.log(e);
            }
        } else {
            block12: while (true) {
                try {
                    block13: while (true) {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                        i = 0;
                        while (true) {
                            if (i >= this.tcpServers.size()) continue block13;
                            server = (TcpServer)this.tcpServers.get(i);
                            if (server.isDead()) break block12;
                            ++i;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
lbl35:
        // 7 sources

        System.err.println(SingleRequestServer.L.l("closing server"));
        for (i = 0; i < this.tcpServers.size(); ++i) {
            server = (TcpServer)this.tcpServers.get(i);
            try {
                server.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.servletServer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SingleRequestServer.dbg.canWrite()) {
            SingleRequestServer.dbg.log("httpd shutdown");
        }
        System.exit(0);
    }

    private static void doStandalone(ServletServer server, String url) throws Exception {
        String line;
        HttpRequest request = new HttpRequest(server);
        ReadStream rs = Vfs.openString("GET " + url + " HTTP/1.0");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WriteStream ws = Vfs.openWrite(os);
        StreamConnection conn = new StreamConnection(rs, ws);
        conn.setLocalAddress(InetAddress.getByName("127.0.0.1"));
        conn.setRemoteAddress(InetAddress.getByName("127.0.0.1"));
        conn.setLocalPort(8080);
        conn.setRemotePort(32732);
        rs.setDisableClose(true);
        ws.setDisableClose(true);
        request.handleConnection(conn);
        server.close();
        rs.setDisableClose(false);
        ws.setDisableClose(false);
        ws.close();
        rs.close();
        rs = Vfs.openString(os.toString());
        String status = rs.readLine();
        while ((line = rs.readLine()) != null && line.length() > 0) {
        }
        rs.writeToStream(System.out);
        if (status.startsWith("HTTP/1.0 200")) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println(L.l("usage: SingleRequestServer <url>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        try {
            SingleRequestServer server = new SingleRequestServer(argv);
            server.execute();
        }
        catch (Throwable e) {
            try {
                e.printStackTrace(System.err);
            }
            finally {
                System.exit(66);
            }
        }
    }
}

