/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import javax.servlet.ServletException;

class UrlMap {
    private ArrayList regexps = new ArrayList();
    private boolean bestShort;
    private boolean bestFirst;

    UrlMap() {
    }

    UrlMap(boolean bestShort) {
        this.bestShort = bestShort;
    }

    void setBestShort(boolean bestShort) {
        this.bestShort = bestShort;
    }

    void setBestFirst(boolean bestFirst) {
        this.bestFirst = bestFirst;
    }

    int size() {
        return this.regexps.size();
    }

    void addMap(String pattern, String flags, String pathReplace, String replace2, Object value) throws IllegalRegexpException {
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            this.addRegexp(-1, "^.*$", flags, pathReplace, replace2, value, true);
            return;
        }
        if (pattern.equals("/*")) {
            this.addRegexp(0, "", flags, pathReplace, replace2, value, true);
            return;
        }
        int length = pattern.length();
        boolean isExact = true;
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        int prefixLength = -1;
        boolean isShort = false;
        CharBuffer cb = new CharBuffer();
        cb.append("^");
        for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*' && i + 1 == length && i > 0) {
                isExact = false;
                if (pattern.charAt(i - 1) == '/') {
                    cb.setLength(cb.length() - 1);
                    if (prefixLength < 0) {
                        prefixLength = i - 1;
                    }
                } else if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (prefixLength != 0) continue;
                prefixLength = 1;
                continue;
            }
            if (ch == '*') {
                isExact = false;
                cb.append(".*");
                if (prefixLength < 0) {
                    prefixLength = i;
                }
                if (i != 0) continue;
                isShort = true;
                continue;
            }
            if (ch == '.' || ch == '[' || ch == '^' || ch == '$' || ch == '{' || ch == '}' || ch == '|' || ch == '(' || ch == ')' || ch == '?') {
                cb.append('\\');
                cb.append(ch);
                continue;
            }
            cb.append(ch);
        }
        if (isExact) {
            cb.append('$');
        } else {
            cb.append("(?=/)|" + cb.toString() + "$");
        }
        if (prefixLength < 0) {
            prefixLength = pattern.length();
        } else if (prefixLength < pattern.length() && pattern.charAt(prefixLength) == '/') {
            --prefixLength;
        }
        if (cb.length() > 0 && cb.charAt(0) == '/') {
            cb.insert(0, '^');
        }
        this.addRegexp(prefixLength, cb.close(), flags, pathReplace, replace2, value, isShort);
    }

    void addStrictMap(String pattern, String flags, String pathReplace, String replace2, Object value) throws IllegalRegexpException, ServletException {
        if (pattern.length() == 0 || pattern.length() == 1 && pattern.charAt(0) == '/') {
            this.addRegexp(-1, "^.*$", flags, pathReplace, replace2, value, true);
            return;
        }
        int length = pattern.length();
        boolean isExact = true;
        if (pattern.charAt(0) != '/' && pattern.charAt(0) != '*') {
            pattern = "/" + pattern;
            ++length;
        }
        if (pattern.indexOf(42) < pattern.lastIndexOf(42)) {
            throw new ServletException("at most one '*' is allowed");
        }
        int prefixLength = -1;
        boolean isShort = false;
        CharBuffer cb = new CharBuffer();
        cb.append('^');
        block4: for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '*': {
                    if (i > 0 && i + 1 == length && pattern.charAt(i - 1) == '/') {
                        cb.append(".*");
                        continue block4;
                    }
                    if (i == 0 && length > 1 && pattern.charAt(1) == '.' && pattern.lastIndexOf(47) < 0) {
                        cb.append(".*");
                        continue block4;
                    }
                    throw new ServletException("illegal url-pattern `" + pattern + "'");
                }
                case '$': 
                case '(': 
                case '.': 
                case '?': 
                case '[': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    cb.append('\\');
                    cb.append(ch);
                    continue block4;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        cb.append("$");
        this.addRegexp(prefixLength, cb.close(), flags, pathReplace, replace2, value, isShort);
    }

    void addMap(String pattern, Object value) throws IllegalRegexpException {
        this.addMap(pattern, null, "", "", value);
    }

    void addRegexp(String regexp, String flags, String pathReplace, String replace2, Object value) throws IllegalRegexpException {
        this.addRegexp(0, regexp, flags, pathReplace, replace2, value, false);
    }

    void addRegexp(int prefixLength, String regexp, String flags, String pathReplace, String replace2, Object value, boolean isShort) throws IllegalRegexpException {
        for (int i = 0; i < this.regexps.size(); ++i) {
            RegexpEntry re = (RegexpEntry)this.regexps.get(i);
            if (!re.getPattern().equals(regexp)) continue;
            this.regexps.remove(i);
            break;
        }
        RegexpEntry entry = new RegexpEntry(prefixLength, regexp, flags, pathReplace, replace2, value);
        if (isShort) {
            entry.setShortMatch();
        }
        this.regexps.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object map(String uri, CharBuffer match, CharBuffer pathReplace, CharBuffer replace2, ArrayList replaceVars) {
        Object best = null;
        int bestPrefixLength = -2;
        int bestMinLength = -2;
        int bestMaxLength = Integer.MAX_VALUE;
        for (int i = 0; i < this.regexps.size(); ++i) {
            RegexpEntry entry;
            RegexpEntry regexpEntry = entry = (RegexpEntry)this.regexps.get(i);
            synchronized (regexpEntry) {
                if (entry.prefixLength < bestPrefixLength) {
                    continue;
                }
                if (entry.regexp.exec(uri, 0) < 0) {
                    continue;
                }
                int begin = entry.regexp.getBegin(0);
                int end = entry.regexp.getEnd(0);
                int length = end - begin;
                boolean bestShort = entry.isShortMatch();
                if (bestPrefixLength < entry.prefixLength || (bestMinLength < length || !this.bestFirst && length == bestMinLength) && (!bestShort || length <= bestMaxLength)) {
                    if (match != null) {
                        match.clear();
                        match.append(uri, begin, length);
                    }
                    if (pathReplace != null) {
                        pathReplace.clear();
                        pathReplace.append(uri, 0, begin);
                        entry.regexp.replace(uri, entry.pathReplace, pathReplace);
                        pathReplace.append(uri, end, uri.length() - end);
                    }
                    if (replace2 != null) {
                        replace2.clear();
                        entry.regexp.replace(uri, entry.replace2, replace2);
                    }
                    if (replaceVars != null) {
                        replaceVars.clear();
                        for (int j = 0; j < entry.regexp.length(); ++j) {
                            int varEnd;
                            int varBegin = entry.regexp.getBegin(j);
                            if (varBegin < (varEnd = entry.regexp.getEnd(j)) && varBegin >= 0) {
                                replaceVars.add(uri.substring(varBegin, varEnd));
                                continue;
                            }
                            replaceVars.add("");
                        }
                    }
                    best = entry.value;
                    bestPrefixLength = entry.prefixLength;
                    bestMaxLength = length;
                    if (!entry.isShortMatch()) {
                        bestMinLength = length;
                    }
                    if (entry.prefixLength > bestMinLength) {
                        bestMinLength = entry.prefixLength;
                    }
                }
                continue;
            }
        }
        return best;
    }

    static class RegexpEntry {
        String pattern;
        String flags;
        Regexp regexp;
        Object value;
        String pathReplace;
        String replace2;
        int prefixLength;
        boolean shortMatch;

        RegexpEntry(int prefixLength, String pattern, String flags, String pathReplace, String replace2, Object value) throws IllegalRegexpException {
            this.prefixLength = prefixLength;
            this.pattern = pattern;
            if (flags == null) {
                flags = CauchoSystem.isWindows() ? "i" : "";
            }
            this.flags = flags;
            this.regexp = new Regexp(pattern, flags);
            this.value = value;
            if (pathReplace == null) {
                pathReplace = "";
            }
            if (replace2 == null) {
                replace2 = "";
            }
            this.pathReplace = pathReplace;
            this.replace2 = replace2;
        }

        void setShortMatch() {
            this.shortMatch = true;
        }

        boolean isShortMatch() {
            return this.shortMatch;
        }

        String getPattern() {
            return this.pattern;
        }
    }
}

