/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.StatementOverflowException;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class PoolItem
implements ConnectionEventListener,
XAResource {
    private static L10N L = new L10N(class$com$caucho$sql$PoolItem == null ? (class$com$caucho$sql$PoolItem = PoolItem.class$("com.caucho.sql.PoolItem")) : class$com$caucho$sql$PoolItem);
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    private static WriteStream dbgNew = LogStream.open("/caucho.com/sql/pool/new");
    private int _id;
    private DBPool _pool;
    private PooledConnection _pconn;
    private Connection _uconn;
    private XAResource _xaResource;
    private int _defaultTransactionTimeout = 0;
    private int _transactionTimeout = 0;
    private volatile boolean _isActive;
    private volatile Xid _xid;
    private PoolItem _xaDelegate;
    private PoolItem _xaDelegateNext;
    private boolean _hasConnectionError;
    private long _poolStartTime;
    private long _poolEventTime;
    private int _endFlags = -1;
    static /* synthetic */ Class class$com$caucho$sql$PoolItem;

    PoolItem(DBPool pool, PooledConnection conn) {
        this._id = pool.createPoolId();
        this._pool = pool;
        this._pconn = conn;
        if (conn instanceof XAConnection) {
            try {
                this._xaResource = ((XAConnection)conn).getXAResource();
                this._defaultTransactionTimeout = this._xaResource.getTransactionTimeout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._xaDelegate = this;
        this._pconn.addConnectionEventListener(this);
        this._poolStartTime = Alarm.getCurrentTime();
        this._poolEventTime = Alarm.getCurrentTime();
    }

    int getId() {
        return this._id;
    }

    long getPoolEventTime() {
        return this._poolEventTime;
    }

    void setPoolEventTime(long now) {
        this._poolEventTime = now;
    }

    long getPoolStartTime() {
        return this._poolStartTime;
    }

    boolean isActive() {
        return this._isActive || this._xid != null;
    }

    boolean isDead() {
        return this._pconn == null;
    }

    boolean isValid() {
        return !this._hasConnectionError;
    }

    Xid getXid() {
        return this._xid;
    }

    PooledConnection getPooledConnection() {
        return this._pconn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocate() {
        PoolItem poolItem = this;
        synchronized (poolItem) {
            if (this._pconn == null) {
                return false;
            }
            if (this._isActive) {
                return false;
            }
            if (this._xid != null) {
                return false;
            }
            if (this._hasConnectionError) {
                return false;
            }
            this._isActive = true;
        }
        this._poolEventTime = Alarm.getCurrentTime();
        if (dbg.canWrite()) {
            dbg.log("allocating pool item: " + this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocateXA(Xid xid) {
        PoolItem poolItem = this;
        synchronized (poolItem) {
            if (this._pconn == null) {
                return false;
            }
            if (this._xid != xid) {
                return false;
            }
            if (this._isActive) {
                return false;
            }
            this._isActive = true;
        }
        this._poolEventTime = Alarm.getCurrentTime();
        this._endFlags = -1;
        if (dbg.canWrite()) {
            dbg.log("allocating pool item: " + this + " xid=" + xid);
        }
        return true;
    }

    Connection getConnection() throws SQLException {
        if (this._pconn == null) {
            throw new SQLException(L.l("Can't get connection from closed PooledConnection."));
        }
        if (this._uconn == null) {
            this._uconn = this._pconn.getConnection();
        }
        return this._uconn;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this._hasConnectionError) {
            return;
        }
        this._hasConnectionError = true;
        if (event != null) {
            SQLException exn = event.getSQLException();
            if (exn instanceof StatementOverflowException) {
                if (dbgNew.canWrite()) {
                    dbgNew.log("connection not recycled because of statement overflow " + this);
                }
            } else if (dbgNew.canWrite()) {
                dbgNew.log("connection-error " + exn + " " + this);
            }
        } else {
            dbgNew.log("internal connection error");
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        this._uconn = null;
        if (this._hasConnectionError) {
            try {
                this.close();
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
        this._poolEventTime = Alarm.getCurrentTime();
        this._isActive = false;
        if (this._pconn != null && dbg.canWrite()) {
            dbg.log("returning connection to pool: " + this);
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (!(resource instanceof PoolItem)) {
            return false;
        }
        if (this._xaResource == null || this._pconn == null) {
            return false;
        }
        PoolItem poolItem = (PoolItem)resource;
        return this._xaResource.isSameRM(poolItem._xaResource);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0x200000 && this._xid == null) {
            PoolItem delegate = this._pool.getDelegatePoolItem(xid);
            this._xaDelegate = delegate._xaDelegate;
            this._xaDelegateNext = this._xaDelegate._xaDelegateNext;
            this._xaDelegate._xaDelegateNext = this;
        }
        if (flags != 0x8000000) {
            this._xid = xid;
            this._xaResource.start(xid, flags);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds == this._transactionTimeout) {
            return true;
        }
        XAResource xaResource = this._xaDelegate._xaResource;
        this._transactionTimeout = seconds;
        if (seconds == 0) {
            return xaResource.setTransactionTimeout(this._defaultTransactionTimeout);
        }
        return xaResource.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this._xaDelegate._xaResource.getTransactionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.forget(xid);
            return;
        }
        try {
            this._xaResource.forget(xid);
        }
        finally {
            this.clearXid();
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            return this._xaDelegate.prepare(xid);
        }
        if (this._endFlags != -1) {
            int endFlags = this._endFlags;
            this._endFlags = -1;
            this._xaResource.end(xid, endFlags);
        }
        return this._xaResource.prepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.rollback(xid);
            return;
        }
        try {
            if (this._endFlags != -1) {
                try {
                    int endFlags = this._endFlags;
                    this._endFlags = -1;
                    this._xaResource.end(xid, endFlags);
                }
                catch (Throwable e) {
                    dbg.log(e);
                    this._xaResource.rollback(xid);
                    this.clearXid();
                    return;
                }
            }
            if (dbg.canWrite()) {
                dbg.log("rollback XA: pool-item " + this);
            }
            this._xaResource.rollback(xid);
        }
        finally {
            this.clearXid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.commit(xid, onePhase);
            return;
        }
        try {
            if (this._endFlags != -1) {
                try {
                    int endFlags = this._endFlags;
                    this._endFlags = -1;
                    this._xaResource.end(xid, endFlags);
                }
                catch (Throwable e) {
                    dbg.log(e);
                    this._xaResource.rollback(xid);
                    this.clearXid();
                    return;
                }
            }
            if (dbg.canWrite()) {
                dbg.log("commit XA: pool-item " + this + (onePhase ? " 1P " : " 2P"));
            }
            this._xaResource.commit(xid, onePhase);
        }
        finally {
            this.clearXid();
        }
    }

    private void clearXid() {
        PoolItem ptr = this;
        while (ptr != null) {
            PoolItem next = ptr._xaDelegateNext;
            ptr._xaDelegateNext = null;
            ptr._xaDelegate = ptr;
            ptr._xid = null;
            if (!ptr._isActive) {
                this._poolEventTime = Alarm.getCurrentTime();
            }
            ptr = next;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return this._xaDelegate._xaResource.recover(flag);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.end(xid, flags);
            return;
        }
        if (this._xid == null) {
            throw new IllegalStateException();
        }
        if (this._endFlags == -1 && flags != 0x2000000 || flags == 0x20000000) {
            this._endFlags = flags;
        }
    }

    void close() throws SQLException {
        PooledConnection pconn = this._pconn;
        this._pconn = null;
        if (pconn == null) {
            return;
        }
        try {
            Transaction trans;
            TransactionManagerImpl tm = this._pool.getTransactionManager();
            if (tm != null && (trans = tm.getTransaction()) != null) {
                trans.delistResource((XAResource)this, 0x20000000);
            }
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        if (dbgNew.canWrite()) {
            dbgNew.log("close " + this._id + ":" + this._pool.getName());
        }
        try {
            pconn.removeConnectionEventListener(this);
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        try {
            pconn.close();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    public String toString() {
        return "[PoolItem " + this._id + " " + (this._pool == null ? "dead" : this._pool.getName()) + (this._isActive ? " active" : " pooled") + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

