/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.QXAConnection;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

class QXADataSource
implements XADataSource {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool/new");
    private static L10N L = new L10N("com/caucho/sql/messages");
    private DBPool pool;

    QXADataSource(DBPool pool) {
        this.pool = pool;
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Driver driver = this.pool.getDriver();
        String url = this.pool.getURL();
        if (url == null) {
            throw new SQLException(L.l("can't create connection with null url"));
        }
        Properties properties = this.pool.getInfo();
        if (user != null) {
            properties.put("user", user);
        } else {
            properties.put("user", "");
        }
        if (password != null) {
            properties.put("password", password);
        } else {
            properties.put("password", "");
        }
        Connection conn = driver != null ? driver.connect(url, properties) : DriverManager.getConnection(url, properties);
        if (conn == null) {
            throw new SQLException(L.l("can't create connection for `{0}'", url));
        }
        return new QXAConnection(this.pool, conn);
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.pool.getUser(), this.pool.getPassword());
    }

    public int getLoginTimeout() {
        return 0;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLoginTimeout(int foo) {
    }

    public void setLogWriter(PrintWriter log) {
    }
}

