/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.SpyPreparedStatement;
import com.caucho.sql.SpyStatement;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class SpyConnection
implements Connection {
    protected static L10N L = new L10N(class$com$caucho$sql$SpyConnection == null ? (class$com$caucho$sql$SpyConnection = SpyConnection.class$("com.caucho.sql.SpyConnection")) : class$com$caucho$sql$SpyConnection);
    private int _id;
    private int _stmtCount;
    private Connection _conn;
    private WriteStream _os;
    static /* synthetic */ Class class$com$caucho$sql$SpyConnection;

    public SpyConnection(Connection conn, WriteStream os, int id) {
        this._conn = conn;
        this._os = os;
        this._id = id;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getCatalog() throws SQLException {
        try {
            String catalog = this._conn.getCatalog();
            this._os.log(this._id + ":getCatalog() -> " + catalog);
            return catalog;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getCatalog(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this._os.log(this._id + ":setCatalog(" + catalog + ")");
            this._conn.setCatalog(catalog);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-setCatalog(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData metaData = this._conn.getMetaData();
            this._os.log(this._id + ":getMetaData() -> " + metaData);
            return metaData;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getMetaData(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            Map<String, Class<?>> map = this._conn.getTypeMap();
            this._os.log(this._id + ":getTypeMap() -> " + map);
            return map;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getTypeMap(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this._os.log(this._id + ":setTypeMap(" + map + ")");
            this._conn.setTypeMap(map);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-setTypeMap(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            String nativeSQL = this._conn.nativeSQL(sql);
            this._os.log(this._id + ":nativeSQL() -> " + nativeSQL);
            return nativeSQL;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-nativeSQL(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            int isolation = this._conn.getTransactionIsolation();
            this._os.log(this._id + ":getTransactionIsolation() -> " + isolation);
            return isolation;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getTransactionIsolation(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            this._os.log(this._id + ":setTransactionIsolation(" + isolation + ")");
            this._conn.setTransactionIsolation(isolation);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-setTransactionIsolation(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning warning = this._conn.getWarnings();
            this._os.log(this._id + ":getWarnings() -> " + warning);
            return warning;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getWarnings(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this._os.log(this._id + ":clearWarnings()");
            this._conn.clearWarnings();
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-clearWarnings(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this._os.log(this._id + ":setReadOnly(" + readOnly + ")");
            this._conn.setReadOnly(readOnly);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-setReadOnly(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            boolean isReadOnly = this._conn.isReadOnly();
            this._os.log(this._id + "isReadOnly() -> " + isReadOnly);
            return isReadOnly;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-isReadOnly(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":createStatement()");
            Statement stmt = this._conn.createStatement();
            return new SpyStatement(stmtId, this, stmt, this._os);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-createStatement(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":createStatement(type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency);
            return new SpyStatement(stmtId, this, stmt, this._os);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-createStatement(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":prepareStatement(" + sql + ")");
            PreparedStatement stmt = this._conn.prepareStatement(sql);
            return new SpyPreparedStatement(stmtId, (Connection)this, stmt, this._os);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-prepareStatement(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":prepareStatement(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new SpyPreparedStatement(stmtId, (Connection)this, stmt, this._os);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-prepareStatement(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":prepareCall(" + sql + ")");
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-prepareCall(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = this._id + "." + this._stmtCount++;
            this._os.log(stmtId + ":prepareCall(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-prepareCall(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            boolean autoCommit = this._conn.getAutoCommit();
            this._os.log(this._id + ":getAutoCommit() -> " + autoCommit);
            return autoCommit;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-getAutoCommit(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this._os.log(this._id + ":setAutoCommit(" + autoCommit + ")");
            this._conn.setAutoCommit(autoCommit);
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-setAutoCommit(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void commit() throws SQLException {
        try {
            this._os.log(this._id + ":commit()");
            this._conn.commit();
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-commit(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void rollback() throws SQLException {
        try {
            this._os.log(this._id + ":rollback()");
            this._conn.rollback();
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-rollback(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            boolean isClosed = this._conn.isClosed();
            this._os.log(this._id + ":isClosed() -> " + isClosed);
            return isClosed;
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-isClosed(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void close() throws SQLException {
        this._os.log(this._id + ":close()");
        try {
            this._conn.close();
        }
        catch (Throwable e) {
            this._os.log(this._id + ":exn-close(" + e + ")");
            throw SQLExceptionWrapper.create(e);
        }
    }

    public void setHoldability(int hold) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SpyConnection[id=" + this._id + ",conn=" + this._conn + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

