/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.AlarmListener;
import com.caucho.util.Cron;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;

public class Alarm {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/alarm");
    private static Integer timeLock = new Integer(0);
    private static volatile long _currentTime = System.currentTimeMillis();
    private static AlarmThread _alarmThread = new AlarmThread();
    private static Alarm _head;
    private static long _testTime;
    private static int _testCount;
    private long _wakeTime;
    private AlarmListener _listener;
    private String _name;
    private Alarm _next;
    private Alarm _prev;

    public Alarm(AlarmListener listener) {
        this._listener = listener;
        this._name = "alarm";
    }

    public Alarm(String name, AlarmListener listener, long delta) {
        this(listener);
        this._name = name;
        this.queue(delta);
    }

    public Alarm(AlarmListener listener, long delta) {
        this(listener);
        this.queue(delta);
    }

    public static long getCurrentTime() {
        return _currentTime;
    }

    public long getWakeTime() {
        return this._wakeTime;
    }

    public AlarmListener getListener() {
        return this._listener;
    }

    public void setListener(AlarmListener listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(long delta) {
        AlarmThread alarmThread = _alarmThread;
        synchronized (alarmThread) {
            if (this._prev != null) {
                this._prev._next = this._next;
            } else if (_head == this) {
                _head = this._next;
            }
            if (this._next != null) {
                this._next._prev = this._prev;
            }
            this._wakeTime = delta + _currentTime;
            if (_head == null || this._wakeTime < Alarm._head._wakeTime) {
                this._next = _head;
                this._prev = null;
                _head = this;
                if (this._next != null) {
                    this._next._prev = this;
                }
                return;
            }
            Alarm ptr = _head;
            while (ptr._next != null) {
                if (this._wakeTime < ptr._next._wakeTime) {
                    this._prev = ptr;
                    this._next = ptr._next;
                    ptr._next = this;
                    if (this._next != null) {
                        this._next._prev = this;
                    }
                    return;
                }
                ptr = ptr._next;
            }
            this._prev = ptr;
            this._next = null;
            ptr._next = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        AlarmThread alarmThread = _alarmThread;
        synchronized (alarmThread) {
            return this._prev != null || _head == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue() {
        AlarmThread alarmThread = _alarmThread;
        synchronized (alarmThread) {
            if (this._prev != null) {
                this._prev._next = this._next;
            } else if (_head == this) {
                _head = this._next;
            }
            if (this._next != null) {
                this._next._prev = this._prev;
            }
            this._prev = null;
            this._next = null;
        }
    }

    public void close() {
        this.dequeue();
        this._listener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTestTime(long time) {
        _testTime = time;
        if (_testTime > 0L) {
            boolean doCron = false;
            if (_currentTime / 60000L != time / 60000L) {
                doCron = true;
            }
            _currentTime = time;
            if (doCron) {
                Cron.setTestTime(time);
            }
        } else {
            _currentTime = System.currentTimeMillis();
        }
        if (_alarmThread != null) {
            AlarmThread doCron = _alarmThread;
            synchronized (doCron) {
                _alarmThread.evaluateAlarm(new ArrayList());
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "Alarm[name=" + this._name + ",listener=" + this._listener + "]";
    }

    static {
        _alarmThread.start();
    }

    private static class AlarmThread
    extends Thread {
        public void run() {
            ArrayList runnable = new ArrayList();
            while (true) {
                try {
                    while (true) {
                        this.evaluateAlarm(runnable);
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evaluateAlarm(ArrayList runnable) {
            Alarm alarm;
            runnable.clear();
            if (_testTime > 0L) {
                _currentTime = _testTime;
            } else {
                _currentTime = System.currentTimeMillis();
            }
            AlarmThread alarmThread = this;
            synchronized (alarmThread) {
                while (_head != null) {
                    alarm = _head;
                    if (_currentTime < alarm._wakeTime) break;
                    _head = _head._next;
                    if (_head != null) {
                        _head._prev = null;
                    }
                    alarm._prev = null;
                    alarm._next = null;
                    runnable.add(alarm);
                }
            }
            for (int i = 0; i < runnable.size(); ++i) {
                alarm = (Alarm)runnable.get(i);
                if (alarm._listener == null) continue;
                try {
                    alarm._listener.handleAlarm(alarm);
                    continue;
                }
                catch (Throwable e) {
                    dbg.log(e);
                }
            }
        }

        AlarmThread() {
            super("resin-alarm");
            this.setDaemon(true);
        }
    }
}

