/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.Version;
import com.caucho.util.ClassLoaderLocal;
import com.caucho.util.CpuUsage;
import com.caucho.util.Registry;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

public class CauchoSystem {
    static char separatorChar = File.separatorChar;
    static char pathSeparatorChar = File.pathSeparatorChar;
    static String localHost;
    static String userDir;
    static String userName;
    static Path resinHome;
    private static boolean _hasJni;
    private static boolean oldJdk;
    private static int jdkVersion;
    static boolean isTesting;
    private static int isUnix;
    private static int version;
    private static String _newline;
    private static boolean _isCaseInsensitive;
    private static String _user;
    private static String _group;
    private static String classPath;
    static CpuUsage cpuUsage;
    private static ClassLoader staticClassLoader;
    private static ClassLoaderLocal workDirLocal;
    static /* synthetic */ Class class$com$caucho$util$CauchoSystem;

    private CauchoSystem() {
    }

    public static boolean isTesting() {
        return isTesting;
    }

    public static void setIsTesting(boolean testing) {
        isTesting = testing;
    }

    public static void setResinHome(Path path) {
        resinHome = path;
    }

    public static Path getResinHome() {
        int pathSep;
        if (resinHome != null) {
            return resinHome;
        }
        String path = Registry.getPath("/caucho.com/resin.home", null);
        if (path != null) {
            resinHome = Vfs.lookupNative(path);
            return resinHome;
        }
        path = System.getProperty("resin.home");
        if (path != null) {
            resinHome = Vfs.lookupNative(path);
            return resinHome;
        }
        String classpath = System.getProperty("java.class.path");
        int head = 0;
        char sep = CauchoSystem.getFileSeparatorChar();
        int n = pathSep = sep == '/' ? 58 : 59;
        while (path == null) {
            int p = classpath.indexOf(pathSep, head);
            String subpath = p < 0 ? classpath.substring(head) : classpath.substring(head, p);
            if (subpath.endsWith(sep + "lib" + sep + "resin.jar") || subpath.equals("lib" + sep + "resin.jar")) {
                path = subpath.substring(0, subpath.length() - ("lib" + sep + "resin.jar").length());
            } else if (subpath.endsWith(sep + "lib" + sep + "resin-xml.jar") || subpath.equals("lib" + sep + "resin-xml.jar")) {
                path = subpath.substring(0, subpath.length() - ("lib" + sep + "resin-xml.jar").length());
            } else if (subpath.endsWith(sep + "classes") || subpath.equals("classes")) {
                Path resinPath = Vfs.lookupNative(subpath);
                if ((resinPath = resinPath.lookup("com/caucho/util/CauchoSystem.class")).exists()) {
                    path = subpath.substring(0, subpath.length() - "classes".length());
                }
            }
            if (p < 0) break;
            head = p + 1;
        }
        if (path != null) {
            resinHome = Vfs.lookupNative(path);
        }
        if (resinHome != null && resinHome.isDirectory()) {
            return resinHome;
        }
        return Vfs.lookup();
    }

    public static int getVersionId() {
        if (version != 0) {
            return version;
        }
        String v = Version.VERSION;
        version = 1391;
        for (int i = 0; i < v.length(); ++i) {
            version = 65521 * version + v.charAt(i);
        }
        return version;
    }

    public static String getResinConfig() {
        return CauchoSystem.getResinHome() + "/conf/resin.conf";
    }

    public static Path getWorkPath() {
        Path workPath = (Path)workDirLocal.get();
        if (workPath != null) {
            return workPath;
        }
        String workDir = Registry.getPath("/caucho.com/work-path", null);
        if (workDir == null) {
            workDir = Registry.getPath("/caucho.com/java/work-path", null);
        }
        if (workDir == null) {
            workDir = Registry.getPath("/caucho.com/java/work-dir", null);
        }
        if (workDir == null) {
            workDir = System.getProperty("work.dir");
        }
        if (workDir == null && CauchoSystem.isWindows()) {
            workDir = "c:/temp/caucho";
        } else if (workDir == null) {
            workDir = "/tmp/caucho";
        }
        Path path = workDir.charAt(0) == '/' ? Vfs.lookupNative(workDir) : CauchoSystem.getResinHome().lookupNative(workDir);
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String getUserDir() {
        if (userDir == null) {
            userDir = Registry.getPath("/caucho.com/user.dir", System.getProperty("user.dir"));
        }
        return userDir;
    }

    public static char getFileSeparatorChar() {
        return separatorChar;
    }

    public static char getPathSeparatorChar() {
        return pathSeparatorChar;
    }

    public static String getNewlineString() {
        if (_newline == null && (_newline = System.getProperty("line.separator")) == null) {
            _newline = "\n";
        }
        return _newline;
    }

    public static boolean isWindows() {
        return separatorChar == '\\';
    }

    public static boolean isCaseInsensitive() {
        return _isCaseInsensitive;
    }

    public static void setCaseInsensitive(boolean caseInsensitive) {
        _isCaseInsensitive = caseInsensitive;
    }

    public static boolean isUnix() {
        if (isUnix >= 0) {
            return isUnix == 1;
        }
        isUnix = 0;
        if (separatorChar == '/' && Vfs.lookup("/bin/sh").canRead()) {
            isUnix = 1;
        }
        return isUnix == 1;
    }

    public static void setWindowsTest(boolean windows) {
        isTesting = true;
        separatorChar = windows ? (char)92 : File.separatorChar;
    }

    public static String getLocalHost() {
        if (localHost != null) {
            return localHost;
        }
        localHost = Registry.getString("/caucho.com/local.host", null);
        if (localHost != null) {
            return localHost;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localHost = addr.getHostName();
        }
        catch (Throwable e) {
            localHost = "127.0.0.1";
        }
        return localHost;
    }

    public static String getUserName() {
        if (userName != null) {
            return userName;
        }
        userName = Registry.getString("/caucho.com/user.name", null);
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }

    public static CpuUsage getCpuUsage() {
        return CpuUsage.create();
    }

    public static boolean isJdk12() {
        if (jdkVersion == 0) {
            try {
                Thread.currentThread().getContextClassLoader();
                jdkVersion = 66048;
            }
            catch (NoSuchMethodError e) {
                jdkVersion = 65800;
            }
        }
        return jdkVersion >= 66048;
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return CauchoSystem.loadClass(name, false, null);
    }

    public static Class loadClass(String name, boolean init, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null || loader.equals(class$com$caucho$util$CauchoSystem == null ? (class$com$caucho$util$CauchoSystem = CauchoSystem.class$("com.caucho.util.CauchoSystem")) : class$com$caucho$util$CauchoSystem)) {
            return Class.forName(name);
        }
        return Class.forName(name, init, loader);
    }

    public static ClassLoader getContextClassLoader() {
        if (oldJdk) {
            return staticClassLoader;
        }
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (NoSuchMethodError e) {
            oldJdk = true;
            return staticClassLoader;
        }
    }

    public static void setContextClassLoader(ClassLoader loader) {
        if (oldJdk) {
            return;
        }
        try {
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (NoSuchMethodError e) {
            oldJdk = true;
        }
    }

    public static void setStaticClassLoader(ClassLoader loader) {
        staticClassLoader = loader;
        try {
            Thread.currentThread().setContextClassLoader(loader);
        }
        catch (NoSuchMethodError e) {
            oldJdk = true;
        }
    }

    public static ClassLoader getStaticClassLoader() {
        return staticClassLoader;
    }

    public static String getClassPath() {
        if (classPath != null) {
            return classPath;
        }
        String cp = System.getProperty("java.class.path");
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null && !boot.equals("")) {
            cp = cp + File.pathSeparatorChar + boot;
        }
        classPath = cp;
        return classPath;
    }

    public static int setUser(String user, String group) throws Exception {
        _user = user;
        _group = group;
        if (_hasJni && user != null) {
            return CauchoSystem.setUserNative(_user, _group);
        }
        return -1;
    }

    private static native int setUserNative(String var0, String var1) throws IOException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        isUnix = -1;
        version = 0;
        _isCaseInsensitive = File.separatorChar == '\\';
        workDirLocal = new ClassLoaderLocal("caucho.work-dir");
        try {
            System.loadLibrary("resin");
            _hasJni = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

