/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.ClassPackage;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.Depend;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DirectoryClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private Path dir;
    private long lastModified;
    private String[] fileNames;
    private ArrayList jarList;
    private ArrayList dependList;

    protected DirectoryClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static DirectoryClassLoader create(ClassLoader parent, Path dir) {
        DirectoryClassLoader loader = new DirectoryClassLoader(parent);
        loader.dir = dir;
        loader.lastModified = dir.getLastModified();
        try {
            loader.fileNames = dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        loader.jarList = new ArrayList();
        loader.dependList = new ArrayList();
        return loader;
    }

    protected void initImpl() {
        this.fillJars();
    }

    protected boolean isModifiedInt() {
        if (this.lastModified < this.dir.getLastModified()) {
            return true;
        }
        String[] list = null;
        try {
            list = this.dir.list();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.fileNames.length != list.length || this.fileNames == null != (list == null)) {
            return true;
        }
        if (this.fileNames != null) {
            for (int i = 0; i < this.fileNames.length; ++i) {
                if (this.fileNames[i].equals(list[i])) continue;
                return true;
            }
        } else if (this.dependList == null) {
            return false;
        }
        for (int i = this.dependList.size() - 1; i >= 0; --i) {
            Depend depend = (Depend)this.dependList.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    private void fillJars() {
        this.jarList.clear();
        String[] list = null;
        try {
            list = this.dir.list();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int j = 0; list != null && j < list.length; ++j) {
            if (!list[j].endsWith(".jar") && !list[j].endsWith(".zip")) continue;
            Path jar = this.dir.lookup(list[j]);
            this.addJar(jar);
        }
    }

    private void addJar(Path jar) {
        JarPath jarPath = new JarPath(jar);
        this.jarList.add(new JarEntry(jarPath));
        this.dependList.add(new Depend(jar));
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        cb.append(head);
        for (int i = 0; i < this.jarList.size(); ++i) {
            JarEntry jarEntry = (JarEntry)this.jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(jar.getContainer().getNativePath());
        }
        return cb.close();
    }

    protected DynamicClassLoader.Entry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/');
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        pathName = pathName + ".class";
        Object classPath = null;
        for (int i = 0; i < this.jarList.size(); ++i) {
            JarEntry jarEntry = (JarEntry)this.jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
            DynamicClassLoader.Entry entry = new DynamicClassLoader.Entry(this, name, filePath, filePath, this.getCodePath());
            ClassPackage classPackage = jarEntry.getPackage(pkg);
            entry.setClassPackage(classPackage);
            return entry;
        }
        return null;
    }

    protected void getResourcesInt(Vector vector, String name) {
        for (int i = 0; i < this.jarList.size(); ++i) {
            JarEntry jarEntry = (JarEntry)this.jarList.get(i);
            Path path = jarEntry.getJarPath();
            if (!(path = path.lookup(name)).canRead()) continue;
            try {
                vector.add(new URL(path.getURL()));
                continue;
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
    }

    protected Path getPath(String pathName) {
        for (int i = 0; i < this.jarList.size(); ++i) {
            JarEntry jarEntry = (JarEntry)this.jarList.get(i);
            JarPath path = jarEntry.getJarPath();
            Path filePath = path.lookup(pathName);
            if (!filePath.canRead()) continue;
            return filePath;
        }
        return null;
    }

    protected Path getCodePath() {
        return this.dir;
    }

    public String toString() {
        return "[DirectoryClassLoader " + this.dir + "]";
    }

    static class JarEntry {
        private JarPath jarPath;
        private ArrayList packages = new ArrayList();

        JarEntry(JarPath jarPath) {
            this.jarPath = jarPath;
            this.readManifest();
        }

        private void readManifest() {
            try {
                Manifest manifest = this.jarPath.getManifest();
                if (manifest == null) {
                    return;
                }
                Attributes attr = manifest.getMainAttributes();
                if (attr != null) {
                    this.addManifestPackage("", attr);
                }
                Map<String, Attributes> entries = manifest.getEntries();
                Iterator<String> iter = entries.keySet().iterator();
                while (iter.hasNext()) {
                    String pkg = iter.next();
                    attr = manifest.getAttributes(pkg);
                    if (attr == null) continue;
                    this.addManifestPackage(pkg, attr);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void addManifestPackage(String name, Attributes attr) {
            if (!name.endsWith("/") && !name.equals("")) {
                return;
            }
            String specTitle = attr.getValue("Specification-Title");
            String specVersion = attr.getValue("Specification-Version");
            String specVendor = attr.getValue("Specification-Vendor");
            String implTitle = attr.getValue("Implementation-Title");
            String implVersion = attr.getValue("Implementation-Version");
            String implVendor = attr.getValue("Implementation-Vendor");
            if (specTitle == null && specVersion == null && specVendor != null && implTitle == null && implVersion == null && implVendor != null) {
                return;
            }
            ClassPackage pkg = new ClassPackage(name);
            pkg.setSpecificationTitle(specTitle);
            pkg.setSpecificationVersion(specVersion);
            pkg.setSpecificationVendor(specVendor);
            pkg.setImplementationTitle(implTitle);
            pkg.setImplementationVersion(implVersion);
            pkg.setImplementationVendor(implVendor);
            this.packages.add(pkg);
        }

        public ClassPackage getPackage(String name) {
            ClassPackage bestPackage = null;
            int bestLength = -1;
            for (int i = 0; i < this.packages.size(); ++i) {
                ClassPackage pkg = (ClassPackage)this.packages.get(i);
                String prefix = pkg.getPrefix();
                if (!name.startsWith(prefix) || bestLength >= prefix.length()) continue;
                bestPackage = pkg;
                bestLength = prefix.length();
            }
            return bestPackage;
        }

        public JarPath getJarPath() {
            return this.jarPath;
        }
    }
}

