/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoClassLoader;
import com.caucho.util.CauchoSystem;
import com.caucho.util.ClassLoaderListener;
import com.caucho.util.ClassPackage;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class DynamicClassLoader
extends SecureClassLoader
implements CauchoClassLoader {
    private static L10N L = new L10N(class$com$caucho$util$DynamicClassLoader == null ? (class$com$caucho$util$DynamicClassLoader = DynamicClassLoader.class$("com.caucho.util.DynamicClassLoader")) : class$com$caucho$util$DynamicClassLoader);
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private ClassLoader parent;
    protected DynamicClassLoader top = this;
    private DynamicClassLoader next;
    private HashMap cache;
    private ArrayList classes;
    private boolean useServletHack;
    private String[] parentPriorityPackages;
    private ArrayList listeners;
    private ArrayList permissions;
    private long lastMake;
    private SecurityManager securityManager;
    private CodeSource codeSource;
    private Hashtable attributes;
    static /* synthetic */ Class class$com$caucho$util$DynamicClassLoader;

    public DynamicClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
        this.securityManager = System.getSecurityManager();
    }

    public void setNext(DynamicClassLoader next) {
        if (next == this) {
            throw new RuntimeException();
        }
        this.next = next;
        DynamicClassLoader ptr = next;
        while (ptr != null) {
            ptr.top = this.top;
            if (this.top.parent == null) {
                this.top.parent = ptr.parent;
            }
            ptr.parent = null;
            ptr.cache = null;
            ptr = ptr.next;
        }
    }

    public DynamicClassLoader getTop() {
        return this.top;
    }

    public void init() {
        DynamicClassLoader ptr = this;
        while (ptr != null) {
            ptr.initImpl();
            ptr = ptr.next;
        }
    }

    protected void initImpl() {
    }

    public ClassLoader getParentLoader() {
        return this.top.getParent();
    }

    protected Package getPackage(String name) {
        if (this.top == this) {
            return super.getPackage(name);
        }
        return this.top.getPackage(name);
    }

    protected Package definePackage(String name, String a1, String a2, String a3, String b1, String b2, String b3, URL url) {
        if (this.top == this) {
            if ((name = name.replace('/', '.')).endsWith(".")) {
                name = name.substring(0, name.length() - 1);
            }
            return super.definePackage(name, a1, a2, a3, b1, b2, b3, url);
        }
        return this.top.definePackage(name, a1, a2, a3, b1, b2, b3, url);
    }

    public void addPermission(String path, String actions) {
        this.addPermission(new FilePermission(path, actions));
    }

    public void addPermission(Permission permission) {
        if (this.top.permissions == null) {
            this.top.permissions = new ArrayList();
        }
        this.top.permissions.add(permission);
    }

    public ArrayList getPermissions() {
        return this.top.permissions;
    }

    public void addPermissions(ArrayList perms) {
        if (perms == null) {
            return;
        }
        if (this.top.permissions == null) {
            this.top.permissions = new ArrayList();
        }
        this.top.permissions.addAll(perms);
    }

    public void setServletHack(boolean servletHack) {
        this.top.useServletHack = servletHack;
        if (this.top.parentPriorityPackages == null) {
            this.top.parentPriorityPackages = new String[0];
        }
    }

    public void addParentPriorityPackage(String pkg) {
        if (this.top.parentPriorityPackages == null) {
            this.top.parentPriorityPackages = new String[0];
        }
        int oldLength = this.top.parentPriorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this.top.parentPriorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = pkg + '.';
        }
        newPkgs[oldLength] = pkg;
        this.top.parentPriorityPackages = newPkgs;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.top != this && this.top != null) {
            return this.top.getPermissions(codeSource);
        }
        PermissionCollection perms = super.getPermissions(codeSource);
        ArrayList permissions = this.top.permissions;
        for (int i = 0; permissions != null && i < permissions.size(); ++i) {
            Permission permission = (Permission)permissions.get(i);
            perms.add(permission);
        }
        return perms;
    }

    protected void addCodeBasePath(String path) {
    }

    public final String getClassPath() {
        ClassLoader parent = this.top.parent;
        String head = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).top.getClassPath() : CauchoSystem.getClassPath();
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            head = ptr.getClassPath(head);
            ptr = ptr.next;
        }
        return head;
    }

    public final String getSourcePath() {
        String head = this.top.parent instanceof DynamicClassLoader ? ((DynamicClassLoader)this.top.parent).getSourcePath() : CauchoSystem.getClassPath();
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            head = ptr.getSourcePath(head);
            ptr = ptr.next;
        }
        return head;
    }

    protected String getClassPath(String head) {
        return head;
    }

    protected String getSourcePath(String head) {
        return this.getClassPath(head);
    }

    public final boolean isModified() {
        if (this.top == null) {
            return true;
        }
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            if (ptr.isModifiedInt()) {
                return true;
            }
            ptr = ptr.next;
        }
        if (this.top.parent instanceof DynamicClassLoader) {
            return ((DynamicClassLoader)this.top.parent).isModified();
        }
        return false;
    }

    protected boolean isModifiedInt() {
        ArrayList classes = this.classes;
        if (classes == null) {
            return false;
        }
        for (int i = classes.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)classes.get(i);
            if (entry == null || !entry.isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void makeAll() throws IOException, ClassNotFoundException {
        long now;
        if (this.top.parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)this.parent).makeAll();
        }
        if ((now = Alarm.getCurrentTime()) <= this.lastMake + 1000L) {
            return;
        }
        DynamicClassLoader dynamicClassLoader = this.top;
        synchronized (dynamicClassLoader) {
            now = Alarm.getCurrentTime();
            if (now <= this.lastMake + 1000L) {
                return;
            }
            this.top.makeAllRec();
            this.lastMake = Alarm.getCurrentTime();
        }
    }

    private void makeAllRec() throws IOException, ClassNotFoundException {
        if (this.next != null) {
            this.next.makeAllRec();
        }
        this.makeAllInt();
    }

    protected void makeAllInt() throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ClassLoaderListener listener) {
        DynamicClassLoader dynamicClassLoader = this.top;
        synchronized (dynamicClassLoader) {
            if (this.top.listeners == null) {
                this.top.listeners = new ArrayList();
            }
            if (!this.top.listeners.contains(listener)) {
                this.top.listeners.add(listener);
            }
        }
    }

    public void unload() {
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            DynamicClassLoader next = ptr.next;
            ptr.unloadInt();
            ptr = next;
        }
    }

    private void unloadInt() {
        for (int i = 0; this.listeners != null && i < this.listeners.size(); ++i) {
            ClassLoaderListener listener = (ClassLoaderListener)this.listeners.get(i);
            listener.handleUnload(this);
        }
        this.listeners = null;
        this.attributes = null;
        this.cache = null;
        this.classes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader parent;
        Class<?> cl = null;
        DynamicClassLoader top = this.top;
        if (top == null) {
            throw new IllegalStateException(L.l("Attempted to load class from closed class loader {0}.", this));
        }
        if (this != top) {
            return top.loadClass(name, resolve);
        }
        cl = this.findLoadedClass(name);
        if (cl != null) {
            return cl;
        }
        boolean normalJdkOrder = this.isNormalJdkOrder(name);
        if (normalJdkOrder) {
            try {
                parent = this.getParent();
                cl = parent == null ? Class.forName(name) : Class.forName(name, resolve, parent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl != null) {
            return cl;
        }
        DynamicClassLoader e = this;
        synchronized (e) {
            if (cl == null) {
                cl = this.findClass(name);
            }
            if (cl != null && resolve) {
                this.resolveClass(cl);
            }
            if (cl != null) {
                return cl;
            }
        }
        if (!normalJdkOrder) {
            try {
                parent = this.getParent();
                if (parent == null) {
                    return Class.forName(name);
                }
                return Class.forName(name, resolve, parent);
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Class findClass(String name) throws ClassNotFoundException {
        name = name.replace('/', '.');
        Class cl = null;
        if (this != this.top) {
            throw new RuntimeException(L.l("Internal error: findClass must be called from top class loader."));
        }
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            Entry entry = this.cache == null ? null : this.cache.get(name);
            if (entry != null) {
                return entry.getEntryClass();
            }
            DynamicClassLoader ptr = this;
            while (ptr != null && (entry = ptr.getClassEntry(name)) == null) {
                ptr = ptr.next;
            }
            if (entry != null) {
                try {
                    cl = this.loadClass(entry);
                }
                catch (Exception e) {
                    dbg.log(e);
                    throw new ClassNotFoundException(name + " [" + e + "]");
                }
                if (cl != null) {
                    if (this.cache == null) {
                        this.cache = new HashMap(8);
                    }
                    this.cache.put(name, entry);
                    if (ptr.classes == null) {
                        ptr.classes = new ArrayList();
                    }
                    ptr.classes.add(entry);
                }
                return cl;
            }
        }
        return cl;
    }

    protected Class loadClass(Entry entry) throws IOException, ClassNotFoundException {
        if (this != this.top) {
            return this.top.loadClass(entry);
        }
        Class<?> cl = entry.getEntryClass();
        if (cl != null) {
            return cl;
        }
        String name = entry.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            String packageName = name.substring(0, p);
            Package pkg = this.getPackage(packageName);
            ClassPackage classPackage = entry.getClassPackage();
            if (pkg == null) {
                if (classPackage != null) {
                    this.definePackage(packageName, classPackage.getSpecificationTitle(), classPackage.getSpecificationVersion(), classPackage.getSpecificationVendor(), classPackage.getImplementationTitle(), classPackage.getImplementationVersion(), classPackage.getImplementationVendor(), null);
                } else {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
            }
        }
        ByteBuffer buffer = new ByteBuffer();
        entry.load(buffer);
        try {
            cl = this.securityManager != null ? this.defineClass(entry.getName(), buffer.getBuffer(), 0, buffer.length(), entry.getCodeSource()) : this.defineClass(entry.getName(), buffer.getBuffer(), 0, buffer.length());
        }
        catch (Throwable e) {
            dbg.log(e);
            throw new ClassNotFoundException(entry.getName() + " [" + e + "]");
        }
        entry.setEntryClass(cl);
        return cl;
    }

    protected Entry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/') + ".class";
        Path path = this.getPath(pathName);
        if (path != null && path.getLength() > 0L) {
            return new Entry(this, name, path, path, this.getCodePath());
        }
        return null;
    }

    public final URL getResource(String name) {
        URL url;
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        if (isNormalJdkOrder) {
            url = DynamicClassLoader.getSystemResource(name);
            if (url != null) {
                return url;
            }
            if (this.top.parent != null) {
                url = this.top.parent.getResource(name);
            }
            if (url != null) {
                return url;
            }
        }
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            Path path = name.startsWith("/") ? ptr.getPath("." + name) : ptr.getPath(name);
            if (path != null && path.canRead()) {
                try {
                    return new URL(path.getURL());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ptr = ptr.next;
        }
        if (!isNormalJdkOrder) {
            url = DynamicClassLoader.getSystemResource(name);
            if (url != null) {
                return url;
            }
            if (this.top.parent != null) {
                url = this.top.parent.getResource(name);
            }
            if (url != null) {
                return url;
            }
        }
        return null;
    }

    public final InputStream getResourceAsStream(String name) {
        InputStream is;
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        if (isNormalJdkOrder) {
            is = DynamicClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (this.top.parent != null) {
                is = this.top.parent.getResourceAsStream(name);
            }
            if (is != null) {
                return is;
            }
        }
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            block12: {
                Path path = ptr.getPath("./" + name);
                if (path != null && path.canRead()) {
                    try {
                        return path.openRead();
                    }
                    catch (IOException e) {
                        if (!dbg.canWrite()) break block12;
                        dbg.log(e);
                    }
                }
            }
            ptr = ptr.next;
        }
        if (!isNormalJdkOrder) {
            is = DynamicClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                return is;
            }
            if (this.top.parent != null) {
                is = this.top.parent.getResourceAsStream(name);
            }
            if (is != null) {
                return is;
            }
        }
        return null;
    }

    public Enumeration findResources(String name) {
        Vector resources = new Vector();
        if (name.startsWith("/")) {
            name = "." + name;
        }
        DynamicClassLoader ptr = this.top;
        while (ptr != null) {
            ptr.getResourcesInt(resources, name);
            ptr = ptr.next;
        }
        return resources.elements();
    }

    protected void getResourcesInt(Vector vector, String name) {
        Path path = this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                vector.add(new URL(path.getURL()));
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
    }

    public String findLibrary(String name) {
        try {
            String systemName = System.mapLibraryName(name);
            Path path = this.getPath(systemName);
            if (path != null && path.canRead()) {
                return path.getNativePath();
            }
        }
        catch (Error error) {
            // empty catch block
        }
        if (this.next != null) {
            return this.next.findLibrary(name);
        }
        return super.findLibrary(name);
    }

    protected Path getCodePath() {
        return null;
    }

    protected Path getPath(String name) {
        return null;
    }

    private boolean isNormalJdkOrder(String className) {
        if (!this.top.useServletHack) {
            return true;
        }
        String[] pkgs = this.top.parentPriorityPackages;
        String canonName = className.replace('/', '.');
        for (int i = 0; i < pkgs.length; ++i) {
            if (!canonName.startsWith(pkgs[i])) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        Object value = null;
        if (this.top != null && this.top.attributes != null) {
            value = this.top.attributes.get(name);
        }
        if (value == null && this.parent instanceof DynamicClassLoader) {
            value = ((DynamicClassLoader)this.parent).getAttribute(name);
        }
        return value;
    }

    public Object getLevelAttribute(String name) {
        Object value = null;
        if (this.top != null && this.top.attributes != null) {
            value = this.top.attributes.get(name);
        }
        return value;
    }

    public void setAttribute(String name, Object obj) {
        if (obj == null) {
            if (this.top.attributes == null) {
                return;
            }
            this.top.attributes.remove(name);
            return;
        }
        if (this.top.attributes == null) {
            this.top.attributes = new Hashtable(8);
        }
        this.top.attributes.put(name, obj);
    }

    public void destroy() {
        this.unload();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Entry {
        private DynamicClassLoader _loader;
        private String _name;
        private Path _classPath;
        private long _classLastModified;
        private long _classLength;
        private Path _sourcePath;
        private long _sourceLastModified;
        private long _sourceLength;
        private ClassPackage _classPackage;
        private CodeSource _codeSource;
        private WeakReference _clRef;

        public Entry(DynamicClassLoader loader, String name, Path sourcePath, Path classPath, Path codePath) {
            this._loader = loader;
            this._name = name;
            this._classPath = classPath;
            this._classLastModified = classPath.getLastModified();
            this._classLength = classPath.getLength();
            if (sourcePath != null && !sourcePath.equals(classPath)) {
                this._sourcePath = sourcePath;
                this._sourceLastModified = sourcePath.getLastModified();
                this._sourceLength = sourcePath.getLength();
            }
            if (codePath == null) {
                codePath = classPath;
            }
            if (this._loader.securityManager != null) {
                try {
                    this._codeSource = new CodeSource(new URL(codePath.getURL()), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public Entry(DynamicClassLoader loader, String name, Path sourcePath, Path classPath) {
            this(loader, name, sourcePath, classPath, classPath);
        }

        public String getName() {
            return this._name;
        }

        public CodeSource getCodeSource() {
            return this._codeSource;
        }

        public ClassPackage getClassPackage() {
            return this._classPackage;
        }

        public void setClassPackage(ClassPackage pkg) {
            this._classPackage = pkg;
        }

        public boolean isModified() {
            if (this._classPath.getLastModified() != this._classLastModified) {
                if (dbg.canWrite()) {
                    dbg.log("class modified time: " + this._classPath + " old:" + QDate.formatLocal(this._classLastModified) + " new:" + QDate.formatLocal(this._classPath.getLastModified()));
                }
                return true;
            }
            if (this._classPath.getLength() != this._classLength) {
                if (dbg.canWrite()) {
                    dbg.log("class modified length: " + this._classPath + " old:" + this._classLength + " new:" + this._classPath.getLength());
                }
                return true;
            }
            if (this._sourcePath == null) {
                return false;
            }
            if (this._sourcePath.getLastModified() != this._sourceLastModified) {
                if (dbg.canWrite()) {
                    dbg.log("source modified time: " + this._sourcePath + " old:" + QDate.formatLocal(this._sourceLastModified) + " new:" + QDate.formatLocal(this._sourcePath.getLastModified()));
                }
                return true;
            }
            if (this._sourcePath.getLength() != this._sourceLength) {
                if (dbg.canWrite()) {
                    dbg.log("source modified length: " + this._sourcePath + " old:" + this._sourceLength + " new:" + this._sourcePath.getLength());
                }
                return true;
            }
            return false;
        }

        public Path getClassPath() {
            return this._classPath;
        }

        public Class getEntryClass() {
            WeakReference clRef = this._clRef;
            if (clRef != null) {
                return (Class)clRef.get();
            }
            return null;
        }

        public void setEntryClass(Class cl) {
            this._clRef = new WeakReference<Class>(cl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(ByteBuffer buffer) throws IOException {
            buffer.clear();
            long length = this._classPath.getLength();
            if (length < 0L) {
                throw new IOException("missing:");
            }
            ReadStream is = this._classPath.openRead();
            try {
                buffer.setLength((int)length);
                if ((long)is.readAll(buffer.getBuffer(), 0, (int)length) != length) {
                    throw new IOException("length mismatch");
                }
            }
            finally {
                is.close();
            }
        }

        public String toString() {
            if (this._sourcePath == null) {
                return "ClassLoader.Entry[" + this._classPath + "]";
            }
            return "ClassLoader.Entry[" + this._classPath + ", src=" + this._sourcePath + "]";
        }
    }
}

