/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ExitListener;
import java.util.ArrayList;

public class Exit {
    private static ThreadLocal waiting = new ThreadLocal();

    private Exit() {
    }

    public static void addExit(ExitListener listener, Object object) {
        Queue queue = (Queue)waiting.get();
        if (queue != null) {
            queue.add(listener, object);
        }
    }

    public static boolean addExit() {
        Queue queue = (Queue)waiting.get();
        if (queue == null) {
            queue = Queue.allocate();
            waiting.set(queue);
            return true;
        }
        return false;
    }

    public static void exit() {
        Queue queue = null;
        queue = (Queue)waiting.get();
        waiting.set(null);
        if (queue == null) {
            return;
        }
        int size = queue.listeners.size();
        for (int i = 0; i < size; ++i) {
            ExitListener listener = (ExitListener)queue.listeners.get(i);
            Object object = queue.objects.get(i);
            if (listener == null) continue;
            try {
                listener.handleExit(object);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        queue.free();
    }

    private static class Queue {
        static Queue freeList;
        Queue next;
        ArrayList listeners = new ArrayList();
        ArrayList objects = new ArrayList();

        private Queue() {
        }

        void add(ExitListener listener, Object object) {
            this.listeners.add(listener);
            this.objects.add(object);
        }

        static Queue allocate() {
            if (freeList == null) {
                return new Queue();
            }
            Queue queue = freeList;
            freeList = Queue.freeList.next;
            return queue;
        }

        void free() {
            this.listeners.clear();
            this.objects.clear();
            this.next = freeList;
            freeList = this;
        }
    }
}

