/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CacheListener;

public class FlatCache {
    private Object[] keys;
    private Object[] values;
    private int capacity = 32;
    private int mask;
    private static Object NULL = new Object();

    public FlatCache(int initialCapacity) {
        while (this.capacity < 2 * initialCapacity) {
            this.capacity *= 2;
        }
        this.keys = new Object[this.capacity];
        this.values = new Object[this.capacity];
        this.mask = this.capacity - 1;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.capacity; ++i) {
            if (this.values[i] instanceof CacheListener) {
                ((CacheListener)this.values[i]).removeEvent();
            }
            this.keys[i] = null;
            this.values[i] = null;
        }
    }

    public Object get(Object key) {
        int hash;
        Object testKey;
        if (key == null) {
            key = NULL;
        }
        if ((testKey = this.keys[hash = key.hashCode() & this.mask]) != null && testKey.equals(key) && testKey == this.keys[hash]) {
            return this.values[hash];
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        if (key == null) {
            key = NULL;
        }
        int hash = key.hashCode() & this.mask;
        Object old = this.values[hash];
        this.keys[hash] = null;
        this.values[hash] = value;
        this.keys[hash] = key;
        if (old instanceof CacheListener) {
            ((CacheListener)old).removeEvent();
        }
        return old;
    }

    public Object remove(Object key) {
        return this.put(key, null);
    }
}

