/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;

public class TimedCache
extends LruCache {
    private long expireInterval;

    public TimedCache(int capacity, long expireInterval) {
        super(capacity);
        this.expireInterval = expireInterval;
    }

    public Object put(Object key, Object value) {
        return super.put(key, new Entry(this.expireInterval, value));
    }

    public Object get(Object key) {
        Entry entry = (Entry)super.get(key);
        if (entry == null) {
            return null;
        }
        if (!entry.isValid()) {
            super.remove(key);
            return null;
        }
        return entry.getValue();
    }

    static class Entry
    implements CacheListener {
        long expireInterval;
        long checkTime;
        Object value;

        Entry(long expireInterval, Object value) {
            this.expireInterval = expireInterval;
            this.value = value;
            this.checkTime = Alarm.getCurrentTime();
        }

        boolean isValid() {
            return Alarm.getCurrentTime() < this.checkTime + this.expireInterval;
        }

        Object getValue() {
            return this.value;
        }

        public void removeEvent() {
            if (this.value instanceof CacheListener) {
                ((CacheListener)this.value).removeEvent();
            }
        }
    }
}

