/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class CachePath
extends FilesystemPath {
    private static final int BLOCK_SIZE = 1024;
    private Path backingRoot;
    private LruCache cache;
    private long maxSize;
    private long maxEntrySize;
    private long size;
    private Path file;
    private Cache item;
    private boolean removeOnRelease;
    private long readTotalCount;
    private long readHitCount;

    public CachePath(Path root, int entries, long capacity) {
        super(null, "/", "/");
        this._root = this;
        this.backingRoot = root.createRoot();
        this.cache = new LruCache(entries);
        this.maxSize = capacity;
        this.maxEntrySize = this.maxSize / 64L;
        this.maxEntrySize += 1023L;
        this.maxEntrySize -= this.maxEntrySize % 1024L;
        if (this.maxEntrySize > 0x100000L) {
            this.maxEntrySize = 0x100000L;
        }
        this.clear();
    }

    protected CachePath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
    }

    public void setRemoveOnRelease(boolean remove) {
        ((CachePath)this._root).removeOnRelease = remove;
    }

    protected Path fsWalk(String userPath, Map attributes, String path) {
        return new CachePath(this._root, userPath, path);
    }

    public String getScheme() {
        return "cache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CachePath cRoot;
        CachePath cachePath = cRoot = (CachePath)this._root;
        synchronized (cachePath) {
            cRoot.cache.clear();
            cRoot.size = 0L;
        }
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public long getLength() {
        return this.getFile().getLength();
    }

    public long getLastModified() {
        return this.getFile().getLastModified();
    }

    public void setLastModified(long time) {
        this.getFile().setLastModified(time);
    }

    public boolean canRead() {
        return this.getFile().canRead();
    }

    public boolean canWrite() {
        return this.getFile().canWrite();
    }

    public String[] list() throws IOException {
        return this.getFile().list();
    }

    public boolean mkdir() throws IOException {
        return this.getFile().mkdir();
    }

    public boolean mkdirs() throws IOException {
        return this.getFile().mkdirs();
    }

    public boolean remove() throws IOException {
        if (this.getFile().remove()) {
            CachePath root = (CachePath)this._root;
            root.cache.remove(this.getPath());
            return true;
        }
        return false;
    }

    public boolean renameTo(Path path) throws IOException {
        if (this.getFile().renameTo(path)) {
            CachePath root = (CachePath)this._root;
            root.cache.remove(this.getPath());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer head;
        CachePath root = (CachePath)this._root;
        LruCache cache = root.cache;
        String path = this.getPath();
        if (this.item == null) {
            this.item = (Cache)cache.get(path);
        }
        if (this.item != null && (head = this.item.getHead()) != null) {
            while (head != null) {
                os.write(head.getBuffer(), 0, head.getLength());
                head = head.getNext();
            }
            return;
        }
        Path file = this.getFile();
        long length = file.getLength();
        if (length <= root.maxEntrySize && length > 0L) {
            TempBuffer head2;
            ReadStream is = file.openRead();
            try {
                head2 = this.copyFromStream(is, os, length);
            }
            finally {
                is.close();
            }
            this.item = new Cache(root, file, head2);
            CachePath cachePath = root;
            synchronized (cachePath) {
                long size = this.item.getSize();
                root.size += this.item.getSize();
                cache.put(path, this.item);
            }
            while (root.size > root.maxSize) {
                root.cache.removeTail();
            }
        } else {
            this.getFile().writeToStream(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamImpl openReadImpl() throws IOException {
        CachePath root = (CachePath)this._root;
        LruCache cache = root.cache;
        String path = this.getPath();
        Cache item = (Cache)cache.get(path);
        ++root.readTotalCount;
        if (item != null) {
            ++root.readHitCount;
            TempReadStream rs = new TempReadStream(item.getHead());
            rs.setFreeWhenDone(false);
            return rs;
        }
        Path file = this.getFile();
        long length = file.getLength();
        if (length <= root.maxEntrySize && length > 0L) {
            try {
                ReadStream is = file.openRead();
                TempBuffer head = this.copyFromStream(is, null, length);
                is.close();
                item = new Cache(root, file, head);
                CachePath cachePath = root;
                synchronized (cachePath) {
                    root.size += item.getSize();
                    root.cache.put(path, item);
                }
                while (root.size > root.maxSize) {
                    root.cache.removeTail();
                }
                TempReadStream rs = new TempReadStream(head);
                rs.setFreeWhenDone(false);
                return rs;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return file.openReadImpl();
    }

    private TempBuffer copyFromStream(ReadStream is, OutputStream os, long length) throws IOException {
        int len;
        TempBuffer head;
        TempBuffer tail = head = new TempBuffer(1024);
        while ((len = is.readAll(tail.getBuffer(), 0, tail.getCapacity())) > 0) {
            length -= (long)len;
            tail.setLength(len);
            if (os != null) {
                os.write(tail.getBuffer(), 0, len);
            }
            if (length <= 0L) break;
            tail.setNext(new TempBuffer(1024));
            tail = tail.getNext();
        }
        return head;
    }

    public StreamImpl openWriteImpl() throws IOException {
        String path = this.getPath();
        LruCache cache = ((CachePath)this._root).cache;
        cache.remove(path);
        return this.getFile().openWriteImpl();
    }

    public StreamImpl openAppendImpl() throws IOException {
        return this.getFile().openAppendImpl();
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return this.getFile().openReadWriteImpl();
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof CachePath) {
            CachePath test = (CachePath)b;
            return this.getFile().equals(test.getFile());
        }
        return this.getFile().equals(b);
    }

    private Path getFile() {
        if (this.file == null) {
            this.file = ((CachePath)this._root).backingRoot.lookup(this.getPath());
        }
        return this.file;
    }

    static class Cache
    implements CacheListener {
        private CachePath root;
        private Path path;
        private TempBuffer head;
        private long size;

        Cache(CachePath root, Path path, TempBuffer head) {
            this.root = root;
            this.path = path;
            this.head = head;
            for (TempBuffer ptr = head; ptr != null; ptr = ptr.getNext()) {
                this.size += (long)ptr.getCapacity();
            }
        }

        TempBuffer getHead() {
            return this.head;
        }

        long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEvent() {
            CachePath cachePath = this.root;
            synchronized (cachePath) {
                this.root.size -= this.size;
                this.size = 0L;
            }
            this.head = null;
            if (this.root.removeOnRelease) {
                try {
                    this.path.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

