/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;

public class Depend {
    private static WriteStream dbg = LogStream.open("/caucho.com/vfs/depend");
    Path source;
    long lastModified;
    long length;
    boolean requireSource;

    public Depend(Path source) {
        this.source = source;
        this.lastModified = source.getLastModified();
        this.length = source.getLength();
    }

    public Depend(Path source, long lastModified, long length) {
        this.source = source;
        this.lastModified = lastModified;
        this.length = length;
    }

    public Path getPath() {
        return this.source;
    }

    public long getLastModified() {
        return this.source.getLastModified();
    }

    public long getLength() {
        return this.source.getLength();
    }

    public boolean getRequireSource() {
        return this.requireSource;
    }

    public void setRequireSource(boolean requireSource) {
        this.requireSource = requireSource;
    }

    public boolean isModified() {
        long sourceLastModified = this.source.getLastModified();
        long sourceLength = this.source.getLength();
        if (!this.requireSource && sourceLastModified == 0L) {
            return false;
        }
        if (sourceLength != this.length) {
            if (dbg.canWrite()) {
                dbg.log(this.source.getNativePath() + " length is modified.");
            }
            return true;
        }
        if (sourceLastModified != this.lastModified) {
            if (dbg.canWrite()) {
                dbg.log(this.source.getNativePath() + " time is modified.");
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Depend)) {
            return false;
        }
        Depend depend = (Depend)obj;
        return this.source.equals(depend.source);
    }

    public String toString() {
        return "[Depend " + this.source + " " + this.lastModified + " " + (this.source.getLastModified() - this.lastModified) + " " + this.length + " " + this.source.getLength() + "]";
    }
}

