/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.LogStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipStream
extends StreamImpl {
    private static WriteStream dbg = LogStream.open("/caucho.com/vfs/http");
    private OutputStream _os;
    private GZIPOutputStream _out;
    private boolean _enable = true;

    public GzipStream(OutputStream os) throws IOException {
        this.init(os);
    }

    public void init(OutputStream os) {
        this._os = os;
        this._out = null;
        this._enable = true;
    }

    public void setEnable(boolean enable) {
        this._enable = enable;
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._os == null) {
            return;
        }
        if (!this._enable) {
            this._os.write(buf, offset, length);
        } else {
            if (this._out == null) {
                this._out = new GZIPOutputStream(this._os);
            }
            this._out.write(buf, offset, length);
        }
    }

    public void flush() throws IOException {
        if (!this._enable) {
            this._os.flush();
        } else if (this._out != null) {
            this._out.flush();
        }
    }

    public void close() throws IOException {
        GZIPOutputStream out = this._out;
        this._out = null;
        this._os = null;
        if (this._enable && out != null) {
            ((OutputStream)out).close();
        }
    }
}

