/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.ExceptionWrapper;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class IOExceptionWrapper
extends IOException
implements ExceptionWrapper {
    private Throwable rootCause;

    public IOExceptionWrapper(String message) {
        super(message);
    }

    public IOExceptionWrapper(String message, Throwable e) {
        super(message);
        this.rootCause = e;
    }

    public IOExceptionWrapper(Throwable e) {
        super(e.toString());
        this.rootCause = e;
    }

    public static IOException create(Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOExceptionWrapper(e);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            out.println("Root cause is:");
            rootCause.printStackTrace(out);
        }
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        Throwable rootCause = this.getRootCause();
        if (rootCause != null) {
            out.println("Root cause is:");
            rootCause.printStackTrace(out);
        }
    }
}

