/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Jar
implements CacheListener {
    private static WriteStream dbg = LogStream.open("/caucho.com/vfs/jar");
    private static LruCache _jarCache;
    private Path _backing;
    private long _lastModified;
    private long _length;
    private long _lastTime;
    private SoftReference _jarFileRef;
    private long _jarLastModified;
    private JarFile _closeJarFile;

    private Jar(Path backing) {
        this._backing = backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Jar create(Path backing) {
        if (_jarCache == null) {
            int size = 256;
            _jarCache = new LruCache(size);
        }
        LruCache lruCache = _jarCache;
        synchronized (lruCache) {
            Jar jar = (Jar)_jarCache.get(backing);
            if (jar == null) {
                jar = new Jar(backing);
                _jarCache.put(backing, jar);
            }
            return jar;
        }
    }

    Path getBacking() {
        return this._backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        Jar jar = this;
        synchronized (jar) {
            JarFile jarFile = this.getJarFile();
            manifest = jarFile == null ? null : jarFile.getManifest();
        }
        this.closeJarFile();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean exists(String path) {
        boolean exists;
        Jar jar = this;
        synchronized (jar) {
            exists = this.getSafeJarEntry(path) != null;
        }
        this.closeJarFile();
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(String path) {
        boolean isDirectory;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry;
            if (!path.endsWith("/")) {
                path = path + '/';
            }
            isDirectory = (entry = this.getSafeJarEntry(path)) == null && (path.equals("/") || path.equals("")) ? true : entry != null && entry.isDirectory();
        }
        this.closeJarFile();
        return isDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFile(String path) {
        boolean isFile;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path);
            isFile = entry != null && !entry.isDirectory();
        }
        this.closeJarFile();
        return isFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String path) {
        long lastModified;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path);
            lastModified = entry == null ? 0L : this._lastModified;
        }
        this.closeJarFile();
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(Path path) {
        long length;
        Jar jar = this;
        synchronized (jar) {
            ZipEntry entry = this.getSafeJarEntry(path.getPath());
            length = entry == null ? -1L : entry.getSize();
        }
        this.closeJarFile();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(String path) {
        boolean canRead;
        Jar jar = this;
        synchronized (jar) {
            canRead = this._backing.canRead() && this.isFile(path);
        }
        this.closeJarFile();
        return canRead;
    }

    public boolean canWrite(String path) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list(String pathName) throws IOException {
        if (pathName.length() > 0 && !pathName.endsWith("/")) {
            pathName = pathName + "/";
        }
        if (pathName.startsWith("/")) {
            pathName = pathName.substring(1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] result = null;
        Jar jar = this;
        synchronized (jar) {
            JarFile jarFile = this.getJarFile();
            if (jarFile != null) {
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                    String subName = name.substring(pathName.length());
                    int p = subName.indexOf(47);
                    if (p < 0) {
                        list.add(subName);
                        continue;
                    }
                    if (p != subName.length() - 1) continue;
                    list.add(subName.substring(0, p));
                }
                result = list.toArray(new String[list.size()]);
            }
        }
        if (result != null) {
            this.closeJarFile();
            return result;
        }
        ReadStream backingIs = this._backing.openRead();
        ZipInputStream is = new ZipInputStream(backingIs);
        try {
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith(pathName) || name.equals(pathName)) continue;
                String subName = name.substring(pathName.length());
                int p = subName.indexOf(47);
                if (p < 0) {
                    list.add(subName);
                    continue;
                }
                if (p != subName.length() - 1) continue;
                list.add(subName.substring(0, p));
            }
        }
        finally {
            is.close();
            backingIs.close();
        }
        return list.toArray(new String[list.size()]);
    }

    public StreamImpl openReadImpl(Path path) throws IOException {
        ZipFile zipFile;
        ZipEntry entry;
        String pathName = path.getPath();
        if (pathName.length() > 0 && pathName.charAt(0) == '/') {
            pathName = pathName.substring(1);
        }
        if ((entry = (zipFile = new ZipFile(this._backing.getNativePath())).getEntry(pathName)) != null) {
            InputStream is = zipFile.getInputStream(entry);
            return new ZipStreamImpl(zipFile, is, null, path);
        }
        zipFile.close();
        throw new FileNotFoundException(path.toString());
    }

    public String toString() {
        return this._backing.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJarCache() {
        LruCache jarCache = _jarCache;
        if (jarCache == null) {
            return;
        }
        ArrayList jars = new ArrayList();
        LruCache lruCache = jarCache;
        synchronized (lruCache) {
            Iterator iter = jarCache.values();
            while (iter.hasNext()) {
                jars.add(iter.next());
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            Jar jar = (Jar)jars.get(i);
            if (jar == null) continue;
            jar.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            SoftReference jarFileRef = this._jarFileRef;
            this._jarFileRef = null;
            if (jarFileRef != null) {
                jarFile = (JarFile)jarFileRef.get();
            }
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ZipEntry getSafeJarEntry(String path) {
        try {
            return this.getJarEntry(path);
        }
        catch (IOException e) {
            dbg.log(e);
            return null;
        }
    }

    private ZipEntry getJarEntry(String path) throws IOException {
        JarFile jarFile;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((jarFile = this.getJarFile()) != null) {
            return jarFile.getEntry(path);
        }
        return null;
    }

    private JarFile getJarFile() throws IOException {
        SoftReference jarFileRef;
        JarFile jarFile = null;
        if (this.getLastModifiedImpl() == this._jarLastModified && (jarFileRef = this._jarFileRef) != null && (jarFile = (JarFile)jarFileRef.get()) != null) {
            return jarFile;
        }
        SoftReference oldJarRef = this._jarFileRef;
        this._jarFileRef = null;
        ZipFile oldFile = null;
        if (oldJarRef != null) {
            if (this._closeJarFile == null) {
                this._closeJarFile = (JarFile)oldJarRef.get();
            } else {
                oldFile = (JarFile)oldJarRef.get();
            }
        }
        if (oldFile != null) {
            try {
                oldFile.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this._closeJarFile != null) {
            oldFile = this._closeJarFile;
            this._closeJarFile = null;
            oldFile.close();
        }
        if (this._backing.getScheme().equals("file") && this._backing.canRead()) {
            jarFile = new JarFile(this._backing.getNativePath());
            this._jarFileRef = new SoftReference<JarFile>(jarFile);
            this._jarLastModified = this.getLastModifiedImpl();
        }
        return jarFile;
    }

    private long getLastModifiedImpl() {
        long now = Alarm.getCurrentTime();
        if (now == this._lastTime) {
            return this._lastModified;
        }
        long oldLastModified = this._lastModified;
        long oldLength = this._length;
        this._lastModified = this._backing.getLastModified();
        this._length = this._backing.getLength();
        this._lastTime = now;
        if (this._lastModified != oldLastModified || this._length != oldLength) {
            SoftReference oldFileRef = this._jarFileRef;
            this._jarFileRef = null;
            this._jarLastModified = 0L;
            if (oldFileRef != null) {
                this._closeJarFile = (JarFile)oldFileRef.get();
            }
        }
        return this._lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeJarFile() {
        JarFile jarFile = null;
        Jar jar = this;
        synchronized (jar) {
            jarFile = this._closeJarFile;
            this._closeJarFile = null;
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
    }

    public void removeEvent() {
        this.clearCache();
    }

    static class ZipStreamImpl
    extends StreamImpl {
        private ZipFile _zipFile;
        private InputStream _zis;
        private InputStream _is;

        ZipStreamImpl(ZipFile file, InputStream zis, InputStream is, Path path) {
            this._zipFile = file;
            this._zis = zis;
            this._is = is;
            this.setPath(path);
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() throws IOException {
            if (this._zis == null) {
                return -1;
            }
            return this._zis.available();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            int readLen = this._zis.read(buf, off, len);
            return readLen;
        }

        public void close() throws IOException {
            ZipFile zipFile = this._zipFile;
            this._zipFile = null;
            InputStream zis = this._zis;
            this._zis = null;
            InputStream is = this._is;
            this._is = null;
            if (zis != null) {
                zis.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
            if (is != null) {
                is.close();
            }
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }
}

