/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JndiPath
extends FilesystemPath {
    protected static WriteStream dbg = LogStream.open("/com/caucho/vfs/jndi");
    protected static L10N L = new L10N("/com/caucho/vfs/messages");
    private Context parent;

    JndiPath() {
        super(null, "/", "/");
        this._root = this;
    }

    protected JndiPath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
    }

    protected Path fsWalk(String userPath, Map attributes, String path) {
        return new JndiPath(this._root, userPath, path);
    }

    public String getScheme() {
        return "jndi";
    }

    public boolean mkdir() throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            parent.createSubcontext(this.getTail());
            return true;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public Object getObject() throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            return parent.lookup(this.getTail());
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public void setObject(Object value) throws IOException {
        try {
            Context parent = this.getAllButLast(this.getPath());
            parent.rebind(this.getTail(), value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOExceptionWrapper(e);
        }
    }

    private Context getAllButLast(String path) throws NamingException {
        int tail;
        if (this.parent != null) {
            return this.parent;
        }
        Context context = new InitialContext();
        int head = 1;
        while ((tail = path.indexOf(47, head)) > 0) {
            String section = path.substring(head, tail);
            if (context == null) {
                throw new NamingException(L.l("null context for `{0}'", path));
            }
            context = (Context)context.lookup(section);
            head = tail + 1;
        }
        this.parent = context;
        return this.parent;
    }
}

