/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MergePath
extends FilesystemPath {
    private ArrayList _pathList;
    private Path _bestPath;

    public MergePath() {
        super(null, "/", "/");
        this._root = this;
        this._pathList = new ArrayList();
    }

    private MergePath(MergePath root, String userPath, Map attributes, String path) {
        super(root, userPath, path);
    }

    public void addMergePath(Path path) {
        if (!(path instanceof MergePath)) {
            ((MergePath)this._root)._pathList.add(path);
        } else {
            if (((MergePath)path)._root == this._root) {
                return;
            }
            MergePath mergePath = (MergePath)path;
            ArrayList subPaths = mergePath.getMergePaths();
            String pathName = "./" + mergePath._pathname;
            for (int i = 0; i < subPaths.size(); ++i) {
                Path subPath = (Path)subPaths.get(i);
                this.addMergePath(subPath.lookup(pathName));
            }
        }
    }

    public void addClassPath() {
        this.addClassPath(CauchoSystem.getContextClassLoader());
    }

    public void addClassPath(ClassLoader loader) {
        String classpath = null;
        classpath = loader instanceof DynamicClassLoader ? ((DynamicClassLoader)loader).getClassPath() : System.getProperty("java.class.path");
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        while (head < classpath.length()) {
            tail = classpath.indexOf(sep, head);
            String segment = null;
            if (tail < 0) {
                segment = classpath.substring(head);
                head = classpath.length();
            } else {
                segment = classpath.substring(head, tail);
                head = tail + 1;
            }
            if (segment.equals("")) continue;
            if (segment.endsWith(".jar") || segment.endsWith(".zip")) {
                this.addMergePath(new JarPath(Vfs.lookup(segment)));
                continue;
            }
            this.addMergePath(Vfs.lookup(segment));
        }
    }

    public ArrayList getMergePaths() {
        return ((MergePath)this._root)._pathList;
    }

    protected Path fsWalk(String userPath, Map attributes, String path) {
        ArrayList pathList = this.getMergePaths();
        if (!userPath.startsWith("/") || pathList.size() == 0) {
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        String bestPrefix = null;
        for (int i = 0; i < pathList.size(); ++i) {
            Path subPath = (Path)pathList.get(i);
            String prefix = subPath.getPath();
            if (!path.startsWith(prefix) || bestPrefix != null && bestPrefix.length() >= prefix.length()) continue;
            bestPrefix = prefix;
        }
        if (bestPrefix != null) {
            if (!(path = path.substring(bestPrefix.length())).startsWith("/")) {
                path = "/" + path;
            }
            return new MergePath((MergePath)this._root, userPath, attributes, path);
        }
        return ((Path)pathList.get(0)).lookup(userPath, attributes);
    }

    public String getScheme() {
        return this.getBestPath().getScheme();
    }

    public String getFullPath() {
        Path path = this.getBestPath();
        return path.getFullPath();
    }

    public String getURL() {
        Path path = this.getBestPath();
        return path.getURL();
    }

    public String getRelativePath() {
        if (this._pathname.startsWith("/")) {
            return "." + this._pathname;
        }
        return this._pathname;
    }

    public boolean exists() {
        return this.getBestPath().exists();
    }

    public boolean isDirectory() {
        return this.getBestPath().isDirectory();
    }

    public boolean isFile() {
        return this.getBestPath().isFile();
    }

    public long getLength() {
        return this.getBestPath().getLength();
    }

    public long getLastModified() {
        return this.getBestPath().getLastModified();
    }

    public boolean canRead() {
        return this.getBestPath().canRead();
    }

    public boolean canWrite() {
        return this.getBestPath().canWrite();
    }

    public ArrayList getResources(String pathName) {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = (Path)pathList.get(i);
            path = path.lookup(pathname);
            ArrayList subResources = path.getResources(pathName);
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = (Path)subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    public ArrayList getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = (Path)pathList.get(i);
            path = path.lookup(pathname);
            ArrayList subResources = path.getResources();
            for (int j = 0; j < subResources.size(); ++j) {
                Path newPath = (Path)subResources.get(j);
                if (list.contains(newPath)) continue;
                list.add(newPath);
            }
        }
        return list;
    }

    public String[] list() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList pathList = ((MergePath)this._root)._pathList;
        for (int i = 0; i < pathList.size(); ++i) {
            Path path = (Path)pathList.get(i);
            if (!(path = path.lookup(pathname)).isDirectory()) continue;
            String[] subList = path.list();
            for (int j = 0; j < subList.length; ++j) {
                if (list.contains(subList[j])) continue;
                list.add(subList[j]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean mkdir() throws IOException {
        return this.getBestPath().mkdir();
    }

    public boolean mkdirs() throws IOException {
        return this.getBestPath().mkdirs();
    }

    public boolean remove() throws IOException {
        return this.getBestPath().remove();
    }

    public boolean renameTo(Path path) throws IOException {
        return this.getBestPath().renameTo(path);
    }

    public StreamImpl openReadImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadImpl();
        stream.setPath(this);
        return stream;
    }

    public StreamImpl openWriteImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openWriteImpl();
        stream.setPath(this);
        return stream;
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openReadWriteImpl();
        stream.setPath(this);
        return stream;
    }

    public StreamImpl openAppendImpl() throws IOException {
        StreamImpl stream = this.getBestPath().openAppendImpl();
        stream.setPath(this);
        return stream;
    }

    public Path getBestPath() {
        Path realPath;
        Path path;
        int i;
        if (this._bestPath != null) {
            return this._bestPath;
        }
        String pathname = this._pathname;
        if (pathname.startsWith("/")) {
            pathname = "." + pathname;
        }
        ArrayList pathList = ((MergePath)this._root)._pathList;
        for (i = 0; i < pathList.size(); ++i) {
            path = (Path)pathList.get(i);
            realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            if (!realPath.exists()) continue;
            this._bestPath = realPath;
            return realPath;
        }
        pathname = this._pathname;
        for (i = 0; i < pathList.size(); ++i) {
            path = (Path)pathList.get(i);
            realPath = path.lookup(pathname);
            realPath.setUserPath(this._userPath);
            if (!realPath.exists()) continue;
            this._bestPath = realPath;
            return realPath;
        }
        return new NotFoundPath(this._userPath);
    }

    public String toString() {
        return "[MergePath " + this._pathname + "]";
    }
}

