/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public abstract class Path {
    protected static L10N L = new L10N("/com/caucho/vfs/messages");
    private static Integer LOCK = new Integer(0);
    protected SchemeMap schemeMap;

    protected Path(Path root) {
        if (root != null) {
            this.schemeMap = root.schemeMap;
            return;
        }
        this.schemeMap = SchemeMap.getDefaultSchemeMap();
    }

    public final Path lookup(String name) {
        return this.lookup(name, null);
    }

    public Path lookup(String userPath, Map newAttributes) {
        Path path;
        char ch;
        int length;
        if (userPath == null) {
            return this.lookup(this.getPath(), newAttributes);
        }
        String scheme = this.scanScheme(userPath);
        if (scheme == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        if (CauchoSystem.isWindows() && (length = scheme.length()) == 1 && ((ch = scheme.charAt(0)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (path = this.schemeMap.getScheme("file")) != null) {
            return path.schemeWalk(userPath, newAttributes, "/" + userPath, 0);
        }
        path = this.schemeMap.getScheme(scheme);
        if (path == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        return path.schemeWalk(userPath, newAttributes, userPath, scheme.length() + 1);
    }

    public final Path lookupNative(String name) {
        return this.lookupNative(name, null);
    }

    public Path lookupNative(String name, Map attributes) {
        return this.lookup(name, attributes);
    }

    public ArrayList getResources(String name) {
        ArrayList<Path> list = new ArrayList<Path>();
        Path path = this.lookup(name);
        if (path.exists()) {
            list.add(path);
        }
        return list;
    }

    public ArrayList getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this);
        return list;
    }

    public Path getParent() {
        return this;
    }

    protected String scanScheme(String uri) {
        int i = 0;
        if (uri == null) {
            return null;
        }
        int length = uri.length();
        if (length == 0) {
            return null;
        }
        char ch = uri.charAt(0);
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            for (i = 1; i < length; ++i) {
                ch = uri.charAt(i);
                if (ch == ':') {
                    return uri.substring(0, i).toLowerCase();
                }
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0' || ch == '+' || ch == '-' || ch == '.')) break;
            }
        }
        return null;
    }

    protected abstract Path schemeWalk(String var1, Map var2, String var3, int var4);

    public String getURL() {
        return this.getScheme() + ":" + this.getFullPath();
    }

    public abstract String getScheme();

    public String getHost() {
        throw new UnsupportedOperationException();
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public abstract String getPath();

    public String getTail() {
        return "";
    }

    public String getQuery() {
        throw new UnsupportedOperationException();
    }

    public String getNativePath() {
        return this.getFullPath();
    }

    public String getUserPath() {
        return this.getPath();
    }

    public void setUserPath(String userPath) {
    }

    public String getFullPath() {
        return this.getPath();
    }

    public String getRelativePath() {
        return this.getPath();
    }

    public boolean exists() {
        return false;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public long getLength() {
        return 0L;
    }

    public long getLastModified() {
        return 0L;
    }

    public void setLastModified(long time) {
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public String[] list() throws IOException {
        return new String[0];
    }

    public Iterator iterator() throws IOException {
        return new ArrayIterator(this.list());
    }

    public boolean mkdir() throws IOException {
        return false;
    }

    public boolean mkdirs() throws IOException {
        return false;
    }

    public boolean remove() throws IOException {
        return false;
    }

    public boolean removeAll() throws IOException {
        if (this.isDirectory()) {
            String[] list = this.list();
            for (int i = 0; i < list.length; ++i) {
                Path subpath = this.lookup(list[i]);
                subpath.removeAll();
            }
        }
        return this.remove();
    }

    public boolean renameTo(Path path) throws IOException {
        return false;
    }

    public final boolean renameTo(String path) throws IOException {
        return this.renameTo(this.lookup(path));
    }

    public Path createRoot() {
        return this.createRoot(new SchemeMap());
    }

    public Path createRoot(SchemeMap schemeMap) {
        throw new UnsupportedOperationException("createRoot");
    }

    public void bind(Path context) {
        throw new UnsupportedOperationException("bind");
    }

    public void unbind() {
        throw new UnsupportedOperationException("unbind");
    }

    public Object getValue() throws Exception {
        throw new UnsupportedOperationException("getValue");
    }

    public void setValue(Object obj) throws Exception {
        throw new UnsupportedOperationException("setValue");
    }

    public Object getAttribute(String name) throws IOException {
        return null;
    }

    public void setAttribute(String name, Object value) throws IOException {
    }

    public void removeAttribute(String name) throws IOException {
    }

    public Iterator getAttributeNames() throws IOException {
        return null;
    }

    public final ReadStream openRead() throws IOException {
        StreamImpl impl = this.openReadImpl();
        return new ReadStream(impl);
    }

    public final WriteStream openWrite() throws IOException {
        StreamImpl impl = this.openWriteImpl();
        return new WriteStream(impl);
    }

    public ReadWritePair openReadWrite() throws IOException {
        StreamImpl impl = this.openReadWriteImpl();
        WriteStream writeStream = new WriteStream(impl);
        ReadStream readStream = new ReadStream(impl, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public void openReadWrite(ReadStream is, WriteStream os) throws IOException {
        StreamImpl impl = this.openReadWriteImpl();
        os.init(impl);
        is.init(impl, os);
    }

    public WriteStream openAppend() throws IOException {
        StreamImpl impl = this.openAppendImpl();
        return new WriteStream(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile() throws IOException {
        Integer n = LOCK;
        synchronized (n) {
            if (!this.exists()) {
                WriteStream s = this.openWrite();
                s.close();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path createTempFile(String prefix, String suffix) throws IOException {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("prefix too short: " + prefix);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random random = new Random();
        Integer n = LOCK;
        synchronized (n) {
            for (int i = 0; i < 32768; ++i) {
                int r = Math.abs(random.nextInt());
                Path file = this.lookup(prefix + r + suffix);
                if (!file.createNewFile()) continue;
                return file;
            }
        }
        throw new IOException("cannot create temp file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        ReadStream is = this.openRead();
        try {
            is.writeToStream(os);
        }
        finally {
            is.close();
        }
    }

    public Object getObject() throws IOException {
        throw new UnsupportedOperationException(this.getScheme() + ": doesn't support getObject");
    }

    public void setObject(Object obj) throws IOException {
        throw new UnsupportedOperationException(this.getScheme() + ": doesn't support setObject");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        return this.getPath().equals(((Path)o).getPath());
    }

    public String toString() {
        return this.getPath();
    }

    protected StreamImpl openReadImpl() throws IOException {
        throw new UnsupportedOperationException("openRead");
    }

    protected StreamImpl openWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openWrite");
    }

    protected StreamImpl openReadWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openReadWrite");
    }

    protected StreamImpl openAppendImpl() throws IOException {
        throw new UnsupportedOperationException("openAppend");
    }

    private class ArrayIterator
    implements Iterator {
        String[] list;
        int index;

        public boolean hasNext() {
            return this.index < this.list.length;
        }

        public Object next() {
            return this.index < this.list.length ? this.list[this.index++] : null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ArrayIterator(String[] list) {
            this.list = list;
            this.index = 0;
        }
    }
}

