/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.QJniSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import java.io.IOException;
import java.net.InetAddress;

public class QJniServerSocket
extends QServerSocket {
    private static boolean hasInitJni;
    private boolean _tcpNoDelay = true;
    private int fd;

    public QJniServerSocket() {
    }

    public QJniServerSocket(int fd) {
        this.setFd(fd);
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    public void setTcpNoDelay(boolean delay) {
        this._tcpNoDelay = delay;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public QSocket accept() throws IOException {
        if (this.fd == 0) {
            throw new IOException("accept from closed socket");
        }
        int childFd = this.acceptNative(this.fd);
        if (childFd == 0) {
            return null;
        }
        QJniSocket jniSocket = new QJniSocket();
        jniSocket.setFd(childFd);
        return jniSocket;
    }

    public QSocket accept(QSocket socket) throws IOException {
        QJniSocket jniSocket = (QJniSocket)socket;
        if (this.fd == 0) {
            throw new IOException("accept from closed socket");
        }
        int childFd = this.acceptNative(this.fd);
        if (childFd == 0) {
            return null;
        }
        if (jniSocket == null) {
            jniSocket = new QJniSocket();
        }
        jniSocket.setFd(childFd);
        return jniSocket;
    }

    native int acceptNative(int var1) throws IOException;

    public QSocket createSocket() throws IOException {
        return new QJniSocket();
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getLocalPort() {
        return this.getLocalPort(this.fd);
    }

    native int getLocalPort(int var1);

    public void close() throws IOException {
    }
}

