/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import java.io.IOException;
import java.net.InetAddress;

public class QSSLFactory {
    private String _certificateFile;
    private String _keyFile;
    private String _certificateChainFile;
    private String _caCertificatePath;
    private String _caCertificateFile;
    private String _caRevocationPath;
    private String _caRevocationFile;
    private String _password;
    private String _verifyClient;

    public void setCertificateFile(String certificateFile) {
        this._certificateFile = certificateFile;
    }

    public String getCertificateFile() {
        return this._certificateFile;
    }

    public void setKeyFile(String keyFile) {
        this._keyFile = keyFile;
    }

    public String getKeyFile() {
        return this._keyFile;
    }

    public void setCertificateChainFile(String certificateChainFile) {
        this._certificateChainFile = certificateChainFile;
    }

    public String getCertificateChainFile() {
        return this._certificateChainFile;
    }

    public void setCACertificatePath(String caCertificatePath) {
        this._caCertificatePath = caCertificatePath;
    }

    public String getCACertificatePath() {
        return this._caCertificatePath;
    }

    public void setCACertificateFile(String caCertificateFile) {
        this._caCertificateFile = caCertificateFile;
    }

    public String getCACertificateFile() {
        return this._caCertificateFile;
    }

    public void setCARevocationPath(String caRevocationPath) {
        this._caRevocationPath = caRevocationPath;
    }

    public String getCARevocationPath() {
        return this._caRevocationPath;
    }

    public void setCARevocationFile(String caRevocationFile) {
        this._caRevocationFile = caRevocationFile;
    }

    public String getCARevocationFile() {
        return this._caRevocationFile;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setVerifyClient(String verifyClient) {
        this._verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this._verifyClient;
    }

    public QServerSocket create(int port) throws IOException {
        return this.create(null, port);
    }

    public QServerSocket create(InetAddress host, int port) throws IOException {
        String certificateFile = this._certificateFile;
        String keyFile = this._keyFile;
        if (keyFile == null) {
            keyFile = certificateFile;
        }
        if (certificateFile == null) {
            certificateFile = keyFile;
        }
        if (certificateFile == null) {
            throw new IOException("certificate file is missing");
        }
        if (keyFile == null) {
            throw new IOException("key file is missing");
        }
        if (this._password == null) {
            throw new IOException("password is missing.");
        }
        int fd = this.bindPort(0L, port, certificateFile, keyFile, this._certificateChainFile, this._caCertificatePath, this._caCertificateFile, this._caRevocationPath, this._caRevocationFile, this._password, this._verifyClient);
        if (fd == 0) {
            throw new IOException("error creating SSL server socket");
        }
        return new QJniServerSocket(fd);
    }

    native int bindPort(long var1, int var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12);

    static {
        try {
            System.loadLibrary("resin");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

