/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.JarScheme;
import com.caucho.vfs.JndiPath;
import com.caucho.vfs.LogPath;
import com.caucho.vfs.MailtoPath;
import com.caucho.vfs.NotFoundPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.VfsStream;
import java.util.HashMap;
import java.util.Iterator;

public class SchemeMap {
    private static SchemeMap NULL_SCHEME_MAP;
    private static SchemeMap DEFAULT_SCHEME_MAP;
    private HashMap schemeMap = new HashMap();
    private boolean autoLoadSchemes;

    static SchemeMap getNullSchemeMap() {
        if (NULL_SCHEME_MAP == null) {
            NULL_SCHEME_MAP = new SchemeMap();
        }
        return NULL_SCHEME_MAP;
    }

    static SchemeMap getDefaultSchemeMap() {
        if (DEFAULT_SCHEME_MAP == null) {
            DEFAULT_SCHEME_MAP = new SchemeMap();
            SchemeMap.fillDefaultSchemeMap();
        }
        return DEFAULT_SCHEME_MAP;
    }

    static void fillDefaultSchemeMap() {
        try {
            SchemeMap.DEFAULT_SCHEME_MAP.autoLoadSchemes = true;
            DEFAULT_SCHEME_MAP.setScheme("file", new FilePath(null));
            DEFAULT_SCHEME_MAP.setScheme("jar", new JarScheme(null));
            VfsStream nullStream = new VfsStream(null, null);
            DEFAULT_SCHEME_MAP.setScheme("null", new ConstPath(null, nullStream));
            DEFAULT_SCHEME_MAP.setScheme("log", new LogPath(null, "/", null, "/"));
            StdoutStream stdout = StdoutStream.create();
            StderrStream stderr = StderrStream.create();
            DEFAULT_SCHEME_MAP.setScheme("stdout", stdout.getPath());
            DEFAULT_SCHEME_MAP.setScheme("stderr", stderr.getPath());
            DEFAULT_SCHEME_MAP.setScheme("jndi", new JndiPath());
            DEFAULT_SCHEME_MAP.setScheme("mailto", new MailtoPath(null, null, null, null));
            DEFAULT_SCHEME_MAP.setScheme("http", new HttpPath("127.0.0.1", 0));
            DEFAULT_SCHEME_MAP.setScheme("tcp", new TcpPath(null, null, "127.0.0.1", 0));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void setDefaultSchemeMap(SchemeMap map) {
        DEFAULT_SCHEME_MAP = map;
    }

    public synchronized Path getScheme(String scheme) {
        Path root = (Path)this.schemeMap.get(scheme);
        if (root != null) {
            return root;
        }
        if (!this.autoLoadSchemes) {
            return new NotFoundPath(scheme + ":");
        }
        root = this.loadSchemeFromRegistry(scheme);
        if (root == null) {
            root = new NotFoundPath(scheme + ":");
        }
        return root;
    }

    public synchronized void setScheme(String scheme, Path handler) {
        this.schemeMap.put(scheme, handler);
    }

    public synchronized Path removeScheme(String scheme) {
        return (Path)this.schemeMap.remove(scheme);
    }

    private Path loadSchemeFromRegistry(String scheme) {
        RegistryNode root = Registry.lookup("caucho.com");
        Iterator iter = root.select("vfs");
        while (iter.hasNext()) {
            RegistryNode vfs = (RegistryNode)iter.next();
            String schemeName = vfs.getString("scheme", null);
            String className = vfs.getString("class-name", null);
            if (schemeName == null || !scheme.equals(schemeName) || className == null) continue;
            Class<?> cl = null;
            Path path = null;
            try {
                cl = Class.forName(className);
                path = (Path)cl.newInstance();
                return path;
            }
            catch (Throwable e) {
            }
        }
        return null;
    }
}

