/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.i18n.EncodingReader;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF8Reader
extends EncodingReader {
    private InputStream is;

    public UTF8Reader() {
    }

    private UTF8Reader(InputStream is) {
        this.is = is;
    }

    public Reader create(InputStream is, String javaEncoding) {
        return new UTF8Reader(is);
    }

    public int read() throws IOException {
        int ch1 = this.is.read();
        if (ch1 < 128) {
            return ch1;
        }
        if ((ch1 & 0xE0) == 192) {
            int ch2 = this.is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            return ((ch1 & 0x1F) << 6) + (ch2 & 0x3F);
        }
        if ((ch1 & 0xF0) == 224) {
            int ch2 = this.is.read();
            int ch3 = this.is.read();
            if (ch2 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch2 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            if (ch3 < 0) {
                throw new EOFException("unexpected end of file in utf8 character");
            }
            if ((ch3 & 0xC0) != 128) {
                throw new CharConversionException("illegal utf8 encoding");
            }
            int ch = ((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F);
            if (ch == 65279) {
                return this.read();
            }
            return ch;
        }
        throw new CharConversionException("illegal utf8 encoding at (" + ch1 + ")");
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        for (i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch < 0) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)ch;
        }
        return i;
    }
}

