/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.webutil;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.LooseHtml;
import com.caucho.xml.LooseXml;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HttpForm {
    private HashMap properties = new HashMap();

    public void clear() {
        this.properties.clear();
    }

    public void setAttribute(String key, String value) {
        this.properties.put(key, value);
    }

    public String getAttribute(String key) {
        return (String)this.properties.get(key);
    }

    public void removeAttribute(String key) {
        this.properties.remove(key);
    }

    public Iterator getAttributeNames() {
        return this.properties.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document queryHtml(Path path) throws IOException, SAXException {
        ReadStream is = this.queryStream(path);
        try {
            Document document = new LooseHtml().parseDocument(is);
            return document;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document queryXml(Path path) throws IOException, SAXException {
        ReadStream is = this.queryStream(path);
        try {
            Document document = new LooseXml().parseDocument(is);
            return document;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream queryStream(Path path) throws IOException {
        Path http = path;
        ReadWritePair pair = http.openReadWrite();
        ReadStream is = pair.getReadStream();
        WriteStream os = pair.getWriteStream();
        try {
            os.setAttribute("Content-Type", "application/x-www-form-urlencoded");
            boolean isFirst = true;
            Iterator iter = this.getAttributeNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = this.getAttribute(key);
                if (!isFirst) {
                    os.print('&');
                }
                os.print(key);
                os.print('=');
                os.print(URLEncoder.encode(value));
                isFirst = false;
            }
            String status = (String)is.getAttribute("status");
            ReadStream readStream = is;
            return readStream;
        }
        finally {
            os.setDisableClose(true);
            os.close();
        }
    }
}

