/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.xml.QAttributes;
import com.caucho.xml.QDocument;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QEntityReference;
import com.caucho.xml.QName;
import com.caucho.xml.XMLWriter;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlParseException;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DOMBuilder
implements XMLWriter,
ContentHandler {
    static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    static L10N L = new L10N("com/caucho/xml/messages");
    private QDocument doc;
    private Node top;
    private Node node;
    private String singleText;
    private CharBuffer text;
    private boolean escapeText;
    private boolean strictXml;
    private ArrayList _prefixNames = new ArrayList();
    private ArrayList _prefixValues = new ArrayList();
    private boolean isCoalescing = true;
    private boolean skipWhitespace = false;
    private Locator locator;
    private String systemId;

    public void init(Node top) {
        this.doc = top instanceof QDocument ? (QDocument)top : (QDocument)top.getOwnerDocument();
        this.top = top;
        this.node = top;
        this.singleText = null;
        this.text = new CharBuffer();
        this._prefixNames.clear();
        this._prefixValues.clear();
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        if (this.doc != null) {
            this.doc.setSystemId(systemId);
        }
        if (systemId != null && this.top instanceof Document) {
            Document tdoc = (Document)this.top;
            DocumentType dtd = tdoc.getDoctype();
            if (tdoc instanceof QDocument && dtd == null) {
                ((QDocument)tdoc).setDoctype(new QDocumentType(null));
            }
            if (dtd instanceof QDocumentType && dtd.getSystemId() == null) {
                ((QDocumentType)dtd).setSystemId(systemId);
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setFilename(String filename) {
        if (filename != null && this.top instanceof QDocument) {
            QDocument tdoc = (QDocument)this.top;
            tdoc.setRootFilename(filename);
        }
    }

    public void setStrictXML(boolean isStrictXml) {
        this.strictXml = isStrictXml;
    }

    public void setCoalescing(boolean isCoalescing) {
        this.isCoalescing = isCoalescing;
    }

    public void setSkipWhitespace(boolean skipWhitespace) {
        this.skipWhitespace = skipWhitespace;
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
        if (loc != null) {
            this.doc.setLocation(loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
        }
    }

    public void startPrefixMapping(String prefix, String url) {
        if (this.node == null || this.node == this.top) {
            this.doc.addNamespace(prefix, url);
        }
        if (prefix.equals("")) {
            this._prefixNames.add(new QName(null, "xmlns", XMLNS));
            this._prefixValues.add(url);
        } else {
            this._prefixNames.add(new QName("xmlns", prefix, XMLNS));
            this._prefixValues.add(url);
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public Node getNode() {
        return this.top;
    }

    public void startDocument() {
    }

    public void endDocument() throws SAXException {
        this.popText();
    }

    public void setLocation(String filename, int line, int column) {
    }

    public void startElement(String uri, String localName, String qName) throws IOException {
        this.popText();
        Element elt = this.doc.createElementNS(uri, qName);
        this.node.appendChild(elt);
        this.node = elt;
    }

    public void startElement(QName name, QAttributes attributes) throws SAXException {
        QDocumentType dtd;
        this.popText();
        QElement elt = (QElement)this.doc.createElementByName(name);
        this.node.appendChild(elt);
        this.node = elt;
        for (int i = 0; i < this._prefixNames.size(); ++i) {
            QName attrName = (QName)this._prefixNames.get(i);
            String value = (String)this._prefixValues.get(i);
            elt.setAttribute(attrName, value);
        }
        this._prefixNames.clear();
        this._prefixValues.clear();
        int length = attributes.getLength();
        for (int i = length - 1; i >= 0; --i) {
            QName attrName = attributes.getName(i);
            String value = attributes.getValue(i);
            elt.setAttribute(attrName, value);
        }
        if (this.locator != null) {
            elt.setLocation(this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        if ((dtd = (QDocumentType)this.doc.getDoctype()) != null) {
            dtd.fillDefaults(elt);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        QDocumentType dtd;
        this.popText();
        Element elt = uri != null && !uri.equals("") ? this.doc.createElementNS(uri, qName) : (!qName.equals("") ? this.doc.createElement(qName) : this.doc.createElement(localName));
        if (this.node == this.doc) {
            if (this.doc.getDocumentElement() == null) {
                this.doc.setDocumentElement(elt);
            } else if (this.strictXml) {
                throw this.error(L.l("expected a single top-level element at `{0}'", qName));
            }
        }
        this.node.appendChild(elt);
        this.node = elt;
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String attrUri = attributes.getURI(i);
            String attrQname = attributes.getQName(i);
            String value = attributes.getValue(i);
            Attr attr = attrUri != null && !attrUri.equals("") ? this.doc.createAttributeNS(attrUri, attrQname) : (!attrQname.equals("") ? this.doc.createAttribute(attrQname) : this.doc.createAttribute(attributes.getLocalName(i)));
            attr.setNodeValue(value);
            ((Element)this.node).setAttributeNode(attr);
        }
        if (this.locator != null) {
            ((QElement)elt).setLocation(this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        if ((dtd = (QDocumentType)this.doc.getDoctype()) != null) {
            dtd.fillDefaults((QElement)elt);
        }
    }

    public void dtd(QDocumentType dtd) {
        this.doc.setDoctype(dtd);
    }

    public void attribute(String uri, String localName, String qName, String value) throws IOException {
        if (this.node instanceof Element) {
            Attr attr = uri == null ? this.doc.createAttribute(qName) : this.doc.createAttributeNS(uri, qName);
            attr.setNodeValue(value);
            ((Element)this.node).setAttributeNode(attr);
        } else {
            ((QDocument)this.node).setAttribute(qName, value);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        this.popText();
        if (this.node != null) {
            this.node = this.node.getParentNode();
        }
    }

    public void processingInstruction(String name, String data) {
        this.popText();
        ProcessingInstruction pi = this.doc.createProcessingInstruction(name, data);
        this.node.appendChild(pi);
    }

    public void comment(char[] buf, int offset, int length) throws SAXException {
        try {
            this.comment(new String(buf, offset, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void comment(String data) throws IOException {
        this.popText();
        Comment comment = this.doc.createComment(data);
        this.node.appendChild(comment);
    }

    public boolean getEscapeText() {
        return this.escapeText;
    }

    public void setEscapeText(boolean isEscaped) {
        this.escapeText = isEscaped;
    }

    public void text(String text) throws IOException {
        if (this.singleText == null && this.text.length() == 0) {
            if (!text.equals("")) {
                this.singleText = text;
            }
        } else if (this.singleText != null) {
            this.text.append(this.singleText);
            this.text.append(text);
        } else {
            this.text.append(text);
        }
        if (!this.isCoalescing) {
            this.popText();
        }
    }

    public void text(char[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.singleText != null) {
            this.singleText = null;
            this.text.append(this.singleText);
        }
        this.text.append(buffer, offset, length);
        if (!this.isCoalescing) {
            this.popText();
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.strictXml && this.node == this.doc && this.doc.getDocumentElement() == null) {
            while (length > 0 && XmlChar.isWhitespace(buffer[offset])) {
                ++offset;
                --length;
            }
            for (int i = 0; i < length; ++i) {
                if (buffer[offset + i] != '\n' && buffer[offset + i] != '\r') continue;
                length = i;
                break;
            }
            if (length > 16) {
                length = 16;
            }
            if (length > 0) {
                throw this.error(L.l("expected top element at `{0}'", new String(buffer, offset, length)));
            }
        }
        this.text.append(buffer, offset, length);
    }

    public void ignorableWhitespace(char[] buffer, int offset, int length) throws SAXException {
        if (!this.skipWhitespace) {
            this.characters(buffer, offset, length);
        }
    }

    public void entityReference(String name) {
        this.popText();
        QEntityReference er = new QEntityReference(name);
        er.owner = this.doc;
        this.node.appendChild(er);
    }

    public void skippedEntity(String s) {
        this.text.append(s);
    }

    public void cdata(String text) throws IOException {
        this.popText();
        this.node.appendChild(this.doc.createCDATASection(text));
    }

    public void cdata(char[] buffer, int offset, int length) throws IOException {
        this.cdata(new String(buffer, offset, length));
    }

    private void popText() {
        if (this.singleText != null) {
            Text text = this.doc.createTextNode(this.singleText);
            this.node.appendChild(text);
            this.singleText = null;
            return;
        }
        if (this.text.length() == 0) {
            return;
        }
        Text text = this.doc.createTextNode(this.text.toString());
        this.text.clear();
        this.node.appendChild(text);
    }

    XmlParseException error(String text) {
        if (this.locator != null) {
            return new XmlParseException(this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ": " + text);
        }
        return new XmlParseException(text);
    }
}

