/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class QAttributedNode
extends QNode {
    QAttr firstAttribute;

    QAttributedNode() {
    }

    public NamedNodeMap getAttributes() {
        return new QAttributeMap(this);
    }

    public boolean hasAttributes() {
        return this.firstAttribute != null;
    }

    public Attr getFirstAttribute() {
        return this.firstAttribute;
    }

    public String getAttribute(String name) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            if (name.equals(attr.getNodeName())) {
                return ((QAbstractNode)attr).getNodeValue();
            }
            attr = attr.next;
        }
        return "";
    }

    public String getAttributeNS(String namespaceURI, String local) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            String attrURI = attr.getNamespaceURI();
            if (attr.getLocalName().equals(local) && (attrURI == namespaceURI || attrURI != null && !attrURI.equals(namespaceURI))) {
                return attr.getNodeValue();
            }
            attr = attr.next;
        }
        return "";
    }

    public boolean hasAttribute(String name) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            if (attr.getNodeName().equals(name)) {
                return true;
            }
            attr = attr.next;
        }
        return false;
    }

    public boolean hasAttributeNS(String namespaceURI, String local) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            if (((QAbstractNode)attr).getLocalName().equals(local) && ((QAbstractNode)attr).getNamespaceURI().equals(namespaceURI)) {
                return true;
            }
            attr = attr.next;
        }
        return false;
    }

    public Attr getAttributeNode(String name) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            if (attr.getNodeName().equals(name)) {
                return attr;
            }
            attr = attr.next;
        }
        return null;
    }

    public Attr getAttributeNodeNS(String uri, String local) {
        QAbstractNode attr = this.firstAttribute;
        while (attr != null) {
            String attrURI = ((QAbstractNode)attr).getNamespaceURI();
            if (((QAbstractNode)attr).getLocalName().equals(local) && (attrURI == uri || attrURI != null && attrURI.equals(uri))) {
                return attr;
            }
            attr = attr.next;
        }
        return null;
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        this.setAttributeNode(this.owner.createAttribute(name, value));
    }

    public void setAttributeNS(String uri, String local, String value) {
        Attr attr = this.owner.createAttributeNS(uri, local);
        attr.setNodeValue(value);
        this.setAttributeNodeNS(attr);
    }

    void setAttribute(QName name, String value) throws DOMException {
        this.setAttributeNode(this.owner.createAttribute(name, value));
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        QAttr qAttr = (QAttr)attr;
        if (qAttr.owner != this.owner) {
            throw new QDOMException(4, "attribute from wrong document");
        }
        if (qAttr.parent != null) {
            throw new QDOMException(10, "attribute `" + attr.getNodeName() + "' is in use");
        }
        qAttr.parent = this;
        QAttr old = this.unlink(attr.getNodeName());
        qAttr.next = this.firstAttribute;
        this.firstAttribute = qAttr;
        return old;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        QAttr qAttr = (QAttr)attr;
        if (qAttr.owner != this.owner) {
            throw new QDOMException(4, "attribute from wrong document");
        }
        if (qAttr.parent != null) {
            throw new QDOMException(10, "attribute `" + attr.getNodeName() + "' is in use");
        }
        QAttr old = this.unlink(qAttr.getNamespaceURI(), qAttr.getLocalName());
        qAttr.parent = this;
        qAttr.next = this.firstAttribute;
        this.firstAttribute = qAttr;
        return old;
    }

    public void removeAttribute(String name) {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        this.unlink(name);
    }

    public void removeAttributeNS(String uri, String name) {
        this.unlink(uri, name);
    }

    public Attr removeAttributeNode(Attr attr) {
        return this.unlink(attr.getNodeName());
    }

    public Attr removeAttributeNodeNS(Attr attr) {
        return this.unlink(attr.getNamespaceURI(), attr.getLocalName());
    }

    QAttr unlink(String name) {
        QAttr prev = null;
        QAttr ptr = this.firstAttribute;
        while (ptr != null && !ptr.getNodeName().equals(name)) {
            prev = ptr;
            ptr = (QAttr)ptr.next;
        }
        if (ptr == null) {
            return null;
        }
        if (prev == null) {
            this.firstAttribute = (QAttr)ptr.next;
        } else {
            prev.next = ptr.next;
        }
        ptr.next = null;
        return ptr;
    }

    public QAttr unlink(String uri, String local) {
        QAttr prev = null;
        QAttr ptr = this.firstAttribute;
        while (!(ptr == null || ptr.getLocalName().equals(local) && ptr.getNamespaceURI().equals(uri))) {
            prev = ptr;
            ptr = (QAttr)ptr.next;
        }
        if (ptr == null) {
            return null;
        }
        if (prev == null) {
            this.firstAttribute = (QAttr)ptr.next;
        } else {
            prev.next = ptr.next;
        }
        ptr.next = null;
        return ptr;
    }

    static class QAttributeMap
    implements NamedNodeMap {
        QAttributedNode elt;
        int i;
        QAttr attr;

        QAttributeMap(QAttributedNode elt) {
            this.elt = elt;
        }

        public Node getNamedItem(String name) {
            return this.elt.getAttributeNode(name);
        }

        public Node getNamedItemNS(String uri, String localName) {
            return this.elt.getAttributeNodeNS(uri, localName);
        }

        public Node setNamedItem(Node arg) throws DOMException {
            return this.elt.setAttributeNode((Attr)arg);
        }

        public Node setNamedItemNS(Node arg) {
            return this.elt.setAttributeNodeNS((Attr)arg);
        }

        public Node removeNamedItem(String name) throws DOMException {
            return this.elt.unlink(name);
        }

        public Node removeNamedItemNS(String uri, String localName) {
            return this.elt.getAttributeNodeNS(uri, localName);
        }

        public Node item(int index) {
            QAbstractNode attr = this.elt.firstAttribute;
            while (index > 0 && attr != null) {
                attr = attr.next;
                --index;
            }
            return attr;
        }

        public int getLength() {
            int length = 0;
            QAbstractNode attr = this.elt.firstAttribute;
            while (attr != null) {
                ++length;
                attr = attr.next;
            }
            return length;
        }
    }
}

