/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.vfs.Path;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttr;
import com.caucho.xml.QCdata;
import com.caucho.xml.QComment;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDOMImplementation;
import com.caucho.xml.QDeepNodeList;
import com.caucho.xml.QDocumentFragment;
import com.caucho.xml.QDocumentType;
import com.caucho.xml.QElement;
import com.caucho.xml.QEntityReference;
import com.caucho.xml.QName;
import com.caucho.xml.QProcessingInstruction;
import com.caucho.xml.QText;
import com.caucho.xml.QUnescapedText;
import com.caucho.xml.XmlPrinter;
import com.caucho.xml.XmlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class QDocument
extends QDocumentFragment
implements CauchoDocument {
    QDOMImplementation implementation;
    QDocumentType dtd;
    QElement element;
    HashMap attributes;
    String encoding = "UTF-8";
    String version;
    private HashMap namespaces;
    private HashMap nameCache = new HashMap();
    private NameKey nameKey = new NameKey();
    private ArrayList depends;
    private String _systemId;
    int changeCount;
    String rootFilename;

    public QDocument() {
        this.implementation = new QDOMImplementation();
        this.owner = this;
    }

    QDocument(QDOMImplementation impl) {
        this.implementation = impl;
        this.owner = this;
    }

    void setAttribute(String name, String value) {
        if (name.equals("version")) {
            this.version = value;
        } else if (name.equals("encoding")) {
            this.encoding = value;
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        }
    }

    public String getRootFilename() {
        return this.rootFilename;
    }

    public void setRootFilename(String filename) {
        this.rootFilename = filename;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public boolean isSupported(String feature, String version) {
        return this.owner.getImplementation().hasFeature(feature, version);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    protected Node copyNode(QDocument newNode, boolean deep) {
        newNode.dtd = this.dtd;
        newNode.element = this.element;
        return newNode;
    }

    public Node cloneNode(boolean deep) {
        QDocument newDoc = new QDocument();
        newDoc.implementation = this.implementation;
        newDoc.dtd = this.dtd;
        if (this.attributes != null) {
            newDoc.attributes = (HashMap)this.attributes.clone();
        }
        newDoc.encoding = this.encoding;
        newDoc.version = this.version;
        if (this.namespaces != null) {
            this.namespaces = (HashMap)this.namespaces.clone();
        }
        if (deep) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                newDoc.appendChild(newDoc.importNode(node, true));
            }
        }
        return newDoc;
    }

    Node importNode(QDocument doc, boolean deep) {
        return null;
    }

    public Node importNode(Node node, boolean deep) {
        return ((QAbstractNode)node).importNode(this, deep);
    }

    public DocumentType getDoctype() {
        return this.dtd;
    }

    public void setDoctype(DocumentType dtd) {
        QDocumentType qdtd;
        this.dtd = qdtd = (QDocumentType)dtd;
        if (qdtd != null) {
            qdtd.owner = this;
        }
    }

    public String getEncoding() {
        if (this.encoding == null) {
            return null;
        }
        return this.encoding;
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        return this.element;
    }

    public void setDocumentElement(Element elt) {
        this.element = (QElement)elt;
    }

    public Element createElement(String tagName) throws DOMException {
        if (!this.isNameValid(tagName)) {
            throw new QDOMException(5, "illegal tag `" + tagName + "'");
        }
        QElement elt = new QElement(this.createName(null, tagName));
        elt.owner = this;
        return elt;
    }

    public Element createElementNS(String namespaceURI, String name) throws DOMException {
        QName qname = this.createName(namespaceURI, name);
        String prefix = qname.getPrefix();
        String namespace = qname.getNamespaceURI();
        if (prefix == "xml" && namespace != "http://www.w3.org/XML/1998/namespace") {
            throw new DOMException(14, L.l("`xml' prefix expects namespace uri 'http://www.w3.org/XML/1998/namespace'"));
        }
        if (prefix != "" && namespaceURI == "") {
            throw new DOMException(14, L.l("`{0}' prefix expects a namespace uri", prefix));
        }
        if (namespace != null && namespace != "") {
            this.addNamespace(prefix, namespace);
        }
        QElement elt = new QElement(qname);
        elt.owner = this;
        return elt;
    }

    public Element createElement(String prefix, String local, String url) throws DOMException {
        QName name = new QName(prefix, local, url);
        if (url != null && !url.equals("")) {
            this.addNamespace(prefix, url);
        }
        QElement elt = new QElement(name);
        elt.owner = this;
        return elt;
    }

    public Element createElementByName(QName name) throws DOMException {
        QElement elt = new QElement(name);
        elt.owner = this;
        return elt;
    }

    public DocumentFragment createDocumentFragment() {
        QDocumentFragment frag = new QDocumentFragment();
        frag.owner = this;
        return frag;
    }

    public Text createTextNode(String data) {
        if (data == null) {
            data = "";
        }
        QText text = new QText(data);
        text.owner = this;
        return text;
    }

    public Text createUnescapedTextNode(String data) {
        if (data == null) {
            data = "";
        }
        QUnescapedText text = new QUnescapedText(data);
        text.owner = this;
        return text;
    }

    public Comment createComment(String data) {
        if (data == null) {
            data = "";
        }
        QComment comment = new QComment(data);
        comment.owner = this;
        return comment;
    }

    public CDATASection createCDATASection(String data) {
        if (data == null) {
            data = "";
        }
        QCdata cdata = new QCdata(data);
        cdata.owner = this;
        return cdata;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null || target.length() == 0) {
            throw new QDOMException(5, L.l("Empty processing instruction name.  The processing instruction syntax is: <?name ... ?>"));
        }
        if (!this.isNameValid(target)) {
            throw new QDOMException(5, L.l("`{0}' is an invalid processing instruction name.  The processing instruction syntax is: <?name ... ?>", target));
        }
        if (data == null) {
            data = "";
        }
        QProcessingInstruction pi = new QProcessingInstruction(target, data);
        pi.owner = this;
        return pi;
    }

    public Attr createAttribute(String name, String value) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal attribute `" + name + "'");
        }
        if (value == null) {
            value = "";
        }
        QAttr attr = new QAttr(new QName(null, name, null), value);
        attr.owner = this;
        return attr;
    }

    public Attr createAttribute(String name) throws DOMException {
        return this.createAttribute(name, null);
    }

    public Attr createAttribute(String prefix, String local, String url) throws DOMException {
        QName name = new QName(prefix, local, url);
        if (url != null && !url.equals("")) {
            this.addNamespace(prefix, url);
        }
        QAttr attr = new QAttr(name, null);
        attr.owner = this;
        return attr;
    }

    public Attr createAttributeNS(String uri, String qname) throws DOMException {
        QName name = this.createName(uri, qname);
        if (name.getPrefix() != "") {
            if (name.getPrefix() == "xml" && name.getNamespace() != "http://www.w3.org/XML/1998/namespace") {
                throw new DOMException(14, L.l("Invalid name `{0}' with namespace `{1}'. `xml' prefix expects namespace uri 'http://www.w3.org/XML/1998/namespace'", (Object)qname, uri));
            }
            if (name.getPrefix() == "xmlns" && name.getNamespace() != "http://www.w3.org/2000/xmlns/") {
                throw new DOMException(14, L.l("`xmlns' prefix expects namespace uri '{0}'", "http://www.w3.org/2000/xmlns/"));
            }
            if (name.getNamespace() == "") {
                throw new DOMException(14, L.l("`{0}' prefix expects a namespace uri", name.getPrefix()));
            }
        }
        if (uri != null && !uri.equals("") && uri != "http://www.w3.org/2000/xmlns/") {
            this.addNamespace(name.getPrefix(), uri);
        }
        QAttr attr = new QAttr(name, null);
        attr.owner = this;
        return attr;
    }

    public QName createName(String uri, String name) {
        String local;
        String prefix;
        int p;
        this.nameKey.init(name, uri);
        QName qName = (QName)this.nameCache.get(this.nameKey);
        if (qName != null) {
            return qName;
        }
        if (uri == null || (p = name.indexOf(58)) < 0) {
            prefix = null;
            local = name;
        } else {
            prefix = name.substring(0, p);
            local = name.substring(p + 1);
        }
        qName = new QName(prefix, local, uri);
        this.nameCache.put(new NameKey(name, uri), qName);
        return qName;
    }

    public Attr createAttribute(QName name, String value) throws DOMException {
        String url = name.getNamespace();
        if (url != null) {
            this.addNamespace(name.getPrefix(), url);
        }
        QAttr attr = new QAttr(name, value);
        attr.owner = this;
        return attr;
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        if (!this.isNameValid(name)) {
            throw new QDOMException(5, "illegal entityReference `" + name + "'");
        }
        QEntityReference er = new QEntityReference(name);
        er.owner = this;
        return er;
    }

    public NodeList getElementsByTagName(String name) {
        if (this.element == null) {
            return new QDeepNodeList(null, null, null);
        }
        return new QDeepNodeList(this.element, this.element, new QElement.TagPredicate(name));
    }

    public NodeList getElementsByTagNameNS(String uri, String name) {
        if (this.element == null) {
            return new QDeepNodeList(null, null, null);
        }
        return new QDeepNodeList(this.element, this.element, new QElement.NSTagPredicate(uri, name));
    }

    public Element getElementById(String name) {
        Node node = this.element;
        while (node != null) {
            Element elt;
            String id;
            if (node instanceof Element && name.equals(id = (elt = (Element)node).getAttribute("id"))) {
                return elt;
            }
            node = XmlUtil.getNext(node);
        }
        return null;
    }

    public static Document create() {
        QDocument doc = new QDocument();
        doc.masterDoc = doc;
        return doc;
    }

    void setAttributes(HashMap attributes) {
        this.attributes = attributes;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            this.element = (QElement)newChild;
        }
        return super.appendChild(newChild);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        Node value = super.removeChild(oldChild);
        if (oldChild == this.element) {
            this.element = null;
        }
        return value;
    }

    public void addNamespace(String prefix, String url) {
        String old;
        if (url == null || "http://www.w3.org/2000/xmlns/".equals(url) || "http://www.w3.org/XML/1998/namespace".equals(url)) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if ((old = (String)this.namespaces.get(prefix)) == null) {
            this.namespaces.put(prefix, url.intern());
        }
    }

    public HashMap getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(String prefix) {
        if (this.namespaces == null) {
            return null;
        }
        return (String)this.namespaces.get(prefix);
    }

    public Iterator getNamespaceKeys() {
        if (this.namespaces == null) {
            return null;
        }
        return this.namespaces.keySet().iterator();
    }

    public Object getProperty(String name) {
        if (name.equals("caucho.depends")) {
            return this.depends;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (name.equals("caucho.depends")) {
            this.depends = (ArrayList)value;
        }
    }

    public String getActualEncoding() {
        throw new UnsupportedOperationException();
    }

    public void setActualEncoding(String actualEncoding) {
        throw new UnsupportedOperationException();
    }

    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public boolean getStandalone() {
        throw new UnsupportedOperationException();
    }

    public void setStandalone(boolean standalone) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    public void setVersion(String version) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException();
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException();
    }

    public DOMErrorHandler getErrorHandler() {
        throw new UnsupportedOperationException();
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        throw new UnsupportedOperationException();
    }

    public String getDocumentURI() {
        throw new UnsupportedOperationException();
    }

    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException();
    }

    public Node adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void normalizeDocument() {
        throw new UnsupportedOperationException();
    }

    public boolean canSetNormalizationFeature(String name, boolean state) {
        throw new UnsupportedOperationException();
    }

    public void setNormalizationFeature(String name, boolean state) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean getNormalizationFeature(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void addDepend(Path path) {
        if (path == null) {
            return;
        }
        if (this.depends == null) {
            this.depends = new ArrayList();
        }
        if (!this.depends.contains(path)) {
            this.depends.add(path);
        }
    }

    void print(XmlPrinter os) throws IOException {
        os.startDocument(this);
        if (this.namespaces != null) {
            Iterator iter = this.namespaces.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String url = (String)this.namespaces.get(prefix);
                if (prefix.equals("")) {
                    os.attribute(null, prefix, "xmlns", url);
                    continue;
                }
                os.attribute(null, prefix, "xmlns:" + prefix, url);
            }
        }
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ((QAbstractNode)node).print(os);
            if (!os.isPretty()) continue;
            os.println();
        }
        os.endDocument();
    }

    public String toString() {
        String topElt;
        String string = topElt = this.element == null ? "XXX:top" : this.element.getNodeName();
        if (this.dtd == null) {
            return "[Document " + topElt + "]";
        }
        if (this.dtd.getPublicId() != null && this.dtd.getSystemId() != null) {
            return "[Document " + topElt + " PUBLIC '" + this.dtd.getPublicId() + "' '" + this.dtd.getSystemId() + "']";
        }
        if (this.dtd.publicId != null) {
            return "[Document " + topElt + " PUBLIC '" + this.dtd.getPublicId() + "']";
        }
        if (this.dtd.getSystemId() != null) {
            return "[Document " + topElt + " SYSTEM '" + this.dtd.getSystemId() + "']";
        }
        return "[Document " + topElt + "]";
    }

    static class NameKey {
        String qName;
        String url;

        NameKey() {
        }

        NameKey(String qName, String url) {
            this.init(qName, url);
        }

        void init(String qName, String url) {
            if (qName == null) {
                throw new NullPointerException();
            }
            if (url == null) {
                url = "";
            }
            this.qName = qName;
            this.url = url;
        }

        public int hashCode() {
            return 65521 * this.url.hashCode() + this.qName.hashCode();
        }

        public boolean equals(Object b) {
            if (!(b instanceof NameKey)) {
                return false;
            }
            NameKey key = (NameKey)b;
            return this.qName.equals(key.qName) && this.url.equals(key.url);
        }
    }
}

