/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

class QDocumentFragment
extends QNode
implements DocumentFragment {
    protected Document masterDoc;

    QDocumentFragment() {
    }

    public short getNodeType() {
        return 11;
    }

    public Document getMasterDoc() {
        return this.masterDoc;
    }

    public String getNodeName() {
        return "#document";
    }

    Node importNode(QDocument owner, boolean deep) {
        QDocumentFragment frag = new QDocumentFragment();
        frag.owner = owner;
        if (!deep) {
            return frag;
        }
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            frag.appendChild(node.cloneNode(true));
        }
        return frag;
    }

    public String getTextValue() {
        CharBuffer cb = new CharBuffer();
        QAbstractNode node = this.firstChild;
        while (node != null) {
            cb.append(node.getTextValue());
            node = node.next;
        }
        return cb.toString();
    }

    void print(XmlPrinter out) throws IOException {
        out.print("<#fragment>");
        QAbstractNode node = this.firstChild;
        while (node != null) {
            node.print(out);
            node = node.next;
        }
        out.print("</#fragment>");
    }

    public String toString() {
        if (this.firstChild == null) {
            return "[DocumentFragment]";
        }
        if (this.firstChild == this.lastChild) {
            return "[DocumentFragment " + this.firstChild.getNodeName() + "]";
        }
        return "[DocumentFragment " + this.firstChild.getNodeName() + " " + this.lastChild.getNodeName() + "]";
    }
}

