/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QDocument;
import com.caucho.xml.QNode;
import com.caucho.xml.QText;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

class QEntity
extends QNode
implements Entity {
    String name;
    String value;
    String publicId;
    String systemId;
    String ndata;
    boolean isPe;
    boolean isSpecial;

    QEntity(String name, String value) {
        this.name = name;
        this.value = value;
        this.isSpecial = true;
        if (value != null) {
            this.firstChild = new QText(value);
        }
    }

    QEntity(String name, String value, String publicId, String systemId) {
        this.name = name;
        this.value = value;
        this.systemId = systemId;
        this.publicId = publicId;
        if (value != null) {
            this.firstChild = new QText(value);
        }
    }

    public String getNodeName() {
        return this.name;
    }

    public String getTagName() {
        return this.name;
    }

    public short getNodeType() {
        return -1;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String arg) {
        this.publicId = arg;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String arg) {
        this.systemId = arg;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String arg) {
        this.value = arg;
    }

    public String getNotationName() {
        return this.ndata;
    }

    public void setNotationName(String arg) {
        this.ndata = arg;
    }

    Node importNode(QDocument owner, boolean deep) {
        QEntity entity = new QEntity(this.name, this.value, this.publicId, this.systemId);
        return entity;
    }

    public String getActualEncoding() {
        throw new UnsupportedOperationException();
    }

    public void setActualEncoding(String actualEncoding) {
        throw new UnsupportedOperationException();
    }

    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    public void setVersion(String version) {
        throw new UnsupportedOperationException();
    }

    void print(XmlPrinter out) throws IOException {
        out.print("<!ENTITY ");
        if (this.isPe) {
            out.print("% ");
        }
        out.print(this.name);
        if (this.publicId != null) {
            out.print(" PUBLIC \"");
            out.printDecl(this.publicId);
            out.print("\"");
            if (this.systemId != null) {
                out.print(" \"");
                out.printDecl(this.systemId);
                out.print("\"");
            }
            if (this.ndata != null) {
                out.print(" NDATA ");
                out.printDecl(this.ndata);
            }
        } else if (this.systemId != null) {
            out.print(" SYSTEM \"");
            out.printDecl(this.systemId);
            out.print("\"");
            if (this.ndata != null) {
                out.print(" NDATA ");
                out.printDecl(this.ndata);
            }
        } else if (this.value != null) {
            out.print(" \"");
            out.printDecl(this.value);
            out.print("\"");
        }
        out.println(">");
    }

    public String toString() {
        if (this.systemId != null) {
            return "[ENTITY " + this.name + " SYSTEM \"" + this.systemId + "\"]";
        }
        return "[ENTITY " + this.name + " \"" + this.value + "\"]";
    }
}

