/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QDOMException;
import com.caucho.xml.QDocumentFragment;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class QNode
extends QAbstractNode
implements NodeList {
    QAbstractNode firstChild;
    QAbstractNode lastChild;

    public String getNodeValue() {
        return null;
    }

    public void setNodeValue(String value) {
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getNextSibling() {
        return this.next;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        QAbstractNode qNewChild = (QAbstractNode)newChild;
        QAbstractNode qRefChild = (QAbstractNode)refChild;
        if (qNewChild.owner != this.owner && qNewChild.owner != this) {
            throw new QDOMException(4, "insertBefore new child from wrong document");
        }
        qNewChild.remove();
        if (qRefChild != null && qRefChild.parent != this) {
            throw new QDOMException(8, "insertBefore has no such child");
        }
        if (qNewChild instanceof QDocumentFragment) {
            QDocumentFragment frag = (QDocumentFragment)qNewChild;
            QAbstractNode first = frag.firstChild;
            QAbstractNode next = null;
            QAbstractNode ptr = first;
            while (ptr != null) {
                next = ptr.next;
                this.insertBefore(ptr, refChild);
                ptr = next;
            }
            return first;
        }
        qNewChild.parent = this;
        if (refChild == null) {
            if (this.firstChild == null) {
                qNewChild.previous = null;
                qNewChild.next = null;
                this.firstChild = this.lastChild = qNewChild;
            } else {
                this.lastChild.next = qNewChild;
                qNewChild.previous = this.lastChild;
                this.lastChild = qNewChild;
                qNewChild.next = null;
            }
            return qNewChild;
        }
        qNewChild.previous = qRefChild.previous;
        qNewChild.next = qRefChild;
        if (qRefChild.previous == null) {
            this.firstChild = qNewChild;
        } else {
            qRefChild.previous.next = qNewChild;
        }
        qRefChild.previous = qNewChild;
        return qNewChild;
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        QAbstractNode qNewChild = (QAbstractNode)newChild;
        QAbstractNode qRefChild = (QAbstractNode)refChild;
        if (qRefChild == null || qRefChild.parent != this) {
            throw new QDOMException(8, "ref is not child");
        }
        if (qNewChild == null || qNewChild.owner != this.owner) {
            throw new QDOMException(4, "wrong document");
        }
        if (this.owner != null) {
            ++this.owner.changeCount;
        }
        qNewChild.previous = qRefChild.previous;
        qNewChild.next = qRefChild.next;
        qNewChild.parent = this;
        if (qNewChild.previous == null) {
            this.firstChild = qNewChild;
        } else {
            qNewChild.previous.next = qNewChild;
        }
        if (qNewChild.next == null) {
            this.lastChild = qNewChild;
        } else {
            qNewChild.next.previous = qNewChild;
        }
        qRefChild.previous = null;
        qRefChild.next = null;
        qRefChild.parent = null;
        return qRefChild;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        QAbstractNode qOldChild = (QAbstractNode)oldChild;
        if (qOldChild != null && qOldChild.parent != this) {
            throw new QDOMException(8, "removeChild has no such child");
        }
        if (this.owner != null) {
            ++this.owner.changeCount;
        }
        if (qOldChild.previous == null) {
            this.firstChild = qOldChild.next;
        } else {
            qOldChild.previous.next = qOldChild.next;
        }
        if (qOldChild.next == null) {
            this.lastChild = qOldChild.previous;
        } else {
            qOldChild.next.previous = qOldChild.previous;
        }
        qOldChild.parent = null;
        qOldChild.next = null;
        qOldChild.previous = null;
        return qOldChild;
    }

    public Node appendChild(Node newNode) throws DOMException {
        QAbstractNode qNewNode = (QAbstractNode)newNode;
        if (qNewNode.owner != this.owner && qNewNode.owner != this) {
            throw new QDOMException(4, "can't appendChild from different document");
        }
        qNewNode.remove();
        if (qNewNode instanceof QDocumentFragment) {
            QDocumentFragment frag = (QDocumentFragment)qNewNode;
            QAbstractNode first = frag.firstChild;
            QAbstractNode next = null;
            QAbstractNode ptr = first;
            while (ptr != null) {
                next = ptr.next;
                this.appendChild(ptr);
                ptr = next;
            }
            return first;
        }
        qNewNode.parent = this;
        qNewNode.next = null;
        qNewNode.previous = this.lastChild;
        if (this.lastChild == null) {
            this.lastChild = qNewNode;
            this.firstChild = qNewNode;
        } else {
            this.lastChild.next = qNewNode;
            this.lastChild = qNewNode;
        }
        return qNewNode;
    }

    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    public void normalize() {
    }

    public boolean checkValid() throws Exception {
        if (!super.checkValid()) {
            throw new Exception("super bad: " + this);
        }
        if (this.firstChild != null && this.firstChild.previous != null) {
            throw new Exception("first child bad: " + this);
        }
        if (this.lastChild != null && this.lastChild.next != null) {
            throw new Exception("last child bad:" + this);
        }
        QAbstractNode ptr = this.firstChild;
        while (ptr != null) {
            if (ptr.parent != this) {
                throw new Exception("child parent bad:" + this + " " + ptr);
            }
            if (ptr.owner != this.owner && ptr.owner != this) {
                throw new Exception("child owner bad:" + this + " " + ptr + " " + ptr.owner + " " + this.owner);
            }
            if (ptr.next != null && ptr.next.previous != ptr) {
                throw new Exception("child links bad:" + this + " " + ptr);
            }
            ptr = ptr.next;
        }
        ptr = this.lastChild;
        while (ptr != null) {
            if (ptr.parent != this) {
                throw new Exception("child parent bad:" + this + " " + ptr);
            }
            if (ptr.owner != this.owner && ptr.owner != this) {
                throw new Exception("child owner bad:" + this + " " + ptr);
            }
            if (ptr.previous != null && ptr.previous.next != ptr) {
                throw new Exception("child links bad:" + this + " " + ptr);
            }
            ptr = ptr.previous;
        }
        return true;
    }

    public QAbstractNode getNextPreorder() {
        if (this.firstChild != null) {
            return this.firstChild;
        }
        if (this.next != null) {
            return this.next;
        }
        QNode ptr = this.parent;
        while (ptr != null) {
            if (ptr.next != null) {
                return ptr.next;
            }
            ptr = ptr.parent;
        }
        return null;
    }

    public boolean equals(Object arg) {
        return this == arg;
    }

    public boolean equals(Node arg, boolean deep) {
        return this == arg;
    }

    public Node item(int index) {
        QAbstractNode ptr = this.firstChild;
        while (ptr != null && index > 0) {
            ptr = ptr.next;
            --index;
        }
        return ptr;
    }

    public int getLength() {
        int index = 0;
        QAbstractNode ptr = this.firstChild;
        while (ptr != null) {
            ++index;
            ptr = ptr.next;
        }
        return index;
    }
}

