/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CharBuffer;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.ObjectVar;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FromExpr;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.NodeListIterator;
import com.caucho.xpath.pattern.SingleNodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;

public abstract class Expr {
    protected static final int CONST = 0;
    protected static final int NODE_SET = 1;
    protected static final int ID = 2;
    protected static final int OR = 3;
    protected static final int AND = 4;
    protected static final int EQ = 5;
    protected static final int NEQ = 6;
    protected static final int LT = 7;
    protected static final int LE = 8;
    protected static final int GT = 9;
    protected static final int GE = 10;
    protected static final int BOOLEAN_EQ = 11;
    protected static final int BOOLEAN_NEQ = 12;
    protected static final int NUMBER_EQ = 13;
    protected static final int NUMBER_NEQ = 14;
    protected static final int NUMBER_LT = 15;
    protected static final int NUMBER_LE = 16;
    protected static final int NUMBER_GT = 17;
    protected static final int NUMBER_GE = 18;
    protected static final int STRING_EQ = 19;
    protected static final int STRING_NEQ = 20;
    protected static final int NEG = 21;
    protected static final int ADD = 22;
    protected static final int SUB = 23;
    protected static final int MUL = 24;
    protected static final int DIV = 25;
    protected static final int QUO = 26;
    protected static final int MOD = 27;
    protected static final int TRUE = 28;
    protected static final int FALSE = 29;
    protected static final int NOT = 30;
    protected static final int BOOLEAN = 31;
    protected static final int LANG = 32;
    protected static final int NUMBER = 33;
    protected static final int SUM = 34;
    protected static final int FLOOR = 35;
    protected static final int CEILING = 36;
    protected static final int ROUND = 37;
    public static final int POSITION = 38;
    protected static final int COUNT = 39;
    protected static final int LAST = 40;
    protected static final int STRING = 41;
    protected static final int CONCAT = 42;
    protected static final int STARTS_WITH = 43;
    protected static final int CONTAINS = 44;
    protected static final int SUBSTRING = 45;
    protected static final int SUBSTRING_BEFORE = 46;
    protected static final int SUBSTRING_AFTER = 47;
    protected static final int STRING_LENGTH = 48;
    protected static final int NORMALIZE = 49;
    protected static final int TRANSLATE = 50;
    protected static final int FORMAT_NUMBER = 51;
    protected static final int LOCAL_PART = 52;
    protected static final int NAMESPACE = 53;
    protected static final int QNAME = 54;
    protected static final int GENERATE_ID = 55;
    protected static final int FUNCTION_AVAILABLE = 56;
    protected static final int SYSTEM_PROPERTY = 57;
    protected static final int IF = 58;
    protected static final int SELF = 59;
    protected static final int SELF_NAME = 60;
    protected static final int ATTRIBUTE = 61;
    protected static final int ELEMENT = 62;
    protected static final int LAST_FUN = 63;
    private AbstractPattern listContext;

    protected Expr() {
    }

    public void setListContext(AbstractPattern listContext) {
        this.listContext = listContext;
    }

    public AbstractPattern getListContext() {
        return this.listContext;
    }

    public boolean isNumber() {
        return false;
    }

    public double evalNumber(Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        double result = this.evalNumber(node, env);
        XPath.freeEnv(env);
        return result;
    }

    public abstract double evalNumber(Node var1, ExprEnvironment var2) throws XPathException;

    public boolean isBoolean() {
        return false;
    }

    public boolean evalBoolean(Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        boolean result = this.evalBoolean(node, env);
        XPath.freeEnv(env);
        return result;
    }

    public abstract boolean evalBoolean(Node var1, ExprEnvironment var2) throws XPathException;

    public String evalString(Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        String result = this.evalString(node, env);
        XPath.freeEnv(env);
        return result;
    }

    public boolean isString() {
        return false;
    }

    public abstract String evalString(Node var1, ExprEnvironment var2) throws XPathException;

    public void evalString(CharBuffer cb, Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        this.evalString(cb, node, env);
        XPath.freeEnv(env);
    }

    public void evalString(CharBuffer cb, Node node, ExprEnvironment env) throws XPathException {
        cb.append(this.evalString(node, env));
    }

    public boolean isNodeSet() {
        return false;
    }

    public NodeIterator evalNodeSet(Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        NodeIterator result = this.evalNodeSet(node, env);
        XPath.freeEnv(env);
        return result;
    }

    public NodeIterator evalNodeSet(Node node, ExprEnvironment env) throws XPathException {
        Object obj = this.evalObject(node, env);
        if (obj instanceof ArrayList) {
            return new NodeListIterator(env, (ArrayList)obj);
        }
        if (obj instanceof Node) {
            return new SingleNodeIterator(env, (Node)obj);
        }
        if (obj instanceof NodeIterator) {
            return (NodeIterator)obj;
        }
        return new SingleNodeIterator(env, null);
    }

    public Object evalObject(Node node) throws XPathException {
        Env env = XPath.createEnv();
        env.setCurrentNode(node);
        env.setContextNode(node);
        Object result = this.evalObject(node, env);
        XPath.freeEnv(env);
        return result;
    }

    public abstract Object evalObject(Node var1, ExprEnvironment var2) throws XPathException;

    public Var evalVar(Node node, ExprEnvironment env) throws XPathException {
        Object obj = this.evalObject(node, env);
        return new ObjectVar(obj);
    }

    public void addVar(Env newEnv, String name, Node node, Env env) throws XPathException {
        Var var = this.evalVar(node, env);
        newEnv.addVar(name, var);
    }

    public void setVar(String name, Node node, Env env) throws XPathException {
        env.setVar(name, this.evalVar(node, env));
    }

    public void addParam(Env newEnv, String name, Node node, Env env) throws XPathException {
        Var var = env.getVar(name);
        if (var == null) {
            newEnv.addVar(name, this.evalVar(node, env));
        } else {
            newEnv.addVar(name, var);
        }
    }

    public static boolean toBoolean(Object value) throws XPathException {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            return list.size() > 0;
        }
        if (value instanceof Iterator) {
            return ((Iterator)value).hasNext();
        }
        if (value instanceof Node) {
            value = XmlUtil.textValue((Node)value);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d != 0.0;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string != null && string.length() > 0;
        }
        return true;
    }

    public static double toDouble(Object value) throws XPathException {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            value = list.size() > 0 ? list.get(0) : null;
        } else if (value instanceof NodeIterator) {
            value = ((NodeIterator)value).nextNode();
        }
        if (value instanceof Node) {
            value = XmlUtil.textValue((Node)value);
        }
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            Number d = (Number)value;
            return d.doubleValue();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Expr.stringToNumber((String)value);
        }
        return 0.0;
    }

    public static String toString(Object value) throws XPathException {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            value = list.size() > 0 ? list.get(0) : null;
        } else if (value instanceof Iterator) {
            value = ((Iterator)value).next();
        }
        if (value instanceof Node) {
            value = XmlUtil.textValue((Node)value);
        } else if (value instanceof Double) {
            double d = (Double)value;
            if ((double)((int)d) == d) {
                return String.valueOf((int)d);
            }
            return String.valueOf(d);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static Node toNode(Object value) throws XPathException {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            value = list.size() > 0 ? list.get(0) : null;
        } else if (value instanceof NodeIterator) {
            value = ((NodeIterator)value).nextNode();
        }
        if (value instanceof Node) {
            return (Node)value;
        }
        return null;
    }

    protected static double stringToNumber(String string) throws XPathException {
        int i;
        int length = string.length();
        boolean isNumber = false;
        for (i = 0; i < length && XmlChar.isWhitespace(string.charAt(i)); ++i) {
        }
        if (i >= length) {
            return 0.0;
        }
        char ch = string.charAt(i);
        int sign = 1;
        if (ch == '-') {
            sign = -1;
            ++i;
            while (i < length && XmlChar.isWhitespace(string.charAt(i))) {
                ++i;
            }
        }
        double value = 0.0;
        double exp = 1.0;
        while (i < length && (ch = string.charAt(i)) >= '0' && ch <= '9') {
            value = 10.0 * value + (double)ch - 48.0;
            isNumber = true;
            ++i;
        }
        if (ch == '.') {
            ++i;
            while (i < length && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                value = 10.0 * value + (double)ch - 48.0;
                isNumber = true;
                exp = 10.0 * exp;
                ++i;
            }
        }
        double pexp = 1.0;
        if (ch == 'e' || ch == 'E') {
            int eSign = 1;
            if (++i >= length) {
                return Double.NaN;
            }
            if (string.charAt(i) == '-') {
                eSign = -1;
                ++i;
            } else if (string.charAt(i) == '+') {
                ++i;
            }
            int v = 0;
            while (i < length && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                v = v * 10 + ch - 48;
                ++i;
            }
            pexp = Math.pow(10.0, eSign * v);
        }
        while (i < length && XmlChar.isWhitespace(string.charAt(i))) {
            ++i;
        }
        if (i < length || !isNumber) {
            return Double.NaN;
        }
        return (double)sign * value * pexp / exp;
    }

    protected AbstractPattern toNodeList() {
        return new FromExpr(null, this);
    }
}

