/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPathParseException;
import com.caucho.xpath.expr.BooleanExpr;
import com.caucho.xpath.expr.FunExpr;
import com.caucho.xpath.expr.IdExpr;
import com.caucho.xpath.expr.NewJavaExpr;
import com.caucho.xpath.expr.NodeSetExpr;
import com.caucho.xpath.expr.NumericExpr;
import com.caucho.xpath.expr.ObjectExpr;
import com.caucho.xpath.expr.ObjectJavaExpr;
import com.caucho.xpath.expr.StaticJavaExpr;
import com.caucho.xpath.expr.StringExpr;
import com.caucho.xpath.expr.VarExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.CurrentPattern;
import com.caucho.xpath.pattern.FilterPattern;
import com.caucho.xpath.pattern.FromAncestors;
import com.caucho.xpath.pattern.FromAny;
import com.caucho.xpath.pattern.FromAttributes;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromDescendants;
import com.caucho.xpath.pattern.FromExpr;
import com.caucho.xpath.pattern.FromNamespace;
import com.caucho.xpath.pattern.FromNext;
import com.caucho.xpath.pattern.FromNextSibling;
import com.caucho.xpath.pattern.FromParent;
import com.caucho.xpath.pattern.FromPrevious;
import com.caucho.xpath.pattern.FromPreviousSibling;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.FromSelf;
import com.caucho.xpath.pattern.NSNamePattern;
import com.caucho.xpath.pattern.NamespacePattern;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xpath.pattern.UnionPattern;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

class XPathParser {
    private static WriteStream dbg = LogStream.open("/caucho.com/xpath/parser");
    private static L10N L = new L10N("/com/caucho/xpath/messages");
    private static final int ANCESTOR_AXIS = 0;
    private static final int ANCESTOR_OR_SELF_AXIS = 1;
    private static final int ATTRIBUTE_AXIS = 2;
    private static final int CHILD_AXIS = 3;
    private static final int DESCENDANT_AXIS = 4;
    private static final int DESCENDANT_OR_SELF_AXIS = 5;
    private static final int FOLLOWING_AXIS = 6;
    private static final int FOLLOWING_SIBLING_AXIS = 7;
    private static final int NAMESPACE_AXIS = 8;
    private static final int PARENT_AXIS = 9;
    private static final int PRECEDING_AXIS = 10;
    private static final int PRECEDING_SIBLING_AXIS = 11;
    private static final int SELF_AXIS = 12;
    private static final int TEXT = 64;
    private static final int COMMENT = 65;
    private static final int ER = 66;
    private static final int PI = 67;
    private static final int NODE = 68;
    private static final int CURRENT = 69;
    private static final int NODE_TEXT = 70;
    private static final int CONTEXT = 71;
    private static IntMap exprFunctions = new IntMap();
    private static IntMap axisMap;
    private CharBuffer tag = new CharBuffer();
    private String string;
    private int index;
    private int peek;
    private NamespaceContext namespace;

    XPathParser(String string, NamespaceContext namespace) {
        this.string = string;
        this.namespace = namespace;
    }

    AbstractPattern parseSelect() throws XPathParseException {
        FromContext top = new FromContext();
        AbstractPattern pattern = this.parseUnion(this.parseTop(top), top);
        if (this.index < this.string.length()) {
            throw new XPathParseException(L.l("unexpected character at `{0}'", this.badChar(this.read())));
        }
        return pattern;
    }

    AbstractPattern parseMatch() throws XPathParseException {
        FromAny root = new FromAny();
        AbstractPattern pattern = this.parseUnion(this.parseTop(root), root);
        if (this.index < this.string.length()) {
            throw new XPathParseException(L.l("unexpected character at `{0}'", this.badChar(this.read())));
        }
        return pattern;
    }

    Expr parseExpr() throws XPathParseException {
        Expr expr = this.parseExpr(null, null);
        if (this.index < this.string.length()) {
            throw new XPathParseException(L.l("unexpected character at `{0}'", this.badChar(this.read())));
        }
        return expr;
    }

    private AbstractPattern parseStep(AbstractPattern root) throws XPathParseException {
        return this.parseUnion(this.parseTop(root), root);
    }

    private AbstractPattern parseUnion(AbstractPattern left, AbstractPattern root) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        while (ch >= 0 && ch == 124) {
            AbstractPattern tail = this.parseUnion(this.parseTop(root), root);
            left = new UnionPattern(left, tail);
            ch = this.read();
            while (XmlChar.isWhitespace(ch)) {
                ch = this.read();
            }
        }
        this.unread();
        return left;
    }

    private AbstractPattern parseTop(AbstractPattern pattern) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        this.unread();
        if (ch == 40) {
            AbstractPattern nodeSet;
            Expr expr = this.parseTerm(pattern, pattern);
            if (expr instanceof NodeSetExpr && (nodeSet = ((NodeSetExpr)expr).getPattern()).isAscending()) {
                return nodeSet;
            }
            return new FromExpr(null, expr);
        }
        return this.parseTerm(pattern, pattern).toNodeList();
    }

    private AbstractPattern parseBasisTop(AbstractPattern pattern) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        if (ch == 47) {
            ch = this.read();
            if (ch == 47) {
                pattern = new FromRoot();
                pattern = new FromDescendants(pattern, false);
                pattern = this.parseBasis(pattern);
                pattern = this.parseFilter(pattern);
                pattern = this.parsePath(pattern);
                return pattern;
            }
            pattern = new FromRoot();
            if ((ch = this.skipWhitespace(ch)) == -1) {
                return pattern;
            }
        }
        this.unread();
        if (pattern == null) {
            pattern = new FromContext();
        }
        pattern = this.parseBasis(pattern);
        pattern = this.parseFilter(pattern);
        return this.parsePath(pattern);
    }

    private AbstractPattern parsePath(AbstractPattern pattern) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        while (ch == 47) {
            ch = this.read();
            if (ch == 47) {
                pattern = new FromDescendants(pattern, false);
                pattern = this.parseBasis(pattern);
                pattern = this.parseFilter(pattern);
            } else {
                this.unread();
                pattern = this.parseBasis(pattern);
                pattern = this.parseFilter(pattern);
            }
            ch = this.skipWhitespace(this.read());
        }
        this.unread();
        return pattern;
    }

    private AbstractPattern parseFilter(AbstractPattern pattern) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        while (ch == 91) {
            FromContext context = new FromContext();
            Expr expr = this.parseExpr(context, pattern);
            pattern = new FilterPattern(pattern, expr);
            ch = this.skipWhitespace(this.read());
            if (ch != 93) {
                throw this.error(L.l("expected `{0}' at {1}", (Object)"]", this.badChar(ch)));
            }
            ch = this.skipWhitespace(this.read());
        }
        this.unread();
        return pattern;
    }

    private AbstractPattern parseBasis(AbstractPattern pattern) throws XPathParseException {
        boolean fromChildren = true;
        int ch = this.skipWhitespace(this.read());
        int nodeType = 1;
        Object namespace = null;
        this.tag.clear();
        if (ch == 64) {
            if (pattern instanceof FromDescendants) {
                pattern = NodeTypePattern.create(pattern, -2);
            }
            pattern = new FromAttributes(pattern);
            nodeType = 2;
            fromChildren = false;
            ch = this.read();
        } else {
            if (ch == 46) {
                ch = this.read();
                if (ch == 46) {
                    return NodeTypePattern.create(new FromParent(pattern), -2);
                }
                this.unread();
                if (pattern != null) {
                    return pattern;
                }
                return NodeTypePattern.create(new FromSelf(pattern), -1);
            }
            if (ch == 40) {
                Expr expr = this.parseExpr(null, null);
                ch = this.read();
                if (ch != 41) {
                    throw this.error(L.l("expected `{0}' at {1}", (Object)")", this.badChar(ch)));
                }
                return new FromExpr(pattern, expr);
            }
        }
        if (ch == 42) {
            this.tag.append('*');
        } else if (XmlChar.isNameStart(ch)) {
            while (XmlChar.isNameChar(ch)) {
                this.tag.append((char)ch);
                ch = this.read();
            }
            if (ch == 42 && this.tag.endsWith(":")) {
                this.tag.append('*');
            } else {
                this.unread();
            }
        } else {
            this.unread();
        }
        String name = this.tag.toString();
        if (name.equals("")) {
            throw this.error(L.l("expected name at {0}", this.badChar(ch)));
        }
        return this.parseAxis(pattern, name, fromChildren, nodeType);
    }

    private AbstractPattern parseAxis(AbstractPattern pattern, String name, boolean fromChildren, int nodeType) throws XPathParseException {
        String axis = "";
        int axisIndex = name.indexOf("::");
        if (axisIndex >= 0 && nodeType != 2) {
            axis = name.substring(0, axisIndex);
            name = name.substring(axisIndex + 2);
        }
        if (pattern instanceof FromDescendants) {
            return this.parseNodeTest(pattern, name, false, 1);
        }
        switch (axisMap.get(axis)) {
            case 0: {
                return this.parseNodeTest(new FromAncestors(pattern, false), name, false, 1);
            }
            case 1: {
                return this.parseNodeTest(new FromAncestors(pattern, true), name, false, 1);
            }
            case 2: {
                return this.parseNodeTest(new FromAttributes(pattern), name, false, 2);
            }
            case 3: {
                return this.parseNodeTest(new FromChildren(pattern), name, false, 1);
            }
            case 4: {
                return this.parseNodeTest(new FromDescendants(pattern, false), name, false, 1);
            }
            case 5: {
                return this.parseNodeTest(new FromDescendants(pattern, true), name, false, 1);
            }
            case 6: {
                return this.parseNodeTest(new FromNext(pattern), name, false, 1);
            }
            case 7: {
                return this.parseNodeTest(new FromNextSibling(pattern), name, false, 1);
            }
            case 8: {
                return this.parseNodeTest(new FromNamespace(pattern), name, false, 2);
            }
            case 9: {
                return this.parseNodeTest(new FromParent(pattern), name, false, 1);
            }
            case 10: {
                return this.parseNodeTest(new FromPrevious(pattern), name, false, 1);
            }
            case 11: {
                return this.parseNodeTest(new FromPreviousSibling(pattern), name, false, 1);
            }
            case 12: {
                return this.parseNodeTest(new FromSelf(pattern), name, false, 1);
            }
        }
        return this.parseNodeTest(pattern, name, fromChildren, nodeType);
    }

    private AbstractPattern parseNodeTest(AbstractPattern pattern, String name, boolean fromChildren, int nodeType) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        if (ch == 40) {
            Expr expr = this.parseFunction(pattern, pattern, name, fromChildren);
            return expr.toNodeList();
        }
        if (ch == 123) {
            this.tag.clear();
            while ((ch = this.read()) >= 0 && ch != 125) {
                this.tag.append((char)ch);
            }
            String url = this.tag.toString();
            this.tag.clear();
            ch = this.read();
            while (XmlChar.isNameChar(ch)) {
                this.tag.append((char)ch);
                ch = this.read();
            }
            pattern = new NSNamePattern(pattern, url, this.tag.toString(), nodeType);
        } else {
            if (fromChildren) {
                pattern = new FromChildren(pattern);
            }
            if (name.equals("*")) {
                pattern = NodeTypePattern.create(pattern, nodeType);
            } else if (name.endsWith(":*")) {
                pattern = new NamespacePattern(pattern, name.substring(0, name.length() - 2), nodeType);
            } else {
                int p = name.indexOf(58);
                String ns = null;
                String local = name;
                if (p > 0) {
                    String prefix = name.substring(0, p);
                    ns = NamespaceContext.find(this.namespace, prefix);
                    local = name.substring(p + 1);
                } else {
                    ns = NamespaceContext.find(this.namespace, "");
                }
                pattern = ns == null ? new NodePattern(pattern, name, nodeType) : new NSNamePattern(pattern, ns, local, nodeType);
            }
        }
        this.unread();
        return pattern;
    }

    Expr parseExpr(AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        this.peek = -1;
        Expr left = this.parseTerm(parent, listParent);
        block7: while (true) {
            int token = this.scanToken();
            switch (token) {
                case 3: {
                    left = this.parseOrExpr(token, left, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 4: {
                    left = this.parseAndExpr(token, left, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    left = this.parseCmpExpr(token, left, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 22: 
                case 23: {
                    left = this.parseAddExpr(token, left, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    left = this.parseMulExpr(token, left, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
            }
            break;
        }
        return left;
    }

    private Expr parseOrExpr(int code, Expr left, Expr right, AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int token;
        block7: while (true) {
            token = this.scanToken();
            switch (token) {
                case 3: {
                    left = new BooleanExpr(code, left, right);
                    code = token;
                    right = this.parseTerm(parent, listParent);
                    continue block7;
                }
                case 4: {
                    right = this.parseAndExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    right = this.parseCmpExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 22: 
                case 23: {
                    right = this.parseAddExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    right = this.parseMulExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block7;
                }
            }
            break;
        }
        this.undoToken(token);
        return new BooleanExpr(code, left, right);
    }

    private Expr parseAndExpr(int code, Expr left, Expr right, AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int token;
        block6: while (true) {
            token = this.scanToken();
            switch (token) {
                case 4: {
                    left = new BooleanExpr(code, left, right);
                    code = token;
                    right = this.parseTerm(parent, listParent);
                    continue block6;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    right = this.parseCmpExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block6;
                }
                case 22: 
                case 23: {
                    right = this.parseAddExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block6;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    right = this.parseMulExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block6;
                }
            }
            break;
        }
        this.undoToken(token);
        return new BooleanExpr(code, left, right);
    }

    private Expr parseCmpExpr(int code, Expr left, Expr right, AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int token;
        block5: while (true) {
            token = this.scanToken();
            switch (token) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    left = new BooleanExpr(code, left, right);
                    code = token;
                    right = this.parseTerm(parent, listParent);
                    continue block5;
                }
                case 22: 
                case 23: {
                    right = this.parseAddExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block5;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    right = this.parseMulExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block5;
                }
            }
            break;
        }
        this.undoToken(token);
        return new BooleanExpr(code, left, right);
    }

    private Expr parseAddExpr(int code, Expr left, Expr right, AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int token;
        block4: while (true) {
            token = this.scanToken();
            switch (token) {
                case 22: 
                case 23: {
                    left = new NumericExpr(code, left, right);
                    code = token;
                    right = this.parseTerm(parent, listParent);
                    continue block4;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    right = this.parseMulExpr(token, right, this.parseTerm(parent, listParent), parent, listParent);
                    continue block4;
                }
            }
            break;
        }
        this.undoToken(token);
        return new NumericExpr(code, left, right);
    }

    private Expr parseMulExpr(int code, Expr left, Expr right, AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int token;
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    left = new NumericExpr(code, left, right);
                    code = token;
                    right = this.parseTerm(parent, listParent);
                    continue block3;
                }
            }
            break;
        }
        this.undoToken(token);
        return new NumericExpr(code, left, right);
    }

    private Expr parseTerm(AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        int ch = this.skipWhitespace(this.read());
        this.unread();
        Expr expr = this.parseSimpleTerm(parent, listParent);
        int nextCh = this.skipWhitespace(this.read());
        this.unread();
        if (nextCh == 47 || nextCh == 91) {
            AbstractPattern pattern = expr.toNodeList();
            if (ch == 40 && !pattern.isStrictlyAscending()) {
                pattern = new FromExpr(null, expr);
            }
            return NodeSetExpr.create(this.parseUnion(this.parsePath(this.parseFilter(pattern)), pattern));
        }
        if (nextCh == 124) {
            AbstractPattern pattern = expr.toNodeList();
            return NodeSetExpr.create(this.parseUnion(this.parsePath(this.parseFilter(pattern)), listParent));
        }
        return expr;
    }

    private Expr parseSimpleTerm(AbstractPattern parent, AbstractPattern listParent) throws XPathParseException {
        String axis;
        int ch = this.read();
        ch = this.skipWhitespace(ch);
        switch (ch) {
            case 46: {
                ch = this.read();
                this.unread();
                this.unread();
                if (ch < 48 || ch > 57) {
                    return NodeSetExpr.create(this.parseUnion(this.parseBasisTop(parent), parent));
                }
                ch = 46;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                long value = 0L;
                double exp = 1.0;
                int digits = 0;
                while (ch >= 48 && ch <= 57) {
                    value = 10L * value + (long)ch - 48L;
                    ch = this.read();
                }
                if (ch == 46) {
                    ch = this.read();
                    while (ch >= 48 && ch <= 57) {
                        value = 10L * value + (long)ch - 48L;
                        exp *= 10.0;
                        --digits;
                        ch = this.read();
                    }
                }
                if (ch == 101 || ch == 69) {
                    int sign = 1;
                    int expValue = 0;
                    ch = this.read();
                    if (ch == 45) {
                        sign = -1;
                        ch = this.read();
                    } else if (ch == 43) {
                        ch = this.read();
                    }
                    while (ch >= 48 && ch <= 57) {
                        expValue = 10 * expValue + ch - 48;
                        ch = this.read();
                    }
                    exp = Math.pow(10.0, digits + sign * expValue);
                    this.unread();
                    return new NumericExpr((double)value * exp);
                }
                this.unread();
                return new NumericExpr((double)value / exp);
            }
            case 45: {
                return new NumericExpr(21, this.parseTerm(parent, listParent));
            }
            case 43: {
                return this.parseTerm(parent, listParent);
            }
            case 40: {
                Expr expr = this.parseExpr(parent, listParent);
                ch = this.skipWhitespace(this.read());
                if (ch != 41) {
                    throw this.error(L.l("expected `{0}' at {1}", (Object)")", this.badChar(ch)));
                }
                return expr;
            }
            case 42: 
            case 47: 
            case 64: {
                this.unread();
                return NodeSetExpr.create(this.parseUnion(this.parseBasisTop(parent), parent));
            }
            case 34: 
            case 39: {
                int end = ch;
                CharBuffer cb = new CharBuffer();
                ch = this.read();
                while (ch >= 0) {
                    if (ch != end) {
                        cb.append((char)ch);
                    } else {
                        ch = this.read();
                        if (ch == end) {
                            cb.append((char)ch);
                        } else {
                            this.unread();
                            break;
                        }
                    }
                    ch = this.read();
                }
                return new StringExpr(cb.toString());
            }
            case 36: {
                String name = this.readName(this.read());
                return new VarExpr(name);
            }
        }
        if (!XmlChar.isNameStart(ch)) {
            throw this.error(L.l("unknown character at {0}", this.badChar(ch)));
        }
        String name = this.readName(ch);
        ch = this.skipWhitespace(this.read());
        int axisIndex = name.indexOf("::");
        if (ch == 40 && axisIndex < 0) {
            return this.parseFunction(parent, listParent, name, true);
        }
        if (ch == 40 && axisMap.get(axis = name.substring(0, axisIndex)) <= 0) {
            return this.parseFunction(parent, listParent, name, true);
        }
        this.unread();
        if (parent == null) {
            parent = new FromContext();
        }
        return this.parseNodeSetExpr(parent, name, 1);
    }

    Expr parseFunction(AbstractPattern parent, AbstractPattern listParent, String name, boolean fromChildren) throws XPathParseException {
        String prefix;
        String context;
        int ch = this.skipWhitespace(this.read());
        ArrayList<Expr> args = new ArrayList<Expr>();
        while (ch >= 0 && ch != 41) {
            Expr expr;
            if (ch != 44) {
                this.unread();
            }
            if ((expr = this.parseExpr(parent, listParent)) == null) {
                throw this.error(L.l("null expression"));
            }
            args.add(expr);
            ch = this.skipWhitespace(this.read());
        }
        int code = exprFunctions.get(name);
        switch (code) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 43: 
            case 44: 
            case 56: {
                return new BooleanExpr(code, args);
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 48: {
                return new NumericExpr(code, args);
            }
            case 38: 
            case 40: {
                return new NumericExpr(code, listParent);
            }
            case 34: 
            case 39: {
                if (args.size() == 0) {
                    args.add(NodeSetExpr.create(new FromContext()));
                }
                return new NumericExpr(code, ((Expr)args.get(0)).toNodeList());
            }
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 57: {
                return new StringExpr(code, args);
            }
            case 41: 
            case 49: {
                return new StringExpr(code, args);
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (args.size() == 0) {
                    args.add(NodeSetExpr.create(new FromContext()));
                }
                return new StringExpr(code, args);
            }
            case 2: {
                if (args.size() == 0) {
                    args.add(NodeSetExpr.create(parent));
                    return new IdExpr(args);
                }
                return new IdExpr(args);
            }
            case 58: {
                if (args.size() != 3) {
                    throw this.error(L.l("`if' needs three args."));
                }
                return new ObjectExpr(code, args);
            }
            case 64: {
                if (fromChildren) {
                    parent = new FromChildren(parent);
                }
                AbstractPattern pattern = NodeTypePattern.create(parent, 3);
                return NodeSetExpr.create(pattern);
            }
            case 65: {
                if (fromChildren) {
                    parent = new FromChildren(parent);
                }
                AbstractPattern pattern = NodeTypePattern.create(parent, 8);
                return NodeSetExpr.create(pattern);
            }
            case 66: {
                if (fromChildren) {
                    parent = new FromChildren(parent);
                }
                AbstractPattern pattern = NodeTypePattern.create(parent, 5);
                return NodeSetExpr.create(pattern);
            }
            case 67: {
                AbstractPattern pattern;
                if (fromChildren) {
                    parent = new FromChildren(parent);
                }
                if (args.size() == 1) {
                    Expr expr = (Expr)args.get(0);
                    String value = null;
                    if (expr instanceof StringExpr) {
                        value = ((StringExpr)expr).getValue();
                    }
                    if (value == null) {
                        throw this.error(L.l("processing-instruction expects string literal"));
                    }
                    pattern = new NodePattern(parent, value, 7);
                } else {
                    pattern = NodeTypePattern.create(parent, 7);
                }
                return NodeSetExpr.create(pattern);
            }
            case 68: {
                if (fromChildren) {
                    parent = new FromChildren(parent);
                }
                AbstractPattern pattern = NodeTypePattern.create(parent, -2);
                return NodeSetExpr.create(pattern);
            }
            case 69: {
                return NodeSetExpr.create(new CurrentPattern());
            }
            case 71: {
                return NodeSetExpr.create(new FromContext());
            }
        }
        int p = name.lastIndexOf(58);
        if (p > 0 && (context = NamespaceContext.find(this.namespace, prefix = name.substring(0, p))) != null) {
            if (context.startsWith("java:")) {
                name = context + "." + name.substring(p + 1);
            } else if (context.indexOf(58) < 0) {
                name = "java:" + context + "." + name.substring(p + 1);
            }
        }
        if (name.startsWith("java:")) {
            int i;
            Class cl;
            p = name.lastIndexOf(46);
            if (p < 0) {
                throw this.error(L.l("`{0}' is an illegal extension function.  Java extension functions must look like java:mypkg.MyClass.mymethod.", name));
            }
            String className = name.substring(5, p);
            String methodName = name.substring(p + 1);
            try {
                cl = CauchoSystem.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw this.error(L.l("`{0}' is an unknown Java class.  Java extension functions must use public classes.", className));
            }
            if (methodName.equals("new")) {
                Constructor<?>[] constructors = cl.getConstructors();
                for (int i2 = 0; i2 < constructors.length; ++i2) {
                    if (constructors[i2].getParameterTypes().length != args.size()) continue;
                    return new NewJavaExpr(constructors[i2], args);
                }
                throw this.error(L.l("No matching public constructor in `{0}'", className));
            }
            Method method = null;
            Method[] methods = cl.getMethods();
            if (args.size() > 0) {
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != args.size() - 1 || Modifier.isStatic(methods[i].getModifiers())) continue;
                    Expr objArg = (Expr)args.remove(0);
                    return new ObjectJavaExpr(methods[i], objArg, args);
                }
            }
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != args.size()) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                throw this.error(L.l("`{0}' does not match a public method in `{1}'", (Object)methodName, className));
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw this.error(L.l("`{0}' is not a static method in `{1}'", (Object)methodName, className));
            }
            return new StaticJavaExpr(method, args);
        }
        if (name.equals("")) {
            throw this.error(L.l("expected node-test at `{0}'", "("));
        }
        return new FunExpr(name, parent, args);
    }

    private Expr parseNodeSetExpr(AbstractPattern parent, String name, int nodeType) throws XPathParseException {
        AbstractPattern top = this.parseAxis(parent, name, true, nodeType);
        top = this.parseFilter(top);
        return NodeSetExpr.create(this.parseUnion(this.parsePath(top), parent));
    }

    private int scanToken() throws XPathParseException {
        if (this.peek >= 0) {
            int value = this.peek;
            this.peek = -1;
            return value;
        }
        int ch = this.skipWhitespace(this.read());
        switch (ch) {
            case 43: {
                return 22;
            }
            case 45: {
                return 23;
            }
            case 42: {
                return 24;
            }
            case 61: {
                return 5;
            }
            case 33: {
                ch = this.read();
                if (ch == 61) {
                    return 6;
                }
                throw this.error(L.l("expected `{0}' at {1}", (Object)"=", this.badChar(ch)));
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 8;
                }
                this.unread();
                return 7;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 10;
                }
                this.unread();
                return 9;
            }
        }
        if (XmlChar.isNameStart(ch)) {
            String name = this.readName(ch);
            if (name.equals("div")) {
                return 25;
            }
            if (name.equals("quo")) {
                return 26;
            }
            if (name.equals("mod")) {
                return 27;
            }
            if (name.equals("and")) {
                return 4;
            }
            if (name.equals("or")) {
                return 3;
            }
            throw this.error(L.l("expected binary operation at `{0}'", name));
        }
        this.unread();
        return -1;
    }

    private String readName(int ch) {
        this.tag.clear();
        while (XmlChar.isNameChar(ch)) {
            this.tag.append((char)ch);
            ch = this.read();
        }
        if (ch == 42 && this.tag.endsWith(":")) {
            this.tag.append((char)ch);
        } else {
            this.unread();
        }
        return this.tag.toString();
    }

    private void undoToken(int token) {
        this.peek = token;
    }

    private int read() {
        if (this.index < this.string.length()) {
            return this.string.charAt(this.index++);
        }
        ++this.index;
        return -1;
    }

    private void unread() {
        --this.index;
    }

    private XPathParseException error(String message) {
        return new XPathParseException(message + " in " + this.string);
    }

    private String badChar(int ch) {
        if (ch < 0) {
            return L.l("end of file");
        }
        if (ch == 10) {
            return L.l("end of line");
        }
        return "`" + (char)ch + "'";
    }

    private int skipWhitespace(int ch) throws XPathParseException {
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        return ch;
    }

    static {
        exprFunctions.put("id", 2);
        exprFunctions.put("true", 28);
        exprFunctions.put("false", 29);
        exprFunctions.put("not", 30);
        exprFunctions.put("boolean", 31);
        exprFunctions.put("starts-with", 43);
        exprFunctions.put("contains", 44);
        exprFunctions.put("lang", 32);
        exprFunctions.put("number", 33);
        exprFunctions.put("sum", 34);
        exprFunctions.put("floor", 35);
        exprFunctions.put("ceiling", 36);
        exprFunctions.put("round", 37);
        exprFunctions.put("position", 38);
        exprFunctions.put("count", 39);
        exprFunctions.put("last", 40);
        exprFunctions.put("string-length", 48);
        exprFunctions.put("string", 41);
        exprFunctions.put("concat", 42);
        exprFunctions.put("substring", 45);
        exprFunctions.put("substring-before", 46);
        exprFunctions.put("substring-after", 47);
        exprFunctions.put("normalize-space", 49);
        exprFunctions.put("translate", 50);
        exprFunctions.put("local-name", 52);
        exprFunctions.put("local-part", 52);
        exprFunctions.put("namespace-uri", 53);
        exprFunctions.put("name", 54);
        exprFunctions.put("generate-id", 55);
        exprFunctions.put("if", 58);
        exprFunctions.put("text", 64);
        exprFunctions.put("comment", 65);
        exprFunctions.put("er", 66);
        exprFunctions.put("entity-reference", 66);
        exprFunctions.put("pi", 67);
        exprFunctions.put("processing-instruction", 67);
        exprFunctions.put("node", 68);
        exprFunctions.put("current", 69);
        exprFunctions.put("context", 71);
        axisMap = new IntMap();
        axisMap.put("ancestor", 0);
        axisMap.put("ancestor-or-self", 1);
        axisMap.put("attribute", 2);
        axisMap.put("child", 3);
        axisMap.put("descendant", 4);
        axisMap.put("descendant-or-self", 5);
        axisMap.put("following", 6);
        axisMap.put("following-sibling", 7);
        axisMap.put("namespace", 8);
        axisMap.put("parent", 9);
        axisMap.put("preceding", 10);
        axisMap.put("preceding-sibling", 11);
        axisMap.put("self", 12);
    }
}

