/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class NewJavaExpr
extends Expr {
    private static final int J_BOOLEAN = 1;
    private static final int J_BYTE = 2;
    private static final int J_SHORT = 3;
    private static final int J_INT = 4;
    private static final int J_LONG = 5;
    private static final int J_FLOAT = 6;
    private static final int J_DOUBLE = 7;
    private static final int J_STRING = 8;
    private static final int J_OBJECT = 9;
    private Constructor constructor;
    private ArrayList args;
    private int[] argTypes;
    private int retType;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public NewJavaExpr(Constructor constructor, ArrayList args) {
        this.constructor = constructor;
        this.args = args;
        this.argTypes = new int[args.size()];
        Class<?>[] paramClasses = constructor.getParameterTypes();
        for (int i = 0; i < paramClasses.length; ++i) {
            this.argTypes[i] = this.classToType(paramClasses[i]);
        }
        this.retType = this.classToType(constructor.getDeclaringClass());
    }

    private int classToType(Class cl) {
        if (Boolean.TYPE.equals(cl) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NewJavaExpr.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(cl)) {
            return 1;
        }
        if (Byte.TYPE.equals(cl) || (class$java$lang$Byte == null ? (class$java$lang$Byte = NewJavaExpr.class$("java.lang.Byte")) : class$java$lang$Byte).equals(cl)) {
            return 2;
        }
        if (Short.TYPE.equals(cl) || (class$java$lang$Short == null ? (class$java$lang$Short = NewJavaExpr.class$("java.lang.Short")) : class$java$lang$Short).equals(cl)) {
            return 3;
        }
        if (Integer.TYPE.equals(cl) || (class$java$lang$Integer == null ? (class$java$lang$Integer = NewJavaExpr.class$("java.lang.Integer")) : class$java$lang$Integer).equals(cl)) {
            return 4;
        }
        if (Long.TYPE.equals(cl) || (class$java$lang$Long == null ? (class$java$lang$Long = NewJavaExpr.class$("java.lang.Long")) : class$java$lang$Long).equals(cl)) {
            return 5;
        }
        if (Float.TYPE.equals(cl) || (class$java$lang$Float == null ? (class$java$lang$Float = NewJavaExpr.class$("java.lang.Float")) : class$java$lang$Float).equals(cl)) {
            return 6;
        }
        if (Double.TYPE.equals(cl) || (class$java$lang$Double == null ? (class$java$lang$Double = NewJavaExpr.class$("java.lang.Double")) : class$java$lang$Double).equals(cl)) {
            return 7;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = NewJavaExpr.class$("java.lang.String")) : class$java$lang$String).equals(cl)) {
            return 8;
        }
        return 9;
    }

    public boolean isString() {
        return this.retType == 8;
    }

    public boolean isBoolean() {
        return this.retType == 1;
    }

    public boolean isNumber() {
        return this.retType >= 2 && this.retType <= 7;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        Object value = this.evalObject(node, env);
        return String.valueOf(value);
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return NewJavaExpr.toBoolean(this.evalObject(node, env));
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return NewJavaExpr.toDouble(this.evalObject(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        Object[] argArray = new Object[this.args.size()];
        block12: for (int i = 0; i < argArray.length; ++i) {
            Expr expr = (Expr)this.args.get(i);
            switch (this.argTypes[i]) {
                case 1: {
                    argArray[i] = new Boolean(expr.evalBoolean(node, env));
                    continue block12;
                }
                case 2: {
                    argArray[i] = new Byte((byte)expr.evalNumber(node, env));
                    continue block12;
                }
                case 3: {
                    argArray[i] = new Short((short)expr.evalNumber(node, env));
                    continue block12;
                }
                case 4: {
                    argArray[i] = new Integer((int)expr.evalNumber(node, env));
                    continue block12;
                }
                case 5: {
                    argArray[i] = new Long((long)expr.evalNumber(node, env));
                    continue block12;
                }
                case 6: {
                    argArray[i] = new Float((float)expr.evalNumber(node, env));
                    continue block12;
                }
                case 7: {
                    argArray[i] = new Double(expr.evalNumber(node, env));
                    continue block12;
                }
                case 8: {
                    argArray[i] = expr.evalString(node, env);
                    continue block12;
                }
                default: {
                    argArray[i] = expr.evalObject(node, env);
                }
            }
        }
        try {
            return this.constructor.newInstance(argArray);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("java:");
        cb.append(this.constructor.getDeclaringClass().getName());
        cb.append(".new");
        cb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(this.args.get(i));
        }
        cb.append(")");
        return cb.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

