/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class StringExpr
extends Expr {
    private int code;
    private Expr left;
    private Expr right;
    private Expr third;
    private String value;
    private ArrayList args;

    public StringExpr(int code, Expr left, Expr right, Expr third) {
        this.code = code;
        this.left = left;
        this.right = right;
        this.third = third;
    }

    public StringExpr(int code, Expr left, Expr right) {
        this.code = code;
        this.left = left;
        this.right = right;
    }

    public StringExpr(int code, Expr expr) {
        this.code = code;
        this.left = expr;
    }

    public StringExpr(String value) {
        this.code = 0;
        this.value = value;
    }

    public StringExpr(int code, ArrayList args) {
        this.code = code;
        this.args = args;
        if (args.size() > 0) {
            this.left = (Expr)args.get(0);
        }
        if (args.size() > 1) {
            this.right = (Expr)args.get(1);
        }
        if (args.size() > 2) {
            this.third = (Expr)args.get(2);
        }
    }

    public boolean isString() {
        return true;
    }

    public String getValue() {
        return this.value;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        switch (this.code) {
            case 0: {
                return this.value;
            }
            case 41: {
                return this.left.evalString(node, env);
            }
            case 42: {
                CharBuffer cb = CharBuffer.allocate();
                for (int i = 0; i < this.args.size(); ++i) {
                    ((Expr)this.args.get(i)).evalString(cb, node, env);
                }
                return cb.close();
            }
            case 46: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                int index = lstr.indexOf(rstr);
                return index > 0 ? lstr.substring(0, index) : "";
            }
            case 47: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                int index = lstr.indexOf(rstr);
                return index >= 0 ? lstr.substring(index + rstr.length()) : "";
            }
            case 49: {
                String lstr = this.left.evalString(node, env);
                return this.normalize(lstr);
            }
            case 50: {
                String lstr = this.left.evalString(node, env);
                String rstr = this.right.evalString(node, env);
                String tstr = this.third.evalString(node, env);
                return this.translate(lstr, rstr, tstr);
            }
            case 51: {
                return this.left.evalString(node, env);
            }
            case 52: {
                Object lobj = this.left.evalObject(node, env);
                Node nodeValue = StringExpr.toNode(lobj);
                if (nodeValue != null) {
                    return nodeValue.getLocalName();
                }
                return "";
            }
            case 53: {
                Object lobj = this.left.evalObject(node, env);
                Node nodeValue = StringExpr.toNode(lobj);
                if (nodeValue != null) {
                    return nodeValue.getNamespaceURI();
                }
                return "";
            }
            case 54: {
                Object lobj = this.left.evalObject(node, env);
                Node nodeValue = StringExpr.toNode(lobj);
                if (nodeValue != null) {
                    return nodeValue.getNodeName();
                }
                return "";
            }
            case 55: {
                NodeIterator iter = this.left.evalNodeSet(node, env);
                return "G" + String.valueOf(System.identityHashCode(iter.next()));
            }
            case 57: {
                String lstr = this.left.evalString(node, env);
                if (lstr == null) {
                    return "";
                }
                if (lstr.equals("xsl:version")) {
                    return "1.0";
                }
                return "";
            }
            case 45: {
                String lstr = this.left.evalString(node, env);
                if (lstr == null) {
                    lstr = "";
                }
                double start = this.right.evalNumber(node, env) - 1.0;
                double end = lstr.length();
                if (this.third != null) {
                    end = (double)Math.round(start) + this.third.evalNumber(node, env);
                }
                if (Double.isNaN(end) || Double.isNaN(start)) {
                    start = 0.0;
                    end = 0.0;
                }
                if (start < 0.0) {
                    start = 0.0;
                } else if (start > (double)lstr.length()) {
                    start = lstr.length();
                }
                if (end < 0.0) {
                    end = 0.0;
                } else if (end < start) {
                    end = start;
                } else if (end > (double)lstr.length()) {
                    end = lstr.length();
                }
                return lstr.substring((int)(start + 0.5), (int)(end + 0.5));
            }
        }
        throw new RuntimeException("unknown code: " + this.code);
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        String string = this.evalString(node, env);
        return string != null && string.length() > 0;
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return StringExpr.stringToNumber(this.evalString(node, env));
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return this.evalString(node, env);
    }

    private String normalize(String string) {
        int i;
        CharBuffer result = new CharBuffer();
        int len = string.length();
        for (i = 0; i < len && XmlChar.isWhitespace(string.charAt(i)); ++i) {
        }
        boolean lastIsWhitespace = false;
        while (i < len) {
            if (XmlChar.isWhitespace(string.charAt(i))) {
                lastIsWhitespace = true;
            } else if (lastIsWhitespace) {
                result.append(' ');
                result.append(string.charAt(i));
                lastIsWhitespace = false;
            } else {
                result.append(string.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private String translate(String string, String from, String to) {
        CharBuffer result = new CharBuffer();
        block0: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            for (int j = 0; j < from.length(); ++j) {
                if (ch != from.charAt(j)) continue;
                if (to.length() <= j) continue block0;
                result.append(to.charAt(j));
                continue block0;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public String toString() {
        switch (this.code) {
            case 0: {
                CharBuffer cb = CharBuffer.allocate();
                cb.append("'");
                block23: for (int i = 0; i < this.value.length(); ++i) {
                    char ch = this.value.charAt(i);
                    switch (ch) {
                        case '\n': {
                            cb.append("\\n");
                            continue block23;
                        }
                        case '\r': {
                            cb.append("\\r");
                            continue block23;
                        }
                        case '\\': {
                            cb.append("\\\\");
                            continue block23;
                        }
                        case '\'': {
                            cb.append("\\'\\'");
                            continue block23;
                        }
                        case '\"': {
                            cb.append("\\\"");
                            continue block23;
                        }
                        default: {
                            cb.append(ch);
                        }
                    }
                }
                cb.append("'");
                return cb.toString();
            }
            case 41: {
                return "string(" + this.left + ")";
            }
            case 42: {
                String result = "concat(";
                for (int i = 0; i < this.args.size(); ++i) {
                    if (i > 0) {
                        result = result + ", ";
                    }
                    result = result + this.args.get(i);
                }
                return result + ")";
            }
            case 46: {
                return "substring-before(" + this.left + ", " + this.right + ")";
            }
            case 47: {
                return "substring-after(" + this.left + ", " + this.right + ")";
            }
            case 49: {
                return "normalize-space(" + this.left + ")";
            }
            case 50: {
                return "translate(" + this.left + ", " + this.right + ", " + this.third + ")";
            }
            case 51: {
                return "format-number(" + this.left + ")";
            }
            case 52: {
                return "local-part(" + this.left + ")";
            }
            case 53: {
                return "namespace-uri(" + this.left + ")";
            }
            case 54: {
                return "name(" + this.left + ")";
            }
            case 55: {
                return "generate-id(" + this.left + ")";
            }
            case 57: {
                return "system-property(" + this.left + ")";
            }
            case 45: {
                return "substring(" + this.left + "," + this.right + (this.third == null ? "" : "," + this.third) + ")";
            }
        }
        return super.toString();
    }
}

